/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.openjdk.btrace.instr.ClassInfo;

public final class ClassCache {
    private final Map<ClassLoader, Map<ClassInfo.ClassName, ClassInfo>> cacheMap = new WeakHashMap<ClassLoader, Map<ClassInfo.ClassName, ClassInfo>>();
    private final Map<ClassInfo.ClassName, ClassInfo> bootstrapInfos = new HashMap<ClassInfo.ClassName, ClassInfo>(500);

    public static ClassCache getInstance() {
        return Singleton.INSTANCE;
    }

    public ClassInfo get(Class<?> clz) {
        return this.get(clz.getClassLoader(), clz.getName());
    }

    public ClassInfo get(ClassLoader cl, String className) {
        return this.get(cl, new ClassInfo.ClassName(className));
    }

    synchronized ClassInfo get(ClassLoader cl, ClassInfo.ClassName className) {
        Map<ClassInfo.ClassName, ClassInfo> infos = this.getInfos(cl);
        ClassInfo ci = infos.get(className);
        if (ci == null) {
            ci = new ClassInfo(this, cl, className);
            infos.put(className, ci);
        }
        return ci;
    }

    private synchronized Map<ClassInfo.ClassName, ClassInfo> getInfos(ClassLoader cl) {
        if (cl == null) {
            return this.bootstrapInfos;
        }
        Map infos = this.cacheMap.computeIfAbsent(cl, k -> new HashMap(500));
        return infos;
    }

    private static final class Singleton {
        private static final ClassCache INSTANCE = new ClassCache();

        private Singleton() {
        }
    }
}

