/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.instr.VariableMapper;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Handle;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Opcodes;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.libs.org.objectweb.asm.TypePath;

public final class InstrumentingMethodVisitor
extends MethodVisitor
implements MethodInstrumentorHelper {
    private static final Object TOP_EXT = -2;
    private final VariableMapper variableMapper;
    private final SimulatedStack stack = new SimulatedStack();
    private final List<Object> locals = new ArrayList<Object>();
    private final Set<LocalVarSlot> newLocals = new HashSet<LocalVarSlot>(3);
    private final LocalVarTypes localTypes = new LocalVarTypes();
    private final Set<Integer> frameOffsets = new HashSet<Integer>();
    private final Map<Label, SavedState> jumpTargetStates = new HashMap<Label, SavedState>();
    private final Map<Label, Set<Label>> tryCatchHandlerMap = new HashMap<Label, Set<Label>>();
    private final String owner;
    private final String desc;
    private final String name;
    private int argsSize = 0;
    private int localsTailPtr = 0;
    private int pc = 0;
    private int lastFramePc = Integer.MIN_VALUE;

    public InstrumentingMethodVisitor(int access, String owner, String name, String desc, MethodVisitor mv) {
        super(458752, mv);
        this.owner = owner;
        this.name = name;
        this.desc = desc;
        this.initLocals((access & 8) == 0);
        this.variableMapper = new VariableMapper(this.argsSize);
    }

    private static Object toSlotType(Type t) {
        if (t == null) {
            return null;
        }
        switch (t.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Opcodes.INTEGER;
            }
            case 6: {
                return Opcodes.FLOAT;
            }
            case 7: {
                return Opcodes.LONG;
            }
            case 8: {
                return Opcodes.DOUBLE;
            }
        }
        return t == Constants.NULL_TYPE ? Opcodes.NULL : (t == Constants.TOP_TYPE ? Opcodes.TOP : t.getInternalName());
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (this.lastFramePc == this.pc) {
            return;
        }
        this.lastFramePc = this.pc;
        switch (type) {
            case -1: 
            case 0: {
                this.locals.clear();
                this.stack.reset();
                this.locals.addAll(Arrays.asList(local).subList(0, nLocal));
                this.localsTailPtr = nLocal;
                for (int i = 0; i < nStack; ++i) {
                    Object e = stack[i];
                    this.stack.push(e);
                }
                break;
            }
            case 3: {
                this.stack.reset();
                break;
            }
            case 4: {
                this.stack.reset();
                Object e = stack[0];
                this.stack.push(e);
                break;
            }
            case 1: {
                this.stack.reset();
                int top = this.locals.size();
                for (int i = 0; i < nLocal; ++i) {
                    Object e = local[i];
                    if (this.localsTailPtr < top) {
                        this.locals.set(this.localsTailPtr, e);
                    } else {
                        this.locals.add(e);
                    }
                    ++this.localsTailPtr;
                }
                break;
            }
            case 2: {
                this.stack.reset();
                for (int i = 0; i < nLocal; ++i) {
                    this.locals.remove(--this.localsTailPtr);
                }
                break;
            }
        }
        Object[] localsArr = this.computeFrameLocals();
        this.localTypes.replaceWith(localsArr);
        int off = 0;
        for (int i = 0; i < localsArr.length; ++i) {
            Object val = localsArr[i];
            if (val == TOP_EXT) {
                ++off;
                continue;
            }
            if (off <= 0) continue;
            localsArr[i - off] = localsArr[i];
        }
        localsArr = Arrays.copyOf(localsArr, localsArr.length - off);
        Object[] tmpStack = this.stack.toArray(true);
        super.visitFrame(-1, localsArr.length, localsArr, tmpStack.length, tmpStack);
    }

    public void visitMultiANewArrayInsn(String type, int dims) {
        for (int i = 0; i < dims; ++i) {
            this.stack.pop();
        }
        this.stack.push(type);
        super.visitMultiANewArrayInsn(type, dims);
        ++this.pc;
    }

    public void visitLookupSwitchInsn(Label label, int[] ints, Label[] labels) {
        this.stack.pop();
        super.visitLookupSwitchInsn(label, ints, labels);
        ++this.pc;
    }

    public void visitTableSwitchInsn(int i, int i1, Label label, Label ... labels) {
        this.stack.pop();
        super.visitTableSwitchInsn(i, i1, label, labels);
        ++this.pc;
    }

    public void visitLdcInsn(Object o) {
        Type t = Type.getType(o.getClass());
        switch (t.getInternalName()) {
            case "java/lang/Integer": {
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case "java/lang/Long": {
                this.pushToStack(Type.LONG_TYPE);
                break;
            }
            case "java/lang/Byte": {
                this.pushToStack(Type.BYTE_TYPE);
                break;
            }
            case "java/lang/Short": {
                this.pushToStack(Type.SHORT_TYPE);
                break;
            }
            case "java/lang/Character": {
                this.pushToStack(Type.CHAR_TYPE);
                break;
            }
            case "java/lang/Boolean": {
                this.pushToStack(Type.BOOLEAN_TYPE);
                break;
            }
            case "java/lang/Float": {
                this.pushToStack(Type.FLOAT_TYPE);
                break;
            }
            case "java/lang/Double": {
                this.pushToStack(Type.DOUBLE_TYPE);
                break;
            }
            default: {
                this.pushToStack(t);
            }
        }
        super.visitLdcInsn(o);
        ++this.pc;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        ++this.pc;
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.stack.pop();
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.stack.pop();
                this.stack.pop();
            }
        }
        this.jumpTargetStates.put(label, new SavedState(this.variableMapper, this.localTypes, this.stack, this.newLocals, opcode == 167 || opcode == 168 ? 1 : 0));
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle handle, Object ... bsmArgs) {
        Type[] args = Type.getArgumentTypes((String)desc);
        Type ret = Type.getReturnType((String)desc);
        for (int i = args.length - 1; i >= 0; --i) {
            if (args[i].equals((Object)Type.VOID_TYPE)) continue;
            this.popFromStack(args[i]);
        }
        super.visitInvokeDynamicInsn(name, desc, handle, bsmArgs);
        ++this.pc;
        if (!ret.equals((Object)Type.VOID_TYPE)) {
            this.pushToStack(ret);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
        Type[] args = Type.getArgumentTypes((String)desc);
        Type ret = Type.getReturnType((String)desc);
        for (int i = args.length - 1; i >= 0; --i) {
            if (args[i].equals((Object)Type.VOID_TYPE)) continue;
            this.popFromStack(args[i]);
        }
        if (opcode != 184) {
            this.stack.pop();
        }
        super.visitMethodInsn(opcode, owner, name, desc, itfc);
        ++this.pc;
        if (!ret.equals((Object)Type.VOID_TYPE)) {
            this.pushToStack(ret);
        }
        if (opcode == 183 && name.equals("<init>") && this.stack.peek() instanceof Label) {
            this.stack.pop();
            this.pushToStack(Type.getObjectType((String)owner));
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        Type t = Type.getType((String)desc);
        super.visitFieldInsn(opcode, owner, name, desc);
        ++this.pc;
        if (opcode == 181 || opcode == 179) {
            this.popFromStack(t);
        }
        if (opcode == 180 || opcode == 181) {
            this.stack.pop();
        }
        if (opcode == 180 || opcode == 178) {
            this.pushToStack(t);
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        ++this.pc;
        switch (opcode) {
            case 187: {
                this.pushToStack(Type.getObjectType((String)type));
                break;
            }
            case 189: {
                this.stack.pop();
                this.pushToStack(Type.getType((String)("[L" + type + ";")));
                break;
            }
            case 193: {
                this.stack.pop();
                this.pushToStack(Type.BOOLEAN_TYPE);
                break;
            }
            case 192: {
                this.stack.pop();
                this.pushToStack(Type.getObjectType((String)type));
            }
        }
    }

    public void visitVarInsn(int opcode, int var) {
        int size = 1;
        switch (opcode) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                ++size;
            }
        }
        var = this.variableMapper.remap(var, size);
        boolean isPush = false;
        Type opType = null;
        switch (opcode) {
            case 21: {
                opType = Type.INT_TYPE;
                isPush = true;
                break;
            }
            case 22: {
                opType = Type.LONG_TYPE;
                isPush = true;
                break;
            }
            case 23: {
                opType = Type.FLOAT_TYPE;
                isPush = true;
                break;
            }
            case 24: {
                opType = Type.DOUBLE_TYPE;
                isPush = true;
                break;
            }
            case 25: {
                Object o = this.localTypes.getType(var);
                opType = this.fromSlotType(o);
                isPush = true;
                break;
            }
            case 54: {
                opType = Type.INT_TYPE;
                break;
            }
            case 55: {
                opType = Type.LONG_TYPE;
                break;
            }
            case 56: {
                opType = Type.FLOAT_TYPE;
                break;
            }
            case 57: {
                opType = Type.DOUBLE_TYPE;
                break;
            }
            case 58: {
                opType = this.fromSlotType(this.stack.peek());
            }
        }
        assert (opType != null);
        if (isPush) {
            this.pushToStack(opType);
        } else {
            this.popFromStack(opType);
            this.localTypes.setType(var, opType);
        }
        super.visitVarInsn(opcode, var);
        ++this.pc;
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        ++this.pc;
        block0 : switch (opcode) {
            case 16: 
            case 17: {
                this.stack.push(Opcodes.INTEGER);
                break;
            }
            case 188: {
                this.popFromStack(Type.INT_TYPE);
                switch (operand) {
                    case 4: {
                        this.pushToStack(Type.getObjectType((String)"[Z"));
                        break block0;
                    }
                    case 5: {
                        this.pushToStack(Type.getObjectType((String)"[C"));
                        break block0;
                    }
                    case 6: {
                        this.pushToStack(Type.getObjectType((String)"[F"));
                        break block0;
                    }
                    case 7: {
                        this.pushToStack(Type.getObjectType((String)"[D"));
                        break block0;
                    }
                    case 8: {
                        this.pushToStack(Type.getObjectType((String)"[B"));
                        break block0;
                    }
                    case 9: {
                        this.pushToStack(Type.getObjectType((String)"[S"));
                        break block0;
                    }
                    case 10: {
                        this.pushToStack(Type.getObjectType((String)"[I"));
                        break block0;
                    }
                    case 11: {
                        this.pushToStack(Type.getObjectType((String)"[J"));
                    }
                }
            }
        }
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        ++this.pc;
        switch (opcode) {
            case 1: {
                this.stack.push(Opcodes.NULL);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.pushToStack(Type.FLOAT_TYPE);
                break;
            }
            case 9: 
            case 10: {
                this.pushToStack(Type.LONG_TYPE);
                break;
            }
            case 14: 
            case 15: {
                this.pushToStack(Type.DOUBLE_TYPE);
                break;
            }
            case 50: {
                this.stack.pop();
                Object target = this.stack.pop();
                if (target instanceof String) {
                    Type t;
                    String typeStr = (String)target;
                    if (typeStr.startsWith("[")) {
                        if (typeStr.contains("/") && !typeStr.endsWith(";")) {
                            typeStr = typeStr + ";";
                        }
                        t = Type.getType((String)typeStr).getElementType();
                    } else {
                        t = Type.getObjectType((String)typeStr);
                    }
                    this.pushToStack(t);
                    break;
                }
                if (target == Opcodes.NULL) {
                    this.pushToStack(Constants.NULL_TYPE);
                    break;
                }
                this.pushToStack(Constants.OBJECT_TYPE);
                break;
            }
            case 46: {
                this.stack.pop();
                this.stack.pop();
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 48: {
                this.stack.pop();
                this.stack.pop();
                this.pushToStack(Type.FLOAT_TYPE);
                break;
            }
            case 51: {
                this.stack.pop();
                this.stack.pop();
                this.pushToStack(Type.BYTE_TYPE);
                break;
            }
            case 52: {
                this.stack.pop();
                this.stack.pop();
                this.pushToStack(Type.CHAR_TYPE);
                break;
            }
            case 53: {
                this.stack.pop();
                this.stack.pop();
                this.pushToStack(Type.SHORT_TYPE);
                break;
            }
            case 47: {
                this.stack.pop();
                this.stack.pop();
                this.pushToStack(Type.LONG_TYPE);
                break;
            }
            case 49: {
                this.stack.pop();
                this.stack.pop();
                this.pushToStack(Type.DOUBLE_TYPE);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 87: {
                this.stack.pop1();
                break;
            }
            case 88: {
                this.stack.pop1();
                this.stack.pop1();
                break;
            }
            case 89: {
                this.stack.push1(this.stack.peek());
                break;
            }
            case 90: {
                Object x = this.stack.pop1();
                Object y = this.stack.pop1();
                this.stack.push1(x);
                this.stack.push1(y);
                this.stack.push1(x);
                break;
            }
            case 91: {
                Object x = this.stack.pop1();
                Object y = this.stack.pop1();
                Object z = this.stack.pop1();
                this.stack.push1(x);
                this.stack.push1(z);
                this.stack.push1(y);
                this.stack.push1(x);
                break;
            }
            case 92: {
                Object x = this.stack.pop1();
                Object y = this.stack.peek();
                this.stack.push1(x);
                this.stack.push1(y);
                this.stack.push1(x);
                break;
            }
            case 93: {
                Object x2 = this.stack.pop1();
                Object x1 = this.stack.pop1();
                Object y = this.stack.pop1();
                this.stack.push1(x1);
                this.stack.push1(x2);
                this.stack.push1(y);
                this.stack.push1(x1);
                this.stack.push1(x2);
                break;
            }
            case 94: {
                Object x2 = this.stack.pop1();
                Object x1 = this.stack.pop1();
                Object y2 = this.stack.pop1();
                Object y1 = this.stack.pop1();
                this.stack.push1(x1);
                this.stack.push1(x2);
                this.stack.push1(y1);
                this.stack.push1(y2);
                this.stack.push1(x1);
                this.stack.push1(x2);
                break;
            }
            case 95: {
                Object x = this.stack.pop1();
                Object y = this.stack.pop1();
                this.stack.push1(x);
                this.stack.push1(y);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                this.popFromStack(Type.INT_TYPE);
                this.popFromStack(Type.INT_TYPE);
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                this.popFromStack(Type.FLOAT_TYPE);
                this.popFromStack(Type.FLOAT_TYPE);
                this.pushToStack(Type.FLOAT_TYPE);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                this.popFromStack(Type.LONG_TYPE);
                this.popFromStack(Type.LONG_TYPE);
                this.pushToStack(Type.LONG_TYPE);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.popFromStack(Type.DOUBLE_TYPE);
                this.popFromStack(Type.DOUBLE_TYPE);
                break;
            }
            case 133: {
                this.popFromStack(Type.INT_TYPE);
                this.pushToStack(Type.LONG_TYPE);
                break;
            }
            case 134: {
                this.popFromStack(Type.INT_TYPE);
                this.pushToStack(Type.FLOAT_TYPE);
                break;
            }
            case 145: {
                this.popFromStack(Type.INT_TYPE);
                this.pushToStack(Type.BYTE_TYPE);
                break;
            }
            case 146: {
                this.popFromStack(Type.INT_TYPE);
                this.pushToStack(Type.CHAR_TYPE);
                break;
            }
            case 147: {
                this.popFromStack(Type.INT_TYPE);
                this.pushToStack(Type.SHORT_TYPE);
                break;
            }
            case 135: {
                this.popFromStack(Type.INT_TYPE);
                this.pushToStack(Type.DOUBLE_TYPE);
                break;
            }
            case 136: {
                this.popFromStack(Type.LONG_TYPE);
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 137: {
                this.popFromStack(Type.LONG_TYPE);
                this.pushToStack(Type.FLOAT_TYPE);
                break;
            }
            case 138: {
                this.popFromStack(Type.LONG_TYPE);
                this.pushToStack(Type.DOUBLE_TYPE);
                break;
            }
            case 139: {
                this.popFromStack(Type.FLOAT_TYPE);
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 140: {
                this.popFromStack(Type.FLOAT_TYPE);
                this.pushToStack(Type.LONG_TYPE);
                break;
            }
            case 141: {
                this.popFromStack(Type.FLOAT_TYPE);
                this.pushToStack(Type.DOUBLE_TYPE);
                break;
            }
            case 142: {
                this.popFromStack(Type.DOUBLE_TYPE);
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 144: {
                this.popFromStack(Type.DOUBLE_TYPE);
                this.pushToStack(Type.FLOAT_TYPE);
                break;
            }
            case 143: {
                this.popFromStack(Type.DOUBLE_TYPE);
                this.pushToStack(Type.LONG_TYPE);
                break;
            }
            case 148: {
                this.popFromStack(Type.LONG_TYPE);
                this.popFromStack(Type.LONG_TYPE);
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 149: 
            case 150: {
                this.popFromStack(Type.FLOAT_TYPE);
                this.popFromStack(Type.FLOAT_TYPE);
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 151: 
            case 152: {
                this.popFromStack(Type.DOUBLE_TYPE);
                this.popFromStack(Type.DOUBLE_TYPE);
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 172: {
                this.popFromStack(Type.INT_TYPE);
                break;
            }
            case 173: {
                this.popFromStack(Type.LONG_TYPE);
                break;
            }
            case 174: {
                this.popFromStack(Type.FLOAT_TYPE);
                break;
            }
            case 175: {
                this.popFromStack(Type.DOUBLE_TYPE);
                break;
            }
            case 176: {
                this.popFromStack(Type.getReturnType((String)this.desc));
                break;
            }
            case 191: {
                this.popFromStack(Constants.THROWABLE_TYPE);
                break;
            }
            case 190: {
                this.stack.pop();
                this.pushToStack(Type.INT_TYPE);
                break;
            }
            case 194: 
            case 195: {
                this.stack.pop();
            }
        }
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(this.variableMapper.remap(var, 1), increment);
        ++this.pc;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        int newIndex = this.variableMapper.map(index);
        if (newIndex != -1) {
            super.visitLocalVariable(name, desc, signature, start, end, newIndex == Integer.MIN_VALUE ? 0 : newIndex);
        }
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        Type t = Type.getType((String)desc);
        int cnt = 0;
        int[] newIndex = new int[index.length];
        for (int i = 0; i < newIndex.length; ++i) {
            int idx = this.variableMapper.map(index[i]);
            if (idx == -1) continue;
            newIndex[cnt++] = idx;
        }
        return super.visitLocalVariableAnnotation(typeRef, typePath, start, end, Arrays.copyOf(newIndex, cnt), desc, visible);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String exception) {
        this.addTryCatchHandler(start, handler);
        super.visitTryCatchBlock(start, end, handler, exception);
    }

    public void visitLabel(Label label) {
        Set<Label> handlers;
        SavedState ss = this.jumpTargetStates.get(label);
        if (ss != null) {
            if (ss.kind != 0) {
                this.reset();
            }
            this.localTypes.mergeWith(ss.lvTypes.toArray());
            this.stack.replaceWith(ss.sStack.toArray());
            if (ss.kind == 2) {
                this.stack.push(InstrumentingMethodVisitor.toSlotType(Constants.THROWABLE_TYPE));
            }
            for (LocalVarSlot lvs : this.newLocals) {
                if (ss.newLocals.contains(lvs)) continue;
                lvs.expire();
            }
            this.newLocals.clear();
            this.newLocals.addAll(ss.newLocals);
        }
        if ((handlers = this.tryCatchHandlerMap.get(label)) != null) {
            for (Label handler : handlers) {
                if (this.jumpTargetStates.containsKey(handler)) continue;
                this.jumpTargetStates.put(handler, new SavedState(this.variableMapper, this.localTypes, this.stack, this.newLocals, 2));
            }
        }
        super.visitLabel(label);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(Math.max(this.stack.maxStack, maxStack), this.localTypes.maxSize());
    }

    @Override
    public final void insertFrameReplaceStack(Label l, Type ... stackTypes) {
        if (this.pc == this.lastFramePc) {
            return;
        }
        this.lastFramePc = this.pc;
        if (!this.frameOffsets.add(l.getOffset())) {
            return;
        }
        Object[] localsArr = InstrumentingMethodVisitor.trimLocalVars(this.localTypes.toArray(true));
        this.stack.reset();
        for (Type t : stackTypes) {
            this.stack.push(InstrumentingMethodVisitor.toSlotType(t));
        }
        Object[] stackSlots = this.stack.toArray(true);
        super.visitFrame(-1, localsArr.length, localsArr, stackSlots.length, stackSlots);
    }

    @Override
    public void insertFrameAppendStack(Label l, Type ... stackTypes) {
        if (this.pc == this.lastFramePc) {
            return;
        }
        this.lastFramePc = this.pc;
        if (!this.frameOffsets.add(l.getOffset())) {
            return;
        }
        Object[] localsArr = InstrumentingMethodVisitor.trimLocalVars(this.localTypes.toArray(true));
        for (Type t : stackTypes) {
            this.stack.push(InstrumentingMethodVisitor.toSlotType(t));
        }
        Object[] stackSlots = this.stack.toArray(true);
        super.visitFrame(-1, localsArr.length, localsArr, stackSlots.length, stackSlots);
    }

    @Override
    public void insertFrameSameStack(Label l) {
        if (this.pc == this.lastFramePc) {
            return;
        }
        if (!this.frameOffsets.add(l.getOffset()) || !this.jumpTargetStates.containsKey(l)) {
            return;
        }
        this.lastFramePc = this.pc;
        Object[] localsArr = InstrumentingMethodVisitor.trimLocalVars(this.localTypes.toArray(true));
        Object[] stackSlots = this.stack.toArray(true);
        super.visitFrame(-1, localsArr.length, localsArr, stackSlots.length, stackSlots);
    }

    @Override
    public void addTryCatchHandler(Label start, Label handler) {
        Set<Label> handlers = this.tryCatchHandlerMap.get(start);
        if (handlers == null) {
            handlers = new HashSet<Label>();
        }
        handlers.add(handler);
        this.tryCatchHandlerMap.put(start, handlers);
    }

    @Override
    public int storeAsNew() {
        Type t = this.fromSlotType(this.peekFromStack());
        int idx = this.newVar(t);
        this.visitVarInsn(t.getOpcode(54), idx);
        return idx;
    }

    @Override
    public final int newVar(Type t) {
        int size = t == Constants.NULL_TYPE ? 1 : t.getSize();
        int idx = this.variableMapper.newVarIdx(size);
        int var = VariableMapper.unmask(idx == Integer.MIN_VALUE ? 0 : idx);
        this.newLocals.add(new LocalVarSlot(var, InstrumentingMethodVisitor.toSlotType(t)));
        this.localTypes.setType(var, t);
        return idx;
    }

    private void initLocals(boolean isInstance) {
        int nextMappedVar = 0;
        if (isInstance) {
            this.locals.add(this.owner);
            ++nextMappedVar;
            ++this.localsTailPtr;
        }
        for (Type t : Type.getArgumentTypes((String)this.desc)) {
            this.locals.add(InstrumentingMethodVisitor.toSlotType(t));
            nextMappedVar += t.getSize();
            ++this.localsTailPtr;
        }
        this.localTypes.replaceWith(this.locals.toArray(new Object[0]));
        this.argsSize = nextMappedVar;
    }

    private Object[] computeFrameLocals() {
        return InstrumentingMethodVisitor.computeFrameLocals(this.argsSize, this.locals, this.newLocals, this.variableMapper);
    }

    static Object[] computeFrameLocals(int argsSize, List<Object> locals, Set<LocalVarSlot> newLocals, VariableMapper variableMapper) {
        Object[] localsArr;
        newLocals = newLocals != null ? newLocals : Collections.emptySet();
        int nextMappedVar = variableMapper.getNextMappedVar();
        if (nextMappedVar > argsSize) {
            int arrSize = Math.max(locals.size(), nextMappedVar);
            localsArr = new Object[arrSize];
            int idx = 0;
            for (Object e : locals) {
                if (idx < argsSize) {
                    localsArr[idx] = e;
                    if (e == Opcodes.LONG || e == Opcodes.DOUBLE) {
                        localsArr[++idx] = TOP_EXT;
                    }
                } else {
                    int var = variableMapper.map(idx);
                    if (var != -1) {
                        localsArr[var] = e;
                        if (e == Opcodes.LONG || e == Opcodes.DOUBLE) {
                            int off = var + 1;
                            if (off == localsArr.length) {
                                localsArr = Arrays.copyOf(localsArr, localsArr.length + 1);
                            }
                            localsArr[off] = TOP_EXT;
                            ++idx;
                        }
                    }
                }
                ++idx;
            }
            for (LocalVarSlot lvs : newLocals) {
                int ptr = lvs.idx != Integer.MIN_VALUE ? lvs.idx : 0;
                Object object = localsArr[ptr] = lvs.isExpired() ? Opcodes.TOP : lvs.type;
                if (lvs.type != Opcodes.LONG && lvs.type != Opcodes.DOUBLE) continue;
                localsArr[ptr + 1] = TOP_EXT;
            }
        } else {
            localsArr = locals.toArray(new Object[0]);
        }
        for (int m : variableMapper.mappings()) {
            if (m == 0 || localsArr[m] != null) continue;
            localsArr[m] = Opcodes.TOP;
        }
        localsArr = InstrumentingMethodVisitor.trimLocalVars(localsArr);
        return localsArr;
    }

    private static Object[] trimLocalVars(Object[] localsArr) {
        Object[] tmp = new Object[localsArr.length];
        int idx = 0;
        int firstEmpty = -1;
        int emptyRunLen = 0;
        for (Object o : localsArr) {
            if (o == null) {
                if (firstEmpty == -1) {
                    firstEmpty = idx;
                }
                ++emptyRunLen;
                tmp[idx++] = Opcodes.TOP;
                continue;
            }
            if (o == Opcodes.TOP) {
                if (firstEmpty == -1) {
                    firstEmpty = idx;
                }
                ++emptyRunLen;
                tmp[idx++] = Opcodes.TOP;
                continue;
            }
            firstEmpty = -1;
            emptyRunLen = 0;
            tmp[idx++] = o;
        }
        if (firstEmpty > -1 && firstEmpty + emptyRunLen == localsArr.length) {
            return Arrays.copyOf(tmp, firstEmpty);
        }
        return Arrays.copyOf(tmp, idx);
    }

    private void reset() {
        this.localTypes.reset();
        this.stack.reset();
        this.newLocals.clear();
    }

    private Object peekFromStack() {
        Object o = this.stack.peek();
        if (o == null || o == TOP_EXT) {
            o = this.stack.peekX1();
        }
        return o;
    }

    private Object popFromStack(Type t) {
        return this.stack.pop();
    }

    private void pushToStack(Type t) {
        this.stack.push(InstrumentingMethodVisitor.toSlotType(t));
    }

    private Type fromSlotType(Object slotType) {
        if (slotType == Opcodes.INTEGER) {
            return Type.INT_TYPE;
        }
        if (slotType == Opcodes.FLOAT) {
            return Type.FLOAT_TYPE;
        }
        if (slotType == Opcodes.LONG) {
            return Type.LONG_TYPE;
        }
        if (slotType == Opcodes.DOUBLE) {
            return Type.DOUBLE_TYPE;
        }
        if (slotType == Opcodes.UNINITIALIZED_THIS) {
            return Type.getObjectType((String)this.owner);
        }
        if (slotType == Opcodes.NULL) {
            return Constants.NULL_TYPE;
        }
        if (slotType == Opcodes.TOP) {
            return Constants.TOP_TYPE;
        }
        if (slotType instanceof Integer) {
            DebugSupport.warning((String)("Unknown slot type: " + slotType));
            return Constants.OBJECT_TYPE;
        }
        return slotType != null ? Type.getObjectType((String)((String)slotType)) : Constants.OBJECT_TYPE;
    }

    private static final class SavedState {
        static final int CONDITIONAL = 0;
        static final int UNCONDITIONAL = 1;
        static final int EXCEPTION = 2;
        private final VariableMapper mapper;
        private final LocalVarTypes lvTypes;
        private final SimulatedStack sStack;
        private final Collection<LocalVarSlot> newLocals;
        private final int kind;

        SavedState(VariableMapper mapper, LocalVarTypes lvTypes, SimulatedStack sStack, Collection<LocalVarSlot> newLocals) {
            this(mapper, lvTypes, sStack, newLocals, 0);
        }

        SavedState(VariableMapper mapper, LocalVarTypes lvTypes, SimulatedStack sStack, Collection<LocalVarSlot> newLocals, int kind) {
            this.mapper = mapper.mirror();
            this.lvTypes = new LocalVarTypes(lvTypes.toArray());
            this.sStack = new SimulatedStack(sStack.toArray());
            this.newLocals = new HashSet<LocalVarSlot>(newLocals);
            this.kind = kind;
        }
    }

    private static class LocalVarTypes {
        private static final int DEFAULT_SIZE = 4;
        private Object[] locals;
        private int lastVarPtr = -1;
        private int maxVarPtr = -1;

        LocalVarTypes() {
            this.locals = new Object[4];
        }

        LocalVarTypes(Object[] vals) {
            this.replaceWith(vals);
        }

        public void setType(int idx, Type t) {
            int padding = t.getSize() - 1;
            if (idx + padding >= this.locals.length) {
                this.locals = Arrays.copyOf(this.locals, Math.round((float)(idx + padding + 1) * 1.5f));
            }
            this.locals[idx] = InstrumentingMethodVisitor.toSlotType(t);
            if (padding == 1) {
                this.locals[idx + 1] = TOP_EXT;
            }
            this.setLastVarPtr(Math.max(idx + padding, this.lastVarPtr));
        }

        public void setUninitialized(int idx) {
            if (idx >= this.locals.length) {
                this.locals = Arrays.copyOf(this.locals, this.locals.length * 2);
            }
            this.locals[idx] = Opcodes.UNINITIALIZED_THIS;
            this.setLastVarPtr(Math.max(idx, this.lastVarPtr));
        }

        public Object getType(int idx) {
            return idx < this.locals.length ? this.locals[idx] : null;
        }

        public final void replaceWith(Object[] other) {
            Object[] arr = new Object[other.length * 2];
            int idx = 0;
            for (int i = 0; i < other.length; ++i) {
                int lookup;
                Object o = other[i];
                arr[idx++] = o;
                if (o != Opcodes.LONG && o != Opcodes.DOUBLE || (lookup = i + 1) != other.length && other[lookup] == TOP_EXT) continue;
                arr[idx++] = TOP_EXT;
            }
            this.locals = Arrays.copyOf(arr, idx);
            this.setLastVarPtr(idx - 1);
        }

        public void mergeWith(Object[] other) {
            Object[] arr = new Object[Math.max(other.length * 2, Math.max(this.lastVarPtr + 1, 4))];
            int idx = 0;
            for (Object o : other) {
                arr[idx++] = o == null ? Opcodes.TOP : o;
            }
            while (idx <= this.lastVarPtr) {
                arr[idx++] = Opcodes.TOP;
            }
            this.locals = arr;
            this.setLastVarPtr(idx - 1);
        }

        public Object[] toArray() {
            return this.toArray(false);
        }

        public Object[] toArray(boolean compress) {
            Object[] ret = new Object[this.size()];
            int localCnt = 0;
            for (int i = 0; i <= this.lastVarPtr; ++i) {
                Object o = this.locals[i];
                if (o != null) {
                    if (compress && o == TOP_EXT) continue;
                    ret[localCnt++] = o;
                    continue;
                }
                ret[localCnt++] = Opcodes.TOP;
            }
            return Arrays.copyOf(ret, localCnt);
        }

        public void reset() {
            this.locals = new Object[4];
            this.setLastVarPtr(-1);
        }

        public int size() {
            return this.lastVarPtr + 1;
        }

        public int maxSize() {
            return this.maxVarPtr + 1;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        private void setLastVarPtr(int ptr) {
            this.lastVarPtr = ptr;
            this.maxVarPtr = Math.max(this.lastVarPtr, this.maxVarPtr);
        }
    }

    private static final class SimulatedStack {
        private static final int DEFAULT_CAPACITY = 16;
        private int stackPtr = 0;
        private int maxStack = 0;
        private Object[] stack = new Object[16];

        public SimulatedStack() {
        }

        SimulatedStack(Object[] other) {
            this.replaceWith(other);
        }

        private void fitResize(int ptr) {
            if (ptr >= this.stack.length) {
                this.stack = Arrays.copyOf(this.stack, Math.max(this.stack.length * 2, this.stackPtr + 1));
            }
        }

        public void push1(Object val) {
            this.fitResize(this.stackPtr);
            this.stack[this.stackPtr++] = val;
            this.maxStack = Math.max(this.stackPtr, this.maxStack);
        }

        public void push(Object val) {
            this.fitResize(this.stackPtr);
            this.stack[this.stackPtr++] = val;
            if (val == Opcodes.LONG || val == Opcodes.DOUBLE) {
                this.fitResize(this.stackPtr);
                this.stack[this.stackPtr++] = TOP_EXT;
            }
            this.maxStack = Math.max(this.stackPtr, this.maxStack);
        }

        public Object pop1() {
            if (this.hasData()) {
                return this.stack[--this.stackPtr];
            }
            return Opcodes.TOP;
        }

        public Object pop() {
            if (this.hasData()) {
                Object val;
                if ((val = this.stack[--this.stackPtr]) == TOP_EXT) {
                    val = this.stack[--this.stackPtr];
                }
                return val;
            }
            return Opcodes.TOP;
        }

        public Object peek() {
            if (this.hasData()) {
                return this.stack[this.stackPtr - 1];
            }
            return Opcodes.TOP;
        }

        public Object peekX1() {
            if (this.stackPtr > 1) {
                return this.stack[this.stackPtr - 2];
            }
            return Opcodes.TOP;
        }

        public boolean hasData() {
            return this.stackPtr != 0;
        }

        public int size() {
            return this.stackPtr;
        }

        public void reset() {
            this.stackPtr = 0;
            this.stack = new Object[16];
        }

        public Object[] toArray() {
            return this.toArray(false);
        }

        public Object[] toArray(boolean compress) {
            Object[] ret = new Object[this.stackPtr];
            int localCnt = 0;
            for (int i = 0; i < this.stackPtr; ++i) {
                Object o = this.stack[i];
                if (o == null || compress && o == TOP_EXT) continue;
                ret[localCnt++] = o;
            }
            return Arrays.copyOf(ret, localCnt);
        }

        public void replaceWith(Object[] other) {
            if (other.length > 0) {
                Object[] arr = new Object[other.length * 2];
                int idx = 0;
                for (int ptr = 0; ptr < other.length; ++ptr) {
                    int next;
                    Object o = other[ptr];
                    arr[idx++] = o;
                    if (o != Opcodes.DOUBLE && o != Opcodes.LONG || (next = ptr + 1) < other.length && (other[next] == null || other[next] == TOP_EXT)) continue;
                    arr[idx++] = TOP_EXT;
                }
                this.stack = Arrays.copyOf(arr, idx);
                this.stackPtr = idx;
            } else {
                this.reset();
            }
            this.maxStack = Math.max(this.stackPtr, this.maxStack);
        }
    }

    static final class LocalVarSlot {
        final int idx;
        final Object type;
        private boolean expired = false;

        LocalVarSlot(int idx, Object type) {
            this.idx = Math.abs(idx);
            this.type = type;
        }

        void expire() {
            this.expired = true;
        }

        boolean isExpired() {
            return this.expired;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + this.idx;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalVarSlot other = (LocalVarSlot)obj;
            return this.idx == other.idx;
        }
    }
}

