/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.MethodID;
import org.openjdk.btrace.core.annotations.Kind;
import org.openjdk.btrace.core.annotations.Sampled;
import org.openjdk.btrace.core.annotations.Where;
import org.openjdk.btrace.core.types.AnyType;
import org.openjdk.btrace.instr.ArrayAccessInstrumentor;
import org.openjdk.btrace.instr.ArrayAllocInstrumentor;
import org.openjdk.btrace.instr.Assembler;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.CatchInstrumentor;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.instr.CopyingVisitor;
import org.openjdk.btrace.instr.ErrorReturnInstrumentor;
import org.openjdk.btrace.instr.FieldAccessInstrumentor;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.InstrumentingMethodVisitor;
import org.openjdk.btrace.instr.LineNumberInstrumentor;
import org.openjdk.btrace.instr.Location;
import org.openjdk.btrace.instr.MethodCallInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.instr.MethodReturnInstrumentor;
import org.openjdk.btrace.instr.ObjectAllocInstrumentor;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.instr.SynchronizedInstrumentor;
import org.openjdk.btrace.instr.ThrowInstrumentor;
import org.openjdk.btrace.instr.TypeCheckInstrumentor;
import org.openjdk.btrace.instr.TypeUtils;
import org.openjdk.btrace.instr.templates.TemplateExpanderVisitor;
import org.openjdk.btrace.instr.templates.impl.MethodTrackingExpander;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Handle;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;

public class Instrumentor
extends ClassVisitor {
    private final BTraceProbe bcn;
    private final ClassLoader cl;
    private final Collection<OnMethod> applicableOnMethods;
    private final Set<OnMethod> calledOnMethods = new HashSet<OnMethod>();
    private String className;
    private String superName;
    private final boolean useHiddenClasses;

    private Instrumentor(ClassLoader cl, BTraceProbe bcn, Collection<OnMethod> applicables, ClassVisitor cv) {
        super(458752, cv);
        this.cl = cl;
        this.bcn = bcn;
        BTraceRuntime.Impl rt = bcn.getRuntime();
        this.useHiddenClasses = rt != null && rt.version() >= 15;
        this.applicableOnMethods = applicables;
    }

    static final Instrumentor create(BTraceClassReader cr, BTraceProbe bcn, ClassVisitor cv, ClassLoader cl) {
        if (cr.isInterface()) {
            return null;
        }
        Collection<OnMethod> applicables = bcn.getApplicableHandlers(cr);
        if (applicables != null && !applicables.isEmpty()) {
            return new Instrumentor(cl, bcn, applicables, cv);
        }
        return null;
    }

    private static String getLevelStrSafe(OnMethod om) {
        return om.getLevel() != null ? om.getLevel().getValue().toString() : "";
    }

    private static void reportPatternSyntaxException(String pattern) {
        System.err.println("btrace ERROR: invalid regex pattern - " + pattern);
    }

    public final boolean hasMatch() {
        return !this.calledOnMethods.isEmpty();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.superName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        ArrayList<OnMethod> appliedOnMethods = new ArrayList<OnMethod>();
        if (this.applicableOnMethods.isEmpty() || (access & 0x400) != 0 || name.startsWith("$btrace$")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        final HashSet<OnMethod> annotationMatchers = new HashSet<OnMethod>();
        for (OnMethod om : this.applicableOnMethods) {
            if (om.getLocation().getValue() == Kind.LINE) {
                appliedOnMethods.add(om);
                continue;
            }
            if (om.isMethodAnnotationMatcher()) {
                annotationMatchers.add(om);
                continue;
            }
            String methodName = om.getMethod();
            boolean regexMatch = om.isMethodRegexMatcher();
            if (methodName.isEmpty()) {
                methodName = ".*";
                regexMatch = true;
            }
            if (methodName.equals("#")) {
                methodName = om.getTargetName();
            }
            if (methodName.equals(name) && this.typeMatches(om.getType(), desc, om.isExactTypeMatch())) {
                appliedOnMethods.add(om);
                continue;
            }
            if (!regexMatch) continue;
            try {
                if (!name.matches(methodName) || !this.typeMatches(om.getType(), desc, om.isExactTypeMatch())) continue;
                appliedOnMethods.add(om);
            }
            catch (PatternSyntaxException pse) {
                Instrumentor.reportPatternSyntaxException(name);
            }
        }
        if (annotationMatchers.isEmpty() && appliedOnMethods.isEmpty()) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        final InstrumentingMethodVisitor mHelper = new InstrumentingMethodVisitor(access, this.className, name, desc, methodVisitor);
        methodVisitor = mHelper;
        methodVisitor = new TemplateExpanderVisitor(methodVisitor, mHelper, this.bcn, this.className, name, desc);
        for (OnMethod om : appliedOnMethods) {
            methodVisitor = this.instrumentorFor(om, methodVisitor, mHelper, access, name, desc);
        }
        return new MethodVisitor(458752, methodVisitor){

            public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                for (OnMethod om : annotationMatchers) {
                    String extAnnoName = Type.getType((String)annoDesc).getClassName();
                    String annoName = om.getMethod();
                    if (om.isMethodRegexMatcher()) {
                        try {
                            if (!extAnnoName.matches(annoName)) continue;
                            this.mv = Instrumentor.this.instrumentorFor(om, this.mv, mHelper, access, name, desc);
                        }
                        catch (PatternSyntaxException pse) {
                            Instrumentor.reportPatternSyntaxException(extAnnoName);
                        }
                        continue;
                    }
                    if (!annoName.equals(extAnnoName)) continue;
                    this.mv = Instrumentor.this.instrumentorFor(om, this.mv, mHelper, access, name, desc);
                }
                return this.mv.visitAnnotation(annoDesc, visible);
            }
        };
    }

    private String getMethodOrFieldName(boolean fqn, int opcode, String owner, String name, String desc) {
        StringBuilder mName = new StringBuilder();
        if (fqn) {
            switch (opcode) {
                case 186: {
                    mName.append("dynamic");
                    break;
                }
                case 185: {
                    mName.append("interface");
                    break;
                }
                case 183: {
                    mName.append("special");
                    break;
                }
                case 184: {
                    mName.append("static");
                    break;
                }
                case 182: {
                    mName.append("virtual");
                    break;
                }
                case 178: 
                case 179: {
                    mName.append("static field");
                    break;
                }
                case 180: 
                case 181: {
                    mName.append("field");
                }
            }
            mName.append(' ');
            mName.append(TypeUtils.descriptorToSimplified(desc, owner, name));
        } else {
            mName.append(name);
        }
        return mName.toString();
    }

    private MethodVisitor instrumentorFor(final OnMethod om, MethodVisitor mv, MethodInstrumentorHelper mHelper, int access, final String name, final String desc) {
        final Location loc = om.getLocation();
        final Where where = loc.getWhere();
        final Type[] actionArgTypes = Type.getArgumentTypes((String)om.getTargetDescriptor());
        final int numActionArgs = actionArgTypes.length;
        switch (loc.getValue()) {
            case ARRAY_GET: {
                return new ArrayAccessInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    private final int INDEX_PTR = 0;
                    private final int INSTANCE_PTR = 1;
                    final int[] argsIndex;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.INDEX_PTR = 0;
                        this.INSTANCE_PTR = 1;
                        this.argsIndex = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
                    }

                    @Override
                    protected void onBeforeArrayLoad(int opcode) {
                        MethodInstrumentor.ValidationResult vr;
                        Type retType;
                        Type arrtype = TypeUtils.getArrayType(opcode);
                        if (this.locationTypeMismatch(loc, arrtype, retType = TypeUtils.getElementType(opcode))) {
                            return;
                        }
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getTargetInstanceParameter(), arrtype);
                        if (where == Where.AFTER) {
                            this.addExtraTypeInfo(om.getReturnParameter(), retType);
                        }
                        if ((vr = this.validateArguments(om, actionArgTypes, new Type[]{Type.INT_TYPE})).isValid()) {
                            if (!vr.isAny()) {
                                this.asm.dup2();
                                this.argsIndex[0] = this.storeAsNew();
                                this.argsIndex[1] = this.storeAsNew();
                            }
                            Label l = this.levelCheckBefore(om, Instrumentor.this.bcn.getClassName(true));
                            if (where == Where.BEFORE) {
                                this.loadArguments(this.localVarArg(vr.getArgIdx(0), Type.INT_TYPE, this.argsIndex[0]), this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.argsIndex[1]), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                            }
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }

                    @Override
                    protected void onAfterArrayLoad(int opcode) {
                        if (where == Where.AFTER) {
                            Type retType;
                            Type arrtype = TypeUtils.getArrayType(opcode);
                            if (this.locationTypeMismatch(loc, arrtype, retType = TypeUtils.getElementType(opcode))) {
                                return;
                            }
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), arrtype);
                            this.addExtraTypeInfo(om.getReturnParameter(), retType);
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Type.INT_TYPE});
                            if (vr.isValid()) {
                                Type actionArgRetType;
                                Label l = this.levelCheckAfter(om, Instrumentor.this.bcn.getClassName(true));
                                int retValIndex = -1;
                                Type type = actionArgRetType = om.getReturnParameter() != -1 ? actionArgTypes[om.getReturnParameter()] : Type.VOID_TYPE;
                                if (om.getReturnParameter() != -1) {
                                    this.asm.dupArrayValue(opcode);
                                    retValIndex = this.storeNewLocal(retType);
                                }
                                this.loadArguments(this.localVarArg(vr.getArgIdx(0), Type.INT_TYPE, this.argsIndex[0]), this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.argsIndex[1]), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.localVarArg(om.getReturnParameter(), retType, retValIndex, TypeUtils.isAnyType(actionArgRetType)), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                                if (l != null) {
                                    this.mv.visitLabel(l);
                                    this.insertFrameSameStack(l);
                                }
                            }
                        }
                    }
                };
            }
            case ARRAY_SET: {
                return new ArrayAccessInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    private final int INDEX_PTR = 0;
                    private final int VALUE_PTR = 1;
                    private final int INSTANCE_PTR = 2;
                    final int[] argsIndex;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.INDEX_PTR = 0;
                        this.VALUE_PTR = 1;
                        this.INSTANCE_PTR = 2;
                        this.argsIndex = new int[]{-1, -1, -1, -1};
                    }

                    @Override
                    protected void onBeforeArrayStore(int opcode) {
                        Type elementType = TypeUtils.getElementType(opcode);
                        Type arrayType = TypeUtils.getArrayType(opcode);
                        if (this.locationTypeMismatch(loc, arrayType, elementType)) {
                            return;
                        }
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getTargetInstanceParameter(), arrayType);
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Type.INT_TYPE, elementType});
                        if (vr.isValid()) {
                            Type argElementType = Type.VOID_TYPE;
                            if (!vr.isAny()) {
                                int elementIdx = vr.getArgIdx(1);
                                argElementType = elementIdx > -1 ? actionArgTypes[elementIdx] : Type.VOID_TYPE;
                                this.argsIndex[1] = this.storeAsNew();
                                this.asm.dup2();
                                this.argsIndex[0] = this.storeAsNew();
                                this.argsIndex[2] = this.storeAsNew();
                                this.asm.loadLocal(elementType, this.argsIndex[1]);
                            }
                            Label l = this.levelCheckBefore(om, Instrumentor.this.bcn.getClassName(true));
                            if (where == Where.BEFORE) {
                                this.loadArguments(this.localVarArg(om.getTargetInstanceParameter(), arrayType, this.argsIndex[2]), this.localVarArg(vr.getArgIdx(0), Type.INT_TYPE, this.argsIndex[0]), this.localVarArg(vr.getArgIdx(1), elementType, this.argsIndex[1], TypeUtils.isAnyType(argElementType)), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                            }
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }

                    @Override
                    protected void onAfterArrayStore(int opcode) {
                        if (where == Where.AFTER) {
                            Type elementType = TypeUtils.getElementType(opcode);
                            Type arrayType = TypeUtils.getArrayType(opcode);
                            if (this.locationTypeMismatch(loc, arrayType, elementType)) {
                                return;
                            }
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), arrayType);
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Type.INT_TYPE, elementType});
                            if (vr.isValid()) {
                                int elementIdx = vr.getArgIdx(1);
                                Type argElementType = elementIdx > -1 ? actionArgTypes[elementIdx] : Type.VOID_TYPE;
                                Label l = this.levelCheckAfter(om, Instrumentor.this.bcn.getClassName(true));
                                this.loadArguments(this.localVarArg(om.getTargetInstanceParameter(), arrayType, this.argsIndex[2]), this.localVarArg(vr.getArgIdx(0), Type.INT_TYPE, this.argsIndex[0]), this.localVarArg(vr.getArgIdx(1), elementType, this.argsIndex[1], TypeUtils.isAnyType(argElementType)), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.isStatic() ? this.constArg(om.getSelfParameter(), null) : this.localVarArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className), 0));
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                                if (l != null) {
                                    this.mv.visitLabel(l);
                                    this.insertFrameSameStack(l);
                                }
                            }
                        }
                    }
                };
            }
            case CALL: {
                return new MethodCallInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    private final String localClassName;
                    private final String localMethodName;
                    int[] backupArgsIndices;
                    private int returnVarIndex;
                    private boolean generatingCode;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name2, desc2);
                        this.localClassName = loc.getClazz();
                        this.localMethodName = loc.getMethod();
                        this.returnVarIndex = -1;
                        this.generatingCode = false;
                    }

                    private void injectBtrace(MethodInstrumentor.ValidationResult vr, String method, Type[] callArgTypes, Type returnType, boolean staticCall) {
                        MethodInstrumentor.ArgumentProvider[] actionArgs = new MethodInstrumentor.ArgumentProvider[actionArgTypes.length + 7];
                        for (int i = 0; i < vr.getArgCnt(); ++i) {
                            int index = vr.getArgIdx(i);
                            Type t = actionArgTypes[index];
                            if (TypeUtils.isAnyTypeArray(t)) {
                                if (i < this.backupArgsIndices.length - 1) {
                                    actionArgs[i] = this.anytypeArg(index, this.backupArgsIndices[i + 1], callArgTypes);
                                    continue;
                                }
                                actionArgs[i] = new MethodInstrumentor.ArgumentProvider(this.asm, index){

                                    @Override
                                    protected void doProvide() {
                                        this.asm.push(0).newArray(Constants.OBJECT_TYPE);
                                    }
                                };
                                continue;
                            }
                            actionArgs[i] = this.localVarArg(index, actionArgTypes[index], this.backupArgsIndices[i + 1]);
                        }
                        actionArgs[actionArgTypes.length] = this.localVarArg(om.getReturnParameter(), returnType, this.returnVarIndex);
                        actionArgs[actionArgTypes.length + 1] = staticCall ? this.constArg(om.getTargetInstanceParameter(), null) : this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.backupArgsIndices.length == 0 ? -1 : this.backupArgsIndices[0]);
                        actionArgs[actionArgTypes.length + 2] = this.constArg(om.getTargetMethodOrFieldParameter(), method);
                        actionArgs[actionArgTypes.length + 3] = this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.'));
                        actionArgs[actionArgTypes.length + 4] = this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn()));
                        actionArgs[actionArgTypes.length + 5] = this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        actionArgs[actionArgTypes.length + 6] = new MethodInstrumentor.ArgumentProvider(this.asm, om.getDurationParameter()){

                            @Override
                            public void doProvide() {
                                MethodTrackingExpander.DURATION.insert(mv);
                            }
                        };
                        this.loadArguments(actionArgs);
                        Instrumentor.this.invokeBTraceAction(this.asm, om);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onBeforeCallMethod(int opcode, String cOwner, String cName, String cDesc) {
                        if (Instrumentor.this.matches(this.localClassName, cOwner.replace('/', '.')) && Instrumentor.this.matches(this.localMethodName, cName) && Instrumentor.this.typeMatches(loc.getType(), cDesc, om.isExactTypeMatch())) {
                            MethodInstrumentor.ValidationResult vr;
                            int parentMid = MethodID.getMethodId((String)Instrumentor.this.className, (String)name, (String)desc);
                            int mid = MethodID.getMethodId((String)("c$" + parentMid + "$" + cOwner), (String)cName, (String)cDesc);
                            String method = Instrumentor.this.getMethodOrFieldName(om.isTargetMethodOrFieldFqn(), opcode, cOwner, cName, cDesc);
                            Type[] calledMethodArgs = Type.getArgumentTypes((String)cDesc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), Type.getObjectType((String)cOwner));
                            if (where == Where.AFTER) {
                                this.addExtraTypeInfo(om.getReturnParameter(), Type.getReturnType((String)cDesc));
                            }
                            if ((vr = this.validateArguments(om, actionArgTypes, calledMethodArgs)).isValid()) {
                                boolean isStaticCall;
                                boolean bl = isStaticCall = opcode == 184;
                                if (!isStaticCall && where == Where.BEFORE && cName.equals("<init>")) {
                                    return;
                                }
                                if (!this.generatingCode) {
                                    try {
                                        this.generatingCode = true;
                                        if (om.getDurationParameter() != -1) {
                                            MethodTrackingExpander.ENTRY.insert(this.mv, "mean=" + om.getSamplerMean(), "sampler=" + om.getSamplerKind(), "timed", "methodid=" + mid, "level=" + Instrumentor.getLevelStrSafe(om));
                                        } else {
                                            MethodTrackingExpander.ENTRY.insert(this.mv, "mean=" + om.getSamplerMean(), "sampler=" + om.getSamplerKind(), "methodid=" + mid, "level=" + Instrumentor.getLevelStrSafe(om));
                                        }
                                    }
                                    finally {
                                        this.generatingCode = false;
                                    }
                                }
                                Type[] argTypes = Type.getArgumentTypes((String)cDesc);
                                boolean shouldBackup = !vr.isAny() || om.getTargetInstanceParameter() != -1;
                                int[] nArray = this.backupArgsIndices = shouldBackup ? this.backupStack(argTypes, isStaticCall) : new int[]{};
                                if (where == Where.BEFORE) {
                                    MethodTrackingExpander.TEST_SAMPLE.insert(this.mv, "methodid=" + mid);
                                    Label l = this.levelCheckBefore(om, Instrumentor.this.bcn.getClassName(true));
                                    this.injectBtrace(vr, method, argTypes, Type.getReturnType((String)cDesc), isStaticCall);
                                    if (l != null) {
                                        this.mv.visitLabel(l);
                                        this.insertFrameSameStack(l);
                                    }
                                    MethodTrackingExpander.ELSE_SAMPLE.insert(this.mv);
                                }
                                if (shouldBackup) {
                                    this.restoreStack(this.backupArgsIndices, argTypes, isStaticCall);
                                }
                            }
                        }
                    }

                    @Override
                    protected void onAfterCallMethod(int opcode, String cOwner, String cName, String cDesc) {
                        if (Instrumentor.this.matches(this.localClassName, cOwner.replace('/', '.')) && Instrumentor.this.matches(this.localMethodName, cName) && Instrumentor.this.typeMatches(loc.getType(), cDesc, om.isExactTypeMatch())) {
                            int parentMid = MethodID.getMethodId((String)Instrumentor.this.className, (String)name, (String)desc);
                            int mid = MethodID.getMethodId((String)("c$" + parentMid + "$" + cOwner), (String)cName, (String)cDesc);
                            Type returnType = Type.getReturnType((String)cDesc);
                            Type[] calledMethodArgs = Type.getArgumentTypes((String)cDesc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), Type.getObjectType((String)cOwner));
                            this.addExtraTypeInfo(om.getReturnParameter(), returnType);
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, calledMethodArgs);
                            if (vr.isValid()) {
                                if (om.getDurationParameter() == -1) {
                                    MethodTrackingExpander.EXIT.insert(this.mv, "methodid=" + mid);
                                }
                                if (where == Where.AFTER) {
                                    boolean withReturn;
                                    if (om.getDurationParameter() != -1) {
                                        MethodTrackingExpander.TEST_SAMPLE.insert(this.mv, "timed", "methodid=" + mid);
                                    } else {
                                        MethodTrackingExpander.TEST_SAMPLE.insert(this.mv, "methodid=" + mid);
                                    }
                                    Label l = this.levelCheckAfter(om, Instrumentor.this.bcn.getClassName(true));
                                    String method = Instrumentor.this.getMethodOrFieldName(om.isTargetMethodOrFieldFqn(), opcode, cOwner, cName, cDesc);
                                    boolean bl = withReturn = om.getReturnParameter() != -1 && !returnType.equals((Object)Type.VOID_TYPE);
                                    if (withReturn) {
                                        if (Type.getReturnType((String)om.getTargetDescriptor()).getSort() == 0) {
                                            this.asm.dupValue(returnType);
                                        }
                                        this.returnVarIndex = this.storeAsNew();
                                    }
                                    this.injectBtrace(vr, method, calledMethodArgs, returnType, opcode == 184);
                                    if (l != null) {
                                        this.mv.visitLabel(l);
                                        this.insertFrameSameStack(l);
                                    }
                                    MethodTrackingExpander.ELSE_SAMPLE.insert(this.mv);
                                    if (this.parent == null) {
                                        MethodTrackingExpander.RESET.insert(this.mv);
                                    }
                                }
                            }
                        }
                    }
                };
            }
            case CATCH: {
                return new CatchInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){

                    @Override
                    protected void onCatch(String type) {
                        Type exctype = Type.getObjectType((String)type);
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getTargetInstanceParameter(), exctype);
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, Type.getArgumentTypes((String)this.getDescriptor()));
                        if (vr.isValid()) {
                            int index = -1;
                            Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                            if (om.getTargetInstanceParameter() != -1) {
                                this.asm.dup();
                                index = this.storeAsNew();
                            }
                            this.loadArguments(this.localVarArg(om.getTargetInstanceParameter(), exctype, index), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                            Instrumentor.this.invokeBTraceAction(this.asm, om);
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }
                };
            }
            case CHECKCAST: {
                return new TypeCheckInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){

                    private void callAction(int opcode, String desc) {
                        if (opcode == 192) {
                            Type castType = Type.getObjectType((String)desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE);
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Constants.STRING_TYPE});
                            if (vr.isValid()) {
                                int castTypeIndex = -1;
                                Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                                if (!vr.isAny()) {
                                    this.asm.dup();
                                    castTypeIndex = this.storeAsNew();
                                }
                                this.loadArguments(this.constArg(vr.getArgIdx(0), castType.getClassName()), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)), this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, castTypeIndex));
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                                if (l != null) {
                                    this.mv.visitLabel(l);
                                    this.insertFrameSameStack(l);
                                }
                            }
                        }
                    }

                    @Override
                    protected void onBeforeTypeCheck(int opcode, String desc) {
                        if (where == Where.BEFORE) {
                            this.callAction(opcode, desc);
                        }
                    }

                    @Override
                    protected void onAfterTypeCheck(int opcode, String desc) {
                        if (where == Where.AFTER) {
                            this.callAction(opcode, desc);
                        }
                    }
                };
            }
            case ENTRY: {
                return new MethodReturnInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    private final MethodInstrumentor.ValidationResult vr;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        Type[] calledMethodArgs = Type.getArgumentTypes((String)this.getDescriptor());
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.vr = this.validateArguments(om, actionArgTypes, calledMethodArgs);
                    }

                    private void injectBtrace() {
                        this.loadArguments(this.vr, actionArgTypes, this.isStatic(), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                        Instrumentor.this.invokeBTraceAction(this.asm, om);
                    }

                    @Override
                    protected void visitMethodPrologue() {
                        if ((this.vr.isValid() || this.vr.isAny()) && om.getSamplerKind() != Sampled.Sampler.None) {
                            MethodTrackingExpander.ENTRY.insert(this.mv, "sampler=" + om.getSamplerKind(), "mean=" + om.getSamplerMean(), "level=" + Instrumentor.getLevelStrSafe(om));
                        }
                        super.visitMethodPrologue();
                    }

                    @Override
                    protected void onMethodEntry() {
                        if (this.vr.isValid() || this.vr.isAny()) {
                            if (om.getSamplerKind() != Sampled.Sampler.None) {
                                MethodTrackingExpander.TEST_SAMPLE.insert(this.mv, "timed");
                            }
                            Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                            if (numActionArgs == 0) {
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                            } else {
                                this.injectBtrace();
                            }
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                            if (om.getSamplerKind() != Sampled.Sampler.None) {
                                MethodTrackingExpander.ELSE_SAMPLE.insert(this.mv);
                            }
                        }
                    }

                    @Override
                    protected void onMethodReturn(int opcode) {
                        if ((this.vr.isValid() || this.vr.isAny()) && om.getSamplerKind() == Sampled.Sampler.Adaptive) {
                            MethodTrackingExpander.EXIT.insert(this.mv);
                        }
                    }
                };
            }
            case ERROR: {
                return new ErrorReturnInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    final MethodInstrumentor.ValidationResult vr;
                    private boolean generatingCode;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.generatingCode = false;
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getTargetInstanceParameter(), Constants.THROWABLE_TYPE);
                        this.vr = this.validateArguments(om, actionArgTypes, Type.getArgumentTypes((String)this.getDescriptor()));
                    }

                    @Override
                    protected void onErrorReturn() {
                        if (this.vr.isValid()) {
                            int throwableIndex = -1;
                            MethodTrackingExpander.TEST_SAMPLE.insert(this.mv, "timed");
                            if (om.getTargetInstanceParameter() != -1) {
                                this.asm.dup();
                                throwableIndex = this.storeAsNew();
                            }
                            MethodInstrumentor.ArgumentProvider[] actionArgs = new MethodInstrumentor.ArgumentProvider[]{this.localVarArg(om.getTargetInstanceParameter(), Constants.THROWABLE_TYPE, throwableIndex), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)), new MethodInstrumentor.ArgumentProvider(this.asm, om.getDurationParameter()){

                                @Override
                                public void doProvide() {
                                    MethodTrackingExpander.DURATION.insert(mv);
                                }
                            }};
                            Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                            this.loadArguments(this.vr, actionArgTypes, this.isStatic(), actionArgs);
                            Instrumentor.this.invokeBTraceAction(this.asm, om);
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                            MethodTrackingExpander.ELSE_SAMPLE.insert(this.mv);
                        }
                    }

                    @Override
                    protected void visitMethodPrologue() {
                        if (this.vr.isValid() && !this.generatingCode) {
                            try {
                                this.generatingCode = true;
                                if (om.getDurationParameter() != -1) {
                                    MethodTrackingExpander.ENTRY.insert(this.mv, "mean=" + om.getSamplerMean(), "sampler=" + om.getSamplerKind(), "timed", "level=" + Instrumentor.getLevelStrSafe(om));
                                } else {
                                    MethodTrackingExpander.ENTRY.insert(this.mv, "mean=" + om.getSamplerMean(), "sampler=" + om.getSamplerKind(), "level=" + Instrumentor.getLevelStrSafe(om));
                                }
                            }
                            finally {
                                this.generatingCode = false;
                            }
                        }
                        super.visitMethodPrologue();
                    }
                };
            }
            case FIELD_GET: {
                return new FieldAccessInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    private final String targetClassName;
                    private final String targetFieldName;
                    int calledInstanceIndex;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.targetClassName = loc.getClazz();
                        this.targetFieldName = loc.getField();
                        this.calledInstanceIndex = Integer.MIN_VALUE;
                    }

                    @Override
                    protected void onBeforeGetField(int opcode, String owner, String name, String desc) {
                        if (Instrumentor.this.matches(this.targetClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.targetFieldName, name)) {
                            MethodInstrumentor.ValidationResult vr;
                            Type fldType = Type.getType((String)desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), Type.getObjectType((String)owner));
                            if (where == Where.AFTER) {
                                this.addExtraTypeInfo(om.getReturnParameter(), fldType);
                            }
                            if ((vr = this.validateArguments(om, actionArgTypes, new Type[0])).isValid()) {
                                if (!this.isStaticAccess && om.getTargetInstanceParameter() != -1) {
                                    this.asm.dup();
                                    this.calledInstanceIndex = this.storeAsNew();
                                }
                                Label l = this.levelCheckBefore(om, Instrumentor.this.bcn.getClassName(true));
                                if (where == Where.BEFORE) {
                                    this.loadArguments(this.isStaticAccess ? this.constArg(om.getTargetInstanceParameter(), null) : this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.calledInstanceIndex), this.constArg(om.getTargetMethodOrFieldParameter(), Instrumentor.this.getMethodOrFieldName(om.isTargetMethodOrFieldFqn(), opcode, this.targetClassName, this.targetFieldName, desc)), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                    Instrumentor.this.invokeBTraceAction(this.asm, om);
                                }
                                if (l != null) {
                                    this.mv.visitLabel(l);
                                    this.insertFrameSameStack(l);
                                }
                            }
                        }
                    }

                    @Override
                    protected void onAfterGetField(int opcode, String owner, String name, String desc) {
                        if (where == Where.AFTER && Instrumentor.this.matches(this.targetClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.targetFieldName, name)) {
                            Type fldType = Type.getType((String)desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), Type.getObjectType((String)owner));
                            this.addExtraTypeInfo(om.getReturnParameter(), fldType);
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[0]);
                            if (vr.isValid()) {
                                int returnValIndex = -1;
                                Label l = this.levelCheckAfter(om, Instrumentor.this.bcn.getClassName(true));
                                if (om.getReturnParameter() != -1) {
                                    this.asm.dupValue(desc);
                                    returnValIndex = this.storeAsNew();
                                }
                                this.loadArguments(this.isStaticAccess ? this.constArg(om.getTargetInstanceParameter(), null) : this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.calledInstanceIndex), this.constArg(om.getTargetMethodOrFieldParameter(), Instrumentor.this.getMethodOrFieldName(om.isTargetMethodOrFieldFqn(), opcode, this.targetClassName, this.targetFieldName, desc)), this.localVarArg(om.getReturnParameter(), fldType, returnValIndex), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                                if (l != null) {
                                    this.mv.visitLabel(l);
                                    this.insertFrameSameStack(l);
                                }
                            }
                        }
                    }
                };
            }
            case FIELD_SET: {
                return new FieldAccessInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    private final String targetClassName;
                    private final String targetFieldName;
                    private int calledInstanceIndex;
                    private int fldValueIndex;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.targetClassName = loc.getClazz();
                        this.targetFieldName = loc.getField();
                        this.calledInstanceIndex = Integer.MIN_VALUE;
                        this.fldValueIndex = -1;
                    }

                    @Override
                    protected void onBeforePutField(int opcode, String owner, String name, String desc) {
                        if (Instrumentor.this.matches(this.targetClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.targetFieldName, name)) {
                            Type fieldType = Type.getType((String)desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), Type.getObjectType((String)owner));
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{fieldType});
                            if (vr.isValid()) {
                                if (!vr.isAny()) {
                                    this.fldValueIndex = this.storeAsNew();
                                }
                                if (!this.isStaticAccess && om.getTargetInstanceParameter() != -1) {
                                    this.asm.dup();
                                    this.calledInstanceIndex = this.storeAsNew();
                                }
                                if (!vr.isAny()) {
                                    this.asm.loadLocal(fieldType, this.fldValueIndex);
                                }
                                Label l = this.levelCheckBefore(om, Instrumentor.this.bcn.getClassName(true));
                                if (where == Where.BEFORE) {
                                    this.loadArguments(this.localVarArg(vr.getArgIdx(0), fieldType, this.fldValueIndex), this.isStaticAccess ? this.constArg(om.getTargetInstanceParameter(), null) : this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.calledInstanceIndex), this.constArg(om.getTargetMethodOrFieldParameter(), Instrumentor.this.getMethodOrFieldName(om.isTargetMethodOrFieldFqn(), opcode, this.targetClassName, this.targetFieldName, desc)), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                    Instrumentor.this.invokeBTraceAction(this.asm, om);
                                }
                                if (l != null) {
                                    this.mv.visitLabel(l);
                                    this.insertFrameSameStack(l);
                                }
                            }
                        }
                    }

                    @Override
                    protected void onAfterPutField(int opcode, String owner, String name, String desc) {
                        if (where == Where.AFTER && Instrumentor.this.matches(this.targetClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.targetFieldName, name)) {
                            Type fieldType = Type.getType((String)desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getTargetInstanceParameter(), Type.getObjectType((String)owner));
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{fieldType});
                            if (vr.isValid()) {
                                Label l = this.levelCheckAfter(om, Instrumentor.this.bcn.getClassName(true));
                                this.loadArguments(this.localVarArg(vr.getArgIdx(0), fieldType, this.fldValueIndex), this.isStaticAccess ? this.constArg(om.getTargetInstanceParameter(), null) : this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.calledInstanceIndex), this.constArg(om.getTargetMethodOrFieldParameter(), Instrumentor.this.getMethodOrFieldName(om.isTargetMethodOrFieldFqn(), opcode, this.targetClassName, this.targetFieldName, desc)), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                                if (l != null) {
                                    this.mv.visitLabel(l);
                                    this.insertFrameSameStack(l);
                                }
                            }
                        }
                    }
                };
            }
            case INSTANCEOF: {
                return new TypeCheckInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    MethodInstrumentor.ValidationResult vr;
                    Type castType;
                    int castTypeIndex;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.castType = Constants.OBJECT_TYPE;
                        this.castTypeIndex = -1;
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE);
                    }

                    private void callAction(String cName) {
                        if (this.vr.isValid()) {
                            Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                            this.loadArguments(this.constArg(this.vr.getArgIdx(0), cName), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)), this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.castTypeIndex));
                            Instrumentor.this.invokeBTraceAction(this.asm, om);
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }

                    @Override
                    protected void onBeforeTypeCheck(int opcode, String desc) {
                        if (opcode == 193) {
                            this.castType = Type.getObjectType((String)desc);
                            this.vr = this.validateArguments(om, actionArgTypes, new Type[]{Constants.STRING_TYPE});
                            if (this.vr.isValid()) {
                                if (!this.vr.isAny()) {
                                    this.asm.dup();
                                    this.castTypeIndex = this.storeAsNew();
                                }
                                if (where == Where.BEFORE) {
                                    this.callAction(this.castType.getClassName());
                                }
                            }
                        }
                    }

                    @Override
                    protected void onAfterTypeCheck(int opcode, String desc) {
                        if (opcode == 193) {
                            this.castType = Type.getObjectType((String)desc);
                            this.vr = this.validateArguments(om, actionArgTypes, new Type[]{Constants.STRING_TYPE});
                            if (this.vr.isValid() && where == Where.AFTER) {
                                this.callAction(this.castType.getClassName());
                            }
                        }
                    }
                };
            }
            case LINE: {
                return new LineNumberInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    private final int onLine;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.onLine = loc.getLine();
                    }

                    private void callOnLine(int line) {
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Type.INT_TYPE});
                        if (vr.isValid()) {
                            Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                            this.loadArguments(this.constArg(vr.getArgIdx(0), line), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                            Instrumentor.this.invokeBTraceAction(this.asm, om);
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }

                    @Override
                    protected void onBeforeLine(int line) {
                        if ((line == this.onLine || this.onLine == -1) && where == Where.BEFORE) {
                            this.callOnLine(line);
                        }
                    }

                    @Override
                    protected void onAfterLine(int line) {
                        if ((line == this.onLine || this.onLine == -1) && where == Where.AFTER) {
                            this.callOnLine(line);
                        }
                    }
                };
            }
            case NEW: {
                return new ObjectAllocInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc, om.getReturnParameter() != -1){

                    @Override
                    protected void beforeObjectNew(String desc) {
                        if (loc.getWhere() == Where.BEFORE) {
                            String extName = desc.replace('/', '.');
                            if (Instrumentor.this.matches(loc.getClazz(), extName)) {
                                this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                                MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Constants.STRING_TYPE});
                                if (vr.isValid()) {
                                    Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                                    this.loadArguments(this.constArg(vr.getArgIdx(0), extName), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                    Instrumentor.this.invokeBTraceAction(this.asm, om);
                                    if (l != null) {
                                        this.mv.visitLabel(l);
                                        this.insertFrameSameStack(l);
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    protected void afterObjectNew(String desc) {
                        if (loc.getWhere() == Where.AFTER) {
                            String extName = desc.replace('/', '.');
                            if (Instrumentor.this.matches(loc.getClazz(), extName)) {
                                Type instType = Type.getObjectType((String)desc);
                                this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                                this.addExtraTypeInfo(om.getReturnParameter(), instType);
                                MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Constants.STRING_TYPE});
                                if (vr.isValid()) {
                                    int returnValIndex = -1;
                                    Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                                    if (om.getReturnParameter() != -1) {
                                        this.asm.dupValue(instType);
                                        returnValIndex = this.storeAsNew();
                                    }
                                    this.loadArguments(this.constArg(vr.getArgIdx(0), extName), this.localVarArg(om.getReturnParameter(), instType, returnValIndex), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                    Instrumentor.this.invokeBTraceAction(this.asm, om);
                                    if (l != null) {
                                        this.mv.visitLabel(l);
                                        this.insertFrameSameStack(l);
                                    }
                                }
                            }
                        }
                    }
                };
            }
            case NEWARRAY: {
                return new ArrayAllocInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){

                    @Override
                    protected void onBeforeArrayNew(String desc, int dims) {
                        if (where == Where.BEFORE) {
                            String extName = TypeUtils.getJavaType(desc);
                            String type = loc.getClazz();
                            if (Instrumentor.this.matches(type, extName)) {
                                this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                                MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Constants.STRING_TYPE, Type.INT_TYPE});
                                if (vr.isValid()) {
                                    Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                                    this.loadArguments(this.constArg(vr.getArgIdx(0), extName), this.constArg(vr.getArgIdx(1), dims), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                    Instrumentor.this.invokeBTraceAction(this.asm, om);
                                    if (l != null) {
                                        this.mv.visitLabel(l);
                                        this.insertFrameSameStack(l);
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    protected void onAfterArrayNew(String desc, int dims) {
                        if (where == Where.AFTER) {
                            String extName = TypeUtils.getJavaType(desc);
                            String type = loc.getClazz();
                            if (Instrumentor.this.matches(type, extName)) {
                                StringBuilder arrayType = new StringBuilder();
                                for (int i = 0; i < dims; ++i) {
                                    arrayType.append("[");
                                }
                                arrayType.append(desc);
                                Type instType = Type.getObjectType((String)arrayType.toString());
                                this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                                this.addExtraTypeInfo(om.getReturnParameter(), instType);
                                MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, new Type[]{Constants.STRING_TYPE, Type.INT_TYPE});
                                if (vr.isValid()) {
                                    int returnValIndex = -1;
                                    Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                                    if (om.getReturnParameter() != -1) {
                                        this.asm.dupValue(instType);
                                        returnValIndex = this.storeAsNew();
                                    }
                                    this.loadArguments(this.constArg(vr.getArgIdx(0), extName), this.constArg(vr.getArgIdx(1), dims), this.localVarArg(om.getReturnParameter(), instType, returnValIndex), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                    Instrumentor.this.invokeBTraceAction(this.asm, om);
                                    if (l != null) {
                                        this.mv.visitLabel(l);
                                        this.insertFrameSameStack(l);
                                    }
                                }
                            }
                        }
                    }
                };
            }
            case RETURN: {
                if (where != Where.BEFORE) {
                    return mv;
                }
                return new MethodReturnInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    int retValIndex;
                    final MethodInstrumentor.ValidationResult vr;
                    private boolean generatingCode;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.generatingCode = false;
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getReturnParameter(), this.getReturnType());
                        this.vr = this.validateArguments(om, actionArgTypes, Type.getArgumentTypes((String)this.getDescriptor()));
                    }

                    private void callAction(int retOpCode) {
                        if (!this.vr.isValid()) {
                            return;
                        }
                        boolean boxReturnValue = false;
                        Type probeRetType = this.getReturnType();
                        if (om.getReturnParameter() != -1) {
                            Type retType = Type.getArgumentTypes((String)om.getTargetDescriptor())[om.getReturnParameter()];
                            if (probeRetType.equals((Object)Type.VOID_TYPE)) {
                                if (TypeUtils.isAnyType(retType)) {
                                    this.asm.getStatic(Type.getInternalName(AnyType.class), "VOID", "Lorg/openjdk/btrace/core/types/AnyType;");
                                    probeRetType = Constants.OBJECT_TYPE;
                                } else if (Constants.VOIDREF_TYPE.equals((Object)retType)) {
                                    this.asm.loadNull();
                                    probeRetType = Constants.VOIDREF_TYPE;
                                }
                            } else {
                                if (Type.getReturnType((String)om.getTargetDescriptor()).getSort() == 0) {
                                    this.asm.dupReturnValue(retOpCode);
                                }
                                boxReturnValue = TypeUtils.isAnyType(retType);
                            }
                            this.retValIndex = this.storeAsNew();
                        }
                        this.loadArguments(this.vr, actionArgTypes, this.isStatic(), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), this.localVarArg(om.getReturnParameter(), probeRetType, this.retValIndex, boxReturnValue), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)), new MethodInstrumentor.ArgumentProvider(this.asm, om.getDurationParameter()){

                            @Override
                            public void doProvide() {
                                MethodTrackingExpander.DURATION.insert(mv);
                            }
                        });
                        Instrumentor.this.invokeBTraceAction(this.asm, om);
                    }

                    @Override
                    protected void onMethodReturn(int opcode) {
                        if (this.vr.isValid() || this.vr.isAny()) {
                            MethodTrackingExpander.TEST_SAMPLE.insert(this.mv, "timed");
                            Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                            if (numActionArgs == 0) {
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                            } else {
                                this.callAction(opcode);
                            }
                            MethodTrackingExpander.ELSE_SAMPLE.insert(this.mv);
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }

                    @Override
                    protected void onMethodEntry() {
                        if (this.vr.isValid() || this.vr.isAny()) {
                            try {
                                if (!this.generatingCode) {
                                    this.generatingCode = true;
                                    if (om.getDurationParameter() != -1) {
                                        MethodTrackingExpander.ENTRY.insert(this.mv, "mean=" + om.getSamplerMean(), "sampler=" + om.getSamplerKind(), "level=" + Instrumentor.getLevelStrSafe(om), "timed");
                                    } else {
                                        MethodTrackingExpander.ENTRY.insert(this.mv, "mean=" + om.getSamplerMean(), "sampler=" + om.getSamplerKind(), "level=" + Instrumentor.getLevelStrSafe(om));
                                    }
                                }
                            }
                            finally {
                                this.generatingCode = false;
                            }
                        }
                    }
                };
            }
            case SYNC_ENTRY: {
                return new SynchronizedInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    int storedObjIdx;
                    final MethodInstrumentor.ValidationResult vr;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.storedObjIdx = -1;
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE);
                        this.vr = this.validateArguments(om, actionArgTypes, Type.getArgumentTypes((String)this.getDescriptor()));
                    }

                    @Override
                    protected void onBeforeSyncEntry() {
                        if (this.vr.isValid()) {
                            Label l = this.levelCheckBefore(om, Instrumentor.this.bcn.getClassName(true));
                            if (om.getTargetInstanceParameter() != -1) {
                                if (this.isSyncMethod) {
                                    if (!this.isStatic) {
                                        this.storedObjIdx = 0;
                                    } else {
                                        this.asm.ldc(Type.getObjectType((String)Instrumentor.this.className));
                                        this.storedObjIdx = this.storeAsNew();
                                    }
                                } else {
                                    this.asm.dup();
                                    this.storedObjIdx = this.storeAsNew();
                                }
                            }
                            if (where == Where.BEFORE) {
                                this.loadArguments(this.vr, actionArgTypes, this.isStatic(), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.storedObjIdx), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                                Instrumentor.this.invokeBTraceAction(this.asm, om);
                            }
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }

                    @Override
                    protected void onAfterSyncEntry() {
                        if (where == Where.AFTER && this.vr.isValid()) {
                            Label l = this.levelCheckAfter(om, Instrumentor.this.bcn.getClassName(true));
                            this.loadArguments(this.vr, actionArgTypes, this.isStatic(), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.storedObjIdx), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                            Instrumentor.this.invokeBTraceAction(this.asm, om);
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }

                    @Override
                    protected void onBeforeSyncExit() {
                    }

                    @Override
                    protected void onAfterSyncExit() {
                    }
                };
            }
            case SYNC_EXIT: {
                return new SynchronizedInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){
                    int storedObjIdx;
                    final MethodInstrumentor.ValidationResult vr;
                    {
                        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
                        this.storedObjIdx = -1;
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE);
                        this.vr = this.validateArguments(om, actionArgTypes, Type.getArgumentTypes((String)this.getDescriptor()));
                    }

                    private void loadActionArgs() {
                        this.loadArguments(this.vr, actionArgTypes, this.isStatic(), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), this.localVarArg(om.getTargetInstanceParameter(), Constants.OBJECT_TYPE, this.storedObjIdx), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)), new MethodInstrumentor.ArgumentProvider(this.asm, om.getDurationParameter()){

                            @Override
                            public void doProvide() {
                                MethodTrackingExpander.DURATION.insert(mv);
                            }
                        });
                    }

                    @Override
                    protected void onBeforeSyncExit() {
                        if (!this.vr.isValid()) {
                            return;
                        }
                        Label l = this.levelCheckBefore(om, Instrumentor.this.bcn.getClassName(true));
                        if (om.getTargetInstanceParameter() != -1) {
                            if (this.isSyncMethod) {
                                if (!this.isStatic) {
                                    this.storedObjIdx = 0;
                                } else {
                                    this.asm.ldc(Type.getObjectType((String)Instrumentor.this.className));
                                    this.storedObjIdx = this.storeAsNew();
                                }
                            } else {
                                this.asm.dup();
                                this.storedObjIdx = this.storeAsNew();
                            }
                        }
                        if (where == Where.BEFORE) {
                            this.loadActionArgs();
                            Instrumentor.this.invokeBTraceAction(this.asm, om);
                        }
                        if (l != null) {
                            this.mv.visitLabel(l);
                            this.insertFrameSameStack(l);
                        }
                    }

                    @Override
                    protected void onAfterSyncExit() {
                        if (!this.vr.isValid()) {
                            return;
                        }
                        if (where == Where.AFTER) {
                            this.loadActionArgs();
                            Instrumentor.this.invokeBTraceAction(this.asm, om);
                        }
                    }

                    @Override
                    protected void onAfterSyncEntry() {
                        if (!this.vr.isValid()) {
                            return;
                        }
                        if (om.getDurationParameter() != -1) {
                            MethodTrackingExpander.ENTRY.insert(this.mv, "timed");
                        }
                    }

                    @Override
                    protected void onBeforeSyncEntry() {
                    }
                };
            }
            case THROW: {
                return new ThrowInstrumentor(this.cl, mv, mHelper, this.className, this.superName, access, name, desc){

                    @Override
                    protected void onThrow() {
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getTargetInstanceParameter(), Constants.THROWABLE_TYPE);
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, actionArgTypes, Type.getArgumentTypes((String)this.getDescriptor()));
                        if (vr.isValid()) {
                            int throwableIndex = -1;
                            Label l = this.levelCheck(om, Instrumentor.this.bcn.getClassName(true));
                            if (om.getTargetInstanceParameter() != -1) {
                                this.asm.dup();
                                throwableIndex = this.storeAsNew();
                            }
                            this.loadArguments(this.localVarArg(om.getTargetInstanceParameter(), Constants.THROWABLE_TYPE, throwableIndex), this.constArg(om.getClassNameParameter(), Instrumentor.this.className.replace('/', '.')), this.constArg(om.getMethodParameter(), this.getName(om.isMethodFqn())), this.selfArg(om.getSelfParameter(), Type.getObjectType((String)Instrumentor.this.className)));
                            Instrumentor.this.invokeBTraceAction(this.asm, om);
                            if (l != null) {
                                this.mv.visitLabel(l);
                                this.insertFrameSameStack(l);
                            }
                        }
                    }
                };
            }
        }
        return mv;
    }

    public void visitEnd() {
        if (!this.useHiddenClasses) {
            this.bcn.copyHandlers(new CopyingVisitor(this.className, false, this){

                @Override
                protected String getActionMethodName(String name) {
                    return Instrumentor.this.getActionMethodName(name);
                }
            });
        }
        this.cv.visitEnd();
    }

    static String getActionMethodName(BTraceProbe bp, String name) {
        return InstrumentUtils.getActionPrefix(bp.getClassName(true)) + name;
    }

    private String getActionMethodName(String name) {
        return Instrumentor.getActionMethodName(this.bcn, name);
    }

    private void invokeBTraceAction(Assembler asm, OnMethod om) {
        if (this.useHiddenClasses) {
            MethodType mt = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class);
            asm.invokeDynamic(this.getActionMethodName(om.getTargetName()), om.getTargetDescriptor().replace("Lorg/openjdk/btrace/core/types/AnyType;", "Ljava/lang/Object;"), new Handle(6, "org/openjdk/btrace/runtime/Indy", "bootstrap", mt.toMethodDescriptorString(), false), this.bcn.getClassName(true));
        } else {
            asm.invokeStatic(this.className, this.getActionMethodName(om.getTargetName()), om.getTargetDescriptor().replace("Lorg/openjdk/btrace/core/types/AnyType;", "Ljava/lang/Object;"));
        }
        this.calledOnMethods.add(om);
        om.setCalled();
    }

    private boolean matches(String pattern, String input) {
        if (pattern.length() == 0) {
            return false;
        }
        if (pattern.charAt(0) == '/' && Constants.REGEX_SPECIFIER.matcher(pattern).matches()) {
            try {
                return input.matches(pattern.substring(1, pattern.length() - 1));
            }
            catch (PatternSyntaxException pse) {
                Instrumentor.reportPatternSyntaxException(pattern.substring(1, pattern.length() - 1));
                return false;
            }
        }
        return pattern.equals(input);
    }

    private boolean typeMatches(String decl, String desc, boolean exactTypeMatch) {
        if (decl.isEmpty()) {
            return true;
        }
        String d = TypeUtils.declarationToDescriptor(decl);
        Type[] args1 = Type.getArgumentTypes((String)d);
        Type[] args2 = Type.getArgumentTypes((String)desc);
        return InstrumentUtils.isAssignable(args1, args2, this.cl, exactTypeMatch);
    }

    boolean hasCushionMethods() {
        return !this.useHiddenClasses;
    }
}

