/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.openjdk.btrace.instr.RandomIntProvider;

public final class MethodTracker {
    private static final RandomIntProvider rndIntProvider = RandomIntProvider.getInstance();
    private static AtomicLong[] counters = new AtomicLong[50];
    private static ThreadLocal<Long>[] tsArray = new ThreadLocal[50];
    private static Object[] rLocks = new Object[50];
    private static int[] means = new int[50];
    private static int[] origMeans = new int[50];
    private static int[] samplers = new int[50];

    public static synchronized void registerCounter(int methodId, int mean) {
        if (counters.length <= methodId) {
            int newLen = methodId * 2;
            counters = Arrays.copyOf(counters, newLen);
            rLocks = Arrays.copyOf(rLocks, newLen);
            means = Arrays.copyOf(means, newLen);
            origMeans = Arrays.copyOf(means, newLen);
            samplers = Arrays.copyOf(samplers, newLen);
            tsArray = Arrays.copyOf(tsArray, newLen);
        }
        if (counters[methodId] == null) {
            MethodTracker.counters[methodId] = new AtomicLong(0L);
            MethodTracker.rLocks[methodId] = new Object();
            MethodTracker.means[methodId] = mean * 2;
            MethodTracker.origMeans[methodId] = mean;
            MethodTracker.tsArray[methodId] = ThreadLocal.withInitial(() -> 0L);
            MethodTracker.samplers[methodId] = 0;
        }
    }

    public static boolean hit(int methodId) {
        int mean = means[methodId];
        if (mean == 0) {
            return true;
        }
        AtomicLong l = counters[methodId];
        if (l.getAndDecrement() <= 0L) {
            int inc = rndIntProvider.nextInt(mean) + 1;
            l.addAndGet(inc);
            return true;
        }
        return false;
    }

    public static long hitTimed(int methodId) {
        int mean = means[methodId];
        if (mean == 0) {
            long ts = System.nanoTime();
            tsArray[methodId].set(ts);
            return ts;
        }
        AtomicLong l = counters[methodId];
        if (l.getAndDecrement() <= 0L) {
            long ts = System.nanoTime();
            int inc = rndIntProvider.nextInt(mean) + 1;
            l.addAndGet(inc);
            tsArray[methodId].set(ts);
            return ts;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hitAdaptive(int methodId) {
        AtomicLong cntr = counters[methodId];
        int origMean = origMeans[methodId];
        int mean = means[methodId];
        if (cntr.getAndDecrement() <= 0L) {
            long ts = System.nanoTime();
            ThreadLocal<Long> tsRef = tsArray[methodId];
            long ts1 = tsRef.get();
            if (ts1 != 0L) {
                long diff = ts - ts1;
                if (mean < 1500 && diff < (long)origMean) {
                    Object object = rLocks[methodId];
                    synchronized (object) {
                        MethodTracker.means[methodId] = ++mean;
                    }
                }
                if (mean > 1 && diff > (long)origMean) {
                    Object object = rLocks[methodId];
                    synchronized (object) {
                        MethodTracker.means[methodId] = --mean;
                    }
                }
            }
            tsRef.set(ts);
            int inc = rndIntProvider.nextInt(mean) + 1;
            cntr.addAndGet(inc);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hitTimedAdaptive(int methodId) {
        AtomicLong cntr = counters[methodId];
        int mean = means[methodId];
        int origMean = origMeans[methodId];
        if (cntr.getAndDecrement() <= 0L) {
            long ts = System.nanoTime();
            ThreadLocal<Long> tsRef = tsArray[methodId];
            long ts1 = tsRef.get();
            if (ts1 != 0L) {
                long diff = ts - ts1;
                if (mean < 1500 && diff < (long)origMean) {
                    Object object = rLocks[methodId];
                    synchronized (object) {
                        MethodTracker.means[methodId] = ++mean;
                    }
                }
                if (mean > 1 && diff > (long)origMean) {
                    Object object = rLocks[methodId];
                    synchronized (object) {
                        MethodTracker.means[methodId] = --mean;
                    }
                }
            }
            tsRef.set(ts);
            int inc = rndIntProvider.nextInt(mean) + 1;
            cntr.addAndGet(inc);
            return ts;
        }
        return 0L;
    }

    public static long getEndTs(int methodId) {
        long ts = System.nanoTime();
        tsArray[methodId].set(ts);
        return ts;
    }

    public static void updateEndTs(int methodId) {
        tsArray[methodId].set(System.nanoTime());
    }
}

