/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.instr.MethodInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

public class ObjectAllocInstrumentor
extends MethodInstrumentor {
    private final boolean needsInitialization;
    private boolean instanceCreated = false;

    public ObjectAllocInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc) {
        this(cl, mv, mHelper, parentClz, superClz, access, name, desc, false);
    }

    public ObjectAllocInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc, boolean needsInitialization) {
        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
        this.needsInitialization = needsInitialization;
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (opcode == 187) {
            this.beforeObjectNew(desc);
        }
        super.visitTypeInsn(opcode, desc);
        if (opcode == 187) {
            if (this.needsInitialization) {
                this.instanceCreated = true;
            } else {
                this.afterObjectNew(desc);
            }
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean iface) {
        super.visitMethodInsn(opcode, owner, name, desc, iface);
        if (this.instanceCreated && "<init>".equals(name)) {
            this.instanceCreated = false;
            this.afterObjectNew(owner);
        }
    }

    protected void beforeObjectNew(String desc) {
    }

    protected void afterObjectNew(String desc) {
    }
}

