/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.annotations.Event;
import org.openjdk.btrace.core.annotations.Return;
import org.openjdk.btrace.instr.BTraceMethodNode;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.instr.StackTrackingMethodVisitor;
import org.openjdk.btrace.instr.TypeUtils;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Opcodes;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.AbstractInsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.AnnotationNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.ClassNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.FieldInsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.FieldNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.FrameNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.InsnList;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.InsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.JumpInsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.LabelNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.LdcInsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.MethodInsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.MethodNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.TryCatchBlockNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.TypeInsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.VarInsnNode;
import org.openjdk.btrace.runtime.BTraceRuntimeImplBase;

final class Preprocessor {
    private static final String ANNOTATIONS_PREFIX = "org/openjdk/btrace/core/annotations/";
    private static final Type TLS_TYPE = Type.getType((String)"Lorg/openjdk/btrace/core/annotations/TLS;");
    private static final Type EXPORT_TYPE = Type.getType((String)"Lorg/openjdk/btrace/core/annotations/Export;");
    private static final Type INJECTED_TYPE = Type.getType((String)"Lorg/openjdk/btrace/core/annotations/Injected;");
    private static final Type EVENT_TYPE = Type.getType((String)"Lorg/openjdk/btrace/core/annotations/Event;");
    private static final String SERVICE_INTERNAL = "org/openjdk/btrace/services/api/Service";
    private static final String TIMERHANDLER_INTERNAL = "org/openjdk/btrace/core/handlers/TimerHandler";
    private static final String TIMERHANDLER_DESC = "Lorg/openjdk/btrace/core/handlers/TimerHandler;";
    private static final String EVENTHANDLER_INTERNAL = "org/openjdk/btrace/core/handlers/EventHandler";
    private static final String EVENTHANDLER_DESC = "Lorg/openjdk/btrace/core/handlers/EventHandler;";
    private static final String ERRORHANDLER_INTERNAL = "org/openjdk/btrace/core/handlers/ErrorHandler";
    private static final String ERRORHANDLER_DESC = "Lorg/openjdk/btrace/core/handlers/ErrorHandler;";
    private static final String EXITHANDLER_INTERNAL = "org/openjdk/btrace/core/handlers/ExitHandler";
    private static final String EXITHANDLER_DESC = "Lorg/openjdk/btrace/core/handlers/ExitHandler;";
    private static final String LOWMEMORYHANDLER_INTERNAL = "org/openjdk/btrace/core/handlers/LowMemoryHandler";
    private static final String LOWMEMORYHANDLER_DESC = "Lorg/openjdk/btrace/core/handlers/LowMemoryHandler;";
    private static final String NEW_TLS_DESC = "(Ljava/lang/Object;)Ljava/lang/ThreadLocal;";
    private static final String TLS_SET_DESC = "(Ljava/lang/Object;)V";
    private static final String TLS_GET_DESC = "()Ljava/lang/Object;";
    private static final String NEW_PERFCOUNTER_DESC = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V";
    private static final String BTRACERT_FOR_CLASS_DESC = "(Ljava/lang/Class;[Lorg/openjdk/btrace/core/handlers/TimerHandler;[Lorg/openjdk/btrace/core/handlers/EventHandler;[Lorg/openjdk/btrace/core/handlers/ErrorHandler;[Lorg/openjdk/btrace/core/handlers/ExitHandler;[Lorg/openjdk/btrace/core/handlers/LowMemoryHandler;)Lorg/openjdk/btrace/runtime/BTraceRuntimeImplBase;";
    private static final String BTRACERT_ENTER_DESC = "(Lorg/openjdk/btrace/core/BTraceRuntime$Impl;)Z";
    private static final String BTRACERT_HANDLE_EXCEPTION_DESC = "(Ljava/lang/Throwable;)V";
    private static final String RT_CTX_INTERNAL = "org/openjdk/btrace/services/api/RuntimeContext";
    private static final String RT_CTX_DESC = "Lorg/openjdk/btrace/services/api/RuntimeContext;";
    private static final Type RT_CTX_TYPE = Type.getType((String)"Lorg/openjdk/btrace/services/api/RuntimeContext;");
    private static final String RT_SERVICE_CTR_DESC = "(Lorg/openjdk/btrace/services/api/RuntimeContext;)V";
    private static final String SERVICE_CTR_DESC = "(Ljava/lang/String;)V";
    private static final String JFR_EVENT_TEMPLATE_INTERNAL = "org/openjdk/btrace/core/jfr/JfrEvent$Template";
    private static final String JFR_EVENT_TEMPLATE_DESC = "Lorg/openjdk/btrace/core/jfr/JfrEvent$Template;";
    private static final String JFR_EVENT_TEMPLATE_FIELD_INTERNAL = "org/openjdk/btrace/core/jfr/JfrEvent$Template$Field";
    private static final String JFR_EVENT_TEMPLATE_FIELD_DESC = "Lorg/openjdk/btrace/core/jfr/JfrEvent$Template$Field;";
    private static final String JFR_EVENT_FACTORY_INTERNAL = "org/openjdk/btrace/core/jfr/JfrEvent$Factory";
    private static final String JFR_EVENT_FACTORY_DESC = "Lorg/openjdk/btrace/core/jfr/JfrEvent$Factory;";
    private static final Map<String, String> BOX_TYPE_MAP = new HashMap<String, String>();
    private static final Set<String> GUARDED_ANNOTS = new HashSet<String>();
    private static final Set<String> RT_AWARE_ANNOTS = new HashSet<String>();
    private static final String BTRACE_COUNTER_PREFIX = "btrace.";
    private static final String JFR_HANDLER_FIELD_PREFIX = "$jfr$handler$";
    private final Set<String> tlsFldNames = new HashSet<String>();
    private final Set<String> exportFldNames = new HashSet<String>();
    private final Set<String> jfrHandlerNames = new HashSet<String>();
    private final Map<String, AnnotationNode> eventFlds = new HashMap<String, AnnotationNode>();
    private final Map<String, AnnotationNode> injectedFlds = new HashMap<String, AnnotationNode>();
    private final Map<String, Integer> serviceLocals = new HashMap<String, Integer>();
    private final DebugSupport debug;
    private MethodNode clinit = null;
    private FieldNode rtField = null;
    private final Map<MethodNode, EnumSet<MethodClassifier>> classifierMap = new HashMap<MethodNode, EnumSet<MethodClassifier>>();
    private AbstractInsnNode clinitEntryPoint;

    public Preprocessor(DebugSupport debug) {
        this.debug = debug;
    }

    public static AnnotationNode getAnnotation(FieldNode fn, Type annotation) {
        if (fn == null || fn.visibleAnnotations == null && fn.invisibleAnnotations == null) {
            return null;
        }
        String targetDesc = annotation.getDescriptor();
        if (fn.visibleAnnotations != null) {
            for (AnnotationNode an : fn.visibleAnnotations) {
                if (!an.desc.equals(targetDesc)) continue;
                return an;
            }
        }
        if (fn.invisibleAnnotations != null) {
            for (AnnotationNode an : fn.invisibleAnnotations) {
                if (!an.desc.equals(targetDesc)) continue;
                return an;
            }
        }
        return null;
    }

    public static AnnotationNode getAnnotation(MethodNode mn, Type annotation) {
        if (mn == null || mn.visibleAnnotations == null) {
            return null;
        }
        String targetDesc = annotation.getDescriptor();
        for (AnnotationNode an : mn.visibleAnnotations) {
            if (!an.desc.equals(targetDesc)) continue;
            return an;
        }
        return null;
    }

    private static boolean isUnannotated(MethodNode mn) {
        return mn == null || mn.visibleAnnotations == null || mn.visibleAnnotations.isEmpty();
    }

    public void process(ClassNode cn) {
        this.addLevelField(cn);
        this.processClinit(cn);
        this.processFields(cn);
        for (MethodNode mn : this.getMethods(cn)) {
            this.preprocessMethod(cn, mn);
        }
        InsnList eventsInit = new InsnList();
        for (Map.Entry<String, AnnotationNode> eventEntry : this.eventFlds.entrySet()) {
            String fieldName = eventEntry.getKey();
            AnnotationNode an = eventEntry.getValue();
            String name = null;
            String label = null;
            String desc = null;
            String[] category = null;
            InsnList fieldsInit = new InsnList();
            String handler = null;
            String period = null;
            boolean stacktrace = false;
            Iterator iter = an.values.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = iter.next();
                switch (key) {
                    case "name": {
                        name = (String)value;
                        break;
                    }
                    case "label": {
                        label = (String)value;
                        label = label.isEmpty() ? null : label;
                        break;
                    }
                    case "description": {
                        desc = (String)value;
                        desc = desc.isEmpty() ? null : desc;
                        break;
                    }
                    case "category": {
                        category = (String[])value;
                        break;
                    }
                    case "fields": {
                        fieldsInit = this.loadFieldsDefs((List)value);
                        break;
                    }
                    case "stacktrace": {
                        stacktrace = (Boolean)value;
                        break;
                    }
                    case "period": {
                        period = (String)value;
                        period = period.isEmpty() ? null : period;
                    }
                }
            }
            if (fieldName.startsWith(JFR_HANDLER_FIELD_PREFIX)) {
                handler = fieldName.substring(JFR_HANDLER_FIELD_PREFIX.length());
                this.jfrHandlerNames.add(handler);
            }
            eventsInit.add((AbstractInsnNode)new TypeInsnNode(187, JFR_EVENT_TEMPLATE_INTERNAL));
            eventsInit.add((AbstractInsnNode)new InsnNode(89));
            eventsInit.add((AbstractInsnNode)new LdcInsnNode((Object)cn.name.replace('/', '.')));
            eventsInit.add((AbstractInsnNode)new LdcInsnNode((Object)name));
            eventsInit.add((AbstractInsnNode)(label != null ? new LdcInsnNode((Object)label) : new InsnNode(1)));
            eventsInit.add((AbstractInsnNode)(desc != null ? new LdcInsnNode((Object)desc) : new InsnNode(1)));
            eventsInit.add((AbstractInsnNode)(category != null ? new LdcInsnNode((Object)label) : new InsnNode(1)));
            eventsInit.add(fieldsInit);
            eventsInit.add((AbstractInsnNode)new LdcInsnNode((Object)stacktrace));
            eventsInit.add((AbstractInsnNode)(period != null ? new LdcInsnNode((Object)period) : new InsnNode(1)));
            eventsInit.add((AbstractInsnNode)(handler != null ? new LdcInsnNode((Object)handler) : new InsnNode(1)));
            eventsInit.add((AbstractInsnNode)new MethodInsnNode(183, JFR_EVENT_TEMPLATE_INTERNAL, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;[Lorg/openjdk/btrace/core/jfr/JfrEvent$Template$Field;ZLjava/lang/String;Ljava/lang/String;)V", false));
            eventsInit.add((AbstractInsnNode)new MethodInsnNode(184, "org/openjdk/btrace/core/BTraceRuntime", "createEventFactory", "(Lorg/openjdk/btrace/core/jfr/JfrEvent$Template;)Lorg/openjdk/btrace/core/jfr/JfrEvent$Factory;", false));
            eventsInit.add((AbstractInsnNode)new FieldInsnNode(179, cn.name, eventEntry.getKey(), JFR_EVENT_FACTORY_DESC));
        }
        this.clinit.instructions.insertBefore(this.clinitEntryPoint, eventsInit);
    }

    private InsnList loadFieldsDefs(List<AnnotationNode> fieldsDef) {
        InsnList insn = new InsnList();
        insn.add((AbstractInsnNode)new LdcInsnNode((Object)fieldsDef.size()));
        insn.add((AbstractInsnNode)new TypeInsnNode(189, JFR_EVENT_TEMPLATE_FIELD_INTERNAL));
        int cntr = 0;
        for (AnnotationNode fieldDef : fieldsDef) {
            insn.add((AbstractInsnNode)new InsnNode(89));
            insn.add((AbstractInsnNode)new LdcInsnNode((Object)cntr++));
            insn.add(this.loadFieldDef(fieldDef));
            insn.add((AbstractInsnNode)new InsnNode(83));
        }
        return insn;
    }

    private InsnList loadFieldDef(AnnotationNode fieldDef) {
        InsnList insn = new InsnList();
        Iterator iter = fieldDef.values.iterator();
        String name = null;
        String type = null;
        String label = null;
        String description = null;
        String[] kind = null;
        while (iter.hasNext()) {
            String key;
            switch (key = (String)iter.next()) {
                case "name": {
                    name = (String)iter.next();
                    break;
                }
                case "type": {
                    type = ((String[])iter.next())[1];
                    break;
                }
                case "label": {
                    label = (String)iter.next();
                    break;
                }
                case "description": {
                    description = (String)iter.next();
                    break;
                }
                case "kind": {
                    kind = this.getKind((AnnotationNode)iter.next());
                }
            }
        }
        insn.add((AbstractInsnNode)new TypeInsnNode(187, JFR_EVENT_TEMPLATE_FIELD_INTERNAL));
        insn.add((AbstractInsnNode)new InsnNode(89));
        insn.add((AbstractInsnNode)new LdcInsnNode((Object)name));
        insn.add((AbstractInsnNode)new LdcInsnNode((Object)type));
        insn.add((AbstractInsnNode)(label == null || label.isEmpty() ? new InsnNode(1) : new LdcInsnNode((Object)label)));
        insn.add((AbstractInsnNode)(description == null || description.isEmpty() ? new InsnNode(1) : new LdcInsnNode((Object)description)));
        if (kind != null) {
            if (!kind[0].equals(Event.FieldKind.NONE.name())) {
                insn.add((AbstractInsnNode)new LdcInsnNode((Object)kind[0]));
                insn.add((AbstractInsnNode)(kind[1] == null || kind[1].isEmpty() ? new InsnNode(1) : new LdcInsnNode((Object)kind[1])));
            }
        } else {
            insn.add((AbstractInsnNode)new InsnNode(1));
            insn.add((AbstractInsnNode)new InsnNode(1));
        }
        insn.add((AbstractInsnNode)new MethodInsnNode(183, JFR_EVENT_TEMPLATE_FIELD_INTERNAL, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false));
        return insn;
    }

    private String[] getKind(AnnotationNode kindNode) {
        Iterator iter = kindNode.values.iterator();
        String name = null;
        String value = null;
        while (iter.hasNext()) {
            String key;
            switch (key = (String)iter.next()) {
                case "name": {
                    name = ((String[])iter.next())[1];
                    break;
                }
                case "value": {
                    value = (String)iter.next();
                }
            }
        }
        return new String[]{name, value};
    }

    private void addLevelField(ClassNode cn) {
        if (cn.fields == null) {
            cn.fields = new ArrayList();
        }
        cn.fields.add(new FieldNode(458752, 73, "$btrace$$level", "I", null, (Object)0));
    }

    private void preprocessMethod(ClassNode cn, MethodNode mn) {
        LocalVarGenerator lvg = new LocalVarGenerator(mn);
        this.makePublic(mn);
        this.checkAugmentedReturn(mn);
        this.scanMethodInstructions(cn, mn, lvg);
        this.addBTraceErrorHandler(cn, mn);
        this.addBTraceRuntimeEnter(cn, mn);
        this.addJfrHandlerField(cn, mn);
        this.recalculateVars(mn);
    }

    private void makePublic(MethodNode mn) {
        if (!mn.name.contains("init>") && Preprocessor.isUnannotated(mn) && (mn.access & 8) == 8) {
            mn.access &= 0xFFFFFFF9;
            mn.access |= 1;
        }
    }

    private void processFields(ClassNode cn) {
        Iterator<FieldNode> iter = this.getFields(cn).iterator();
        while (iter.hasNext()) {
            FieldNode fn = iter.next();
            fn.access = fn.access & 0xFFFFFFF9 | 1;
            this.tryProcessTLS(cn, fn);
            this.tryProcessExport(cn, fn);
            if (this.tryProcessInjected(fn) == null) {
                iter.remove();
            }
            this.tryProcessEvent(fn);
        }
    }

    private void tryProcessTLS(ClassNode cn, FieldNode fn) {
        AnnotationNode an = null;
        an = Preprocessor.getAnnotation(fn, TLS_TYPE);
        if (an != null) {
            fn.visibleAnnotations.remove(an);
            String origDesc = fn.desc;
            String boxedDesc = this.boxDesc(origDesc);
            fn.desc = "Ljava/lang/ThreadLocal;";
            fn.signature = fn.desc.substring(0, fn.desc.length() - 1) + "<" + boxedDesc + ">;";
            this.initTLS(cn, fn, origDesc);
        }
    }

    private void tryProcessExport(ClassNode cn, FieldNode fn) {
        AnnotationNode an = null;
        an = Preprocessor.getAnnotation(fn, EXPORT_TYPE);
        if (an != null) {
            fn.visibleAnnotations.remove(an);
            String origDesc = fn.desc;
            this.initExport(cn, fn, origDesc);
        }
    }

    private FieldNode tryProcessInjected(FieldNode fn) {
        AnnotationNode an = null;
        an = Preprocessor.getAnnotation(fn, INJECTED_TYPE);
        if (an != null) {
            if (fn.visibleAnnotations != null) {
                fn.visibleAnnotations.remove(an);
            }
            if (fn.invisibleAnnotations != null) {
                fn.invisibleAnnotations.remove(an);
            }
            this.injectedFlds.put(fn.name, an);
            return null;
        }
        return fn;
    }

    private void tryProcessEvent(FieldNode fn) {
        AnnotationNode an = Preprocessor.getAnnotation(fn, EVENT_TYPE);
        if (an != null) {
            if (fn.visibleAnnotations != null) {
                fn.visibleAnnotations.remove(an);
            }
            if (fn.invisibleAnnotations != null) {
                fn.invisibleAnnotations.remove(an);
            }
            this.eventFlds.put(fn.name, an);
        }
    }

    private void initTLS(ClassNode cn, FieldNode fn, String typeDesc) {
        this.tlsFldNames.add(fn.name);
        this.initAnnotatedField(fn, typeDesc, this.tlsInitSequence(cn, fn.name, fn.desc));
    }

    private InsnList tlsInitSequence(ClassNode cn, String name, String desc) {
        InsnList initList = new InsnList();
        initList.add((AbstractInsnNode)new MethodInsnNode(184, "org/openjdk/btrace/runtime/BTraceRuntimeAccess", "newThreadLocal", NEW_TLS_DESC, false));
        initList.add((AbstractInsnNode)new FieldInsnNode(179, cn.name, name, desc));
        return initList;
    }

    private void initExport(ClassNode cn, FieldNode fn, String typeDesc) {
        this.exportFldNames.add(fn.name);
        this.initAnnotatedField(fn, typeDesc, this.exportInitSequence(cn, fn.name, fn.desc));
    }

    private InsnList exportInitSequence(ClassNode cn, String name, String desc) {
        InsnList init = new InsnList();
        init.add((AbstractInsnNode)this.getRuntimeImpl(cn));
        init.add((AbstractInsnNode)new InsnNode(95));
        init.add((AbstractInsnNode)new LdcInsnNode((Object)this.perfCounterName(cn, name)));
        init.add((AbstractInsnNode)new LdcInsnNode((Object)desc));
        init.add((AbstractInsnNode)new MethodInsnNode(182, "org/openjdk/btrace/runtime/BTraceRuntimeImplBase", "newPerfCounter", NEW_PERFCOUNTER_DESC, false));
        return init;
    }

    private void initAnnotatedField(FieldNode fn, String typeDesc, InsnList initList) {
        Object initVal = fn.value;
        fn.value = null;
        fn.access |= 0x10;
        InsnList l = this.clinit.instructions;
        if (TypeUtils.isPrimitive(typeDesc)) {
            MethodInsnNode boxNode = this.boxNode(typeDesc);
            initList.insert((AbstractInsnNode)boxNode);
        }
        if (initVal != null) {
            initList.insert((AbstractInsnNode)new LdcInsnNode(initVal));
        } else {
            FieldInsnNode initNode = this.findNodeInitialization(fn);
            if (initNode != null) {
                l.insert((AbstractInsnNode)initNode, initList);
                l.remove((AbstractInsnNode)initNode);
                return;
            }
            this.addDefaultVal(Type.getType((String)typeDesc), initList);
        }
        MethodInsnNode rtStart = this.findBTraceRuntimeStart();
        if (rtStart != null) {
            l.insertBefore((AbstractInsnNode)rtStart, initList);
        } else {
            l.add(initList);
        }
    }

    private void addDefaultVal(Type t, InsnList l) {
        switch (t.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                l.insert((AbstractInsnNode)new InsnNode(3));
                break;
            }
            case 7: {
                l.insert((AbstractInsnNode)new InsnNode(9));
                break;
            }
            case 6: {
                l.insert((AbstractInsnNode)new InsnNode(11));
                break;
            }
            case 8: {
                l.insert((AbstractInsnNode)new InsnNode(14));
                break;
            }
            default: {
                l.insert((AbstractInsnNode)new InsnNode(1));
            }
        }
    }

    private void checkAugmentedReturn(MethodNode mn) {
        if (Preprocessor.isUnannotated(mn)) {
            return;
        }
        Type retType = Type.getReturnType((String)mn.desc);
        if (retType.getSort() != 0 && this.getReturnMethodParameter(mn) == Integer.MIN_VALUE) {
            BTraceMethodNode bmn;
            OnMethod om;
            String oldDesc = mn.desc;
            Type[] args = Type.getArgumentTypes((String)mn.desc);
            args = Arrays.copyOf(args, args.length + 1);
            args[args.length - 1] = retType;
            ArrayList<AnnotationNode> annots = new ArrayList<AnnotationNode>();
            AnnotationNode an = new AnnotationNode(Type.getDescriptor(Return.class));
            annots.add(an);
            mn.visibleParameterAnnotations = mn.visibleParameterAnnotations != null ? Arrays.copyOf(mn.visibleParameterAnnotations, args.length) : new List[args.length];
            mn.visibleParameterAnnotations[args.length - 1] = annots;
            mn.desc = Type.getMethodDescriptor((Type)retType, (Type[])args);
            if (mn instanceof BTraceMethodNode && (om = (bmn = (BTraceMethodNode)mn).getOnMethod()) != null && om.getTargetName().equals(mn.name) && om.getTargetDescriptor().equals(oldDesc)) {
                om.setReturnParameter(this.getReturnMethodParameter(mn));
                om.setTargetDescriptor(mn.desc);
            }
        }
    }

    private void scanMethodInstructions(ClassNode cn, MethodNode mn, LocalVarGenerator lvg) {
        if (mn.name.startsWith("<")) {
            return;
        }
        this.serviceLocals.clear();
        boolean checkFields = !this.tlsFldNames.isEmpty() || !this.exportFldNames.isEmpty() || !this.injectedFlds.isEmpty();
        int retopcode = Type.getReturnType((String)mn.desc).getOpcode(172);
        InsnList l = mn.instructions;
        AbstractInsnNode n = l.getFirst();
        while (n != null) {
            int type = n.getType();
            if (checkFields && type == 4) {
                FieldInsnNode fin = (FieldInsnNode)n;
                if (fin.owner.equals(cn.name)) {
                    if (this.tlsFldNames.contains(fin.name) && !fin.desc.equals("Ljava/lang/ThreadLocal;")) {
                        n = this.updateTLSUsage(fin, l);
                    } else if (this.exportFldNames.contains(fin.name)) {
                        n = this.updateExportUsage(cn, fin, l);
                    } else if (this.injectedFlds.containsKey(fin.name)) {
                        n = this.updateInjectedUsage(cn, fin, l, lvg);
                    }
                }
            } else if (type == 5) {
                MethodInsnNode min = (MethodInsnNode)n;
                n = this.unfoldServiceInstantiation(cn, min, l);
            } else if (n.getOpcode() == retopcode && this.getClassifiers(mn).contains((Object)MethodClassifier.RT_AWARE)) {
                this.addBTraceRuntimeExit(cn, (InsnNode)n, l);
            }
            n = n != null ? n.getNext() : null;
        }
    }

    private void recalculateVars(final MethodNode mn) {
        for (AbstractInsnNode n = mn.instructions.getFirst(); n != null; n = n.getNext()) {
            if (n.getType() != 2) continue;
            VarInsnNode vin = (VarInsnNode)n;
            vin.var = LocalVarGenerator.translateIdx(vin.var);
        }
        StackTrackingMethodVisitor v = new StackTrackingMethodVisitor(new MethodVisitor(458752){

            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack, maxLocals);
                mn.maxStack = maxStack;
                mn.maxLocals = maxLocals;
            }
        }, mn.name, mn.desc, (mn.access & 8) > 0);
        mn.accept((MethodVisitor)v);
    }

    private void processClinit(ClassNode cn) {
        for (MethodNode mn : this.getMethods(cn)) {
            if (!mn.name.equals("<clinit>")) continue;
            this.clinit = mn;
            break;
        }
        if (this.clinit == null) {
            this.clinit = new MethodNode(458752, 9, "<clinit>", "()V", null, new String[0]);
            this.clinit.instructions.add((AbstractInsnNode)new InsnNode(177));
            cn.methods.add(0, this.clinit);
        }
        this.initRuntime(cn, this.clinit);
    }

    private void initRuntime(ClassNode cn, MethodNode clinit) {
        this.addRuntimeNode(cn);
        InsnList l = new InsnList();
        l.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType((String)cn.name)));
        l.add(this.loadTimerHandlers(cn));
        l.add(this.loadEventHandlers(cn));
        l.add(this.loadErrorHandlers(cn));
        l.add(this.loadExitHandlers(cn));
        l.add(this.loadLowMemoryHandlers(cn));
        l.add((AbstractInsnNode)new MethodInsnNode(184, "org/openjdk/btrace/runtime/BTraceRuntimeAccess", "forClass", BTRACERT_FOR_CLASS_DESC, false));
        l.add((AbstractInsnNode)new FieldInsnNode(179, cn.name, this.rtField.name, this.rtField.desc));
        l.add((AbstractInsnNode)this.getRuntimeImpl(cn));
        this.addRuntimeCheck(cn, clinit, l, true);
        this.clinitEntryPoint = l.getLast();
        clinit.instructions.insert(l);
        this.startRuntime(cn, clinit);
    }

    private InsnList loadTimerHandlers(ClassNode cn) {
        InsnList il = new InsnList();
        int cnt = 0;
        for (MethodNode mn : cn.methods) {
            Iterator anValueIterator;
            if (mn.visibleAnnotations == null) continue;
            AnnotationNode an = (AnnotationNode)mn.visibleAnnotations.get(0);
            if (!an.desc.equals(Constants.ONTIMER_DESC) || (anValueIterator = an.values != null ? an.values.iterator() : null) == null) continue;
            long period = -1L;
            String property = null;
            while (anValueIterator.hasNext()) {
                String key = (String)anValueIterator.next();
                Object value = anValueIterator.next();
                if (value == null) continue;
                switch (key) {
                    case "value": {
                        period = (Long)value;
                        break;
                    }
                    case "from": {
                        property = (String)value;
                    }
                }
            }
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)cnt++));
            il.add((AbstractInsnNode)new TypeInsnNode(187, TIMERHANDLER_INTERNAL));
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)mn.name));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)period));
            il.add((AbstractInsnNode)(property != null ? new LdcInsnNode((Object)property) : new InsnNode(1)));
            il.add((AbstractInsnNode)new MethodInsnNode(183, TIMERHANDLER_INTERNAL, "<init>", "(Ljava/lang/String;JLjava/lang/String;)V", false));
            il.add((AbstractInsnNode)new InsnNode(83));
        }
        if (cnt > 0) {
            InsnList newArray = new InsnList();
            newArray.add((AbstractInsnNode)new LdcInsnNode((Object)cnt));
            newArray.add((AbstractInsnNode)new TypeInsnNode(189, TIMERHANDLER_INTERNAL));
            il.insert(newArray);
        } else {
            il.insert((AbstractInsnNode)new InsnNode(1));
        }
        return il;
    }

    private InsnList loadEventHandlers(ClassNode cn) {
        InsnList il = new InsnList();
        int cnt = 0;
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            AnnotationNode an = (AnnotationNode)mn.visibleAnnotations.get(0);
            if (!an.desc.equals(Constants.ONEVENT_DESC)) continue;
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)cnt++));
            il.add((AbstractInsnNode)new TypeInsnNode(187, EVENTHANDLER_INTERNAL));
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)mn.name));
            il.add((AbstractInsnNode)(an.values != null ? new LdcInsnNode(an.values.get(1)) : new InsnNode(1)));
            il.add((AbstractInsnNode)new MethodInsnNode(183, EVENTHANDLER_INTERNAL, "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", false));
            il.add((AbstractInsnNode)new InsnNode(83));
        }
        if (cnt > 0) {
            InsnList newArray = new InsnList();
            newArray.add((AbstractInsnNode)new LdcInsnNode((Object)cnt));
            newArray.add((AbstractInsnNode)new TypeInsnNode(189, EVENTHANDLER_INTERNAL));
            il.insert(newArray);
        } else {
            il.insert((AbstractInsnNode)new InsnNode(1));
        }
        return il;
    }

    private InsnList loadErrorHandlers(ClassNode cn) {
        InsnList il = new InsnList();
        int cnt = 0;
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            AnnotationNode an = (AnnotationNode)mn.visibleAnnotations.get(0);
            if (!an.desc.equals(Constants.ONERROR_DESC)) continue;
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)cnt++));
            il.add((AbstractInsnNode)new TypeInsnNode(187, ERRORHANDLER_INTERNAL));
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)mn.name));
            il.add((AbstractInsnNode)new MethodInsnNode(183, ERRORHANDLER_INTERNAL, "<init>", SERVICE_CTR_DESC, false));
            il.add((AbstractInsnNode)new InsnNode(83));
        }
        if (cnt > 0) {
            InsnList newArray = new InsnList();
            newArray.add((AbstractInsnNode)new LdcInsnNode((Object)cnt));
            newArray.add((AbstractInsnNode)new TypeInsnNode(189, ERRORHANDLER_INTERNAL));
            il.insert(newArray);
        } else {
            il.insert((AbstractInsnNode)new InsnNode(1));
        }
        return il;
    }

    private InsnList loadExitHandlers(ClassNode cn) {
        InsnList il = new InsnList();
        int cnt = 0;
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            AnnotationNode an = (AnnotationNode)mn.visibleAnnotations.get(0);
            if (!an.desc.equals(Constants.ONEXIT_DESC)) continue;
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)cnt++));
            il.add((AbstractInsnNode)new TypeInsnNode(187, EXITHANDLER_INTERNAL));
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)mn.name));
            il.add((AbstractInsnNode)new MethodInsnNode(183, EXITHANDLER_INTERNAL, "<init>", SERVICE_CTR_DESC, false));
            il.add((AbstractInsnNode)new InsnNode(83));
        }
        if (cnt > 0) {
            InsnList newArray = new InsnList();
            newArray.add((AbstractInsnNode)new LdcInsnNode((Object)cnt));
            newArray.add((AbstractInsnNode)new TypeInsnNode(189, EXITHANDLER_INTERNAL));
            il.insert(newArray);
        } else {
            il.insert((AbstractInsnNode)new InsnNode(1));
        }
        return il;
    }

    private InsnList loadLowMemoryHandlers(ClassNode cn) {
        InsnList il = new InsnList();
        int cnt = 0;
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            AnnotationNode an = (AnnotationNode)mn.visibleAnnotations.get(0);
            if (!an.desc.equals(Constants.ONLOWMEMORY_DESC)) continue;
            String pool = "";
            long threshold = Long.MAX_VALUE;
            String thresholdProp = null;
            block11: for (int i = 0; i < an.values.size(); i += 2) {
                String key = (String)an.values.get(i);
                Object val = an.values.get(i + 1);
                switch (key) {
                    case "pool": {
                        pool = (String)val;
                        continue block11;
                    }
                    case "threshold": {
                        threshold = (Long)val;
                        continue block11;
                    }
                    case "thresholdFrom": {
                        thresholdProp = (String)val;
                    }
                }
            }
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)cnt++));
            il.add((AbstractInsnNode)new TypeInsnNode(187, LOWMEMORYHANDLER_INTERNAL));
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)mn.name));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)pool));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)threshold));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)thresholdProp));
            il.add((AbstractInsnNode)new MethodInsnNode(183, LOWMEMORYHANDLER_INTERNAL, "<init>", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;)V", false));
            il.add((AbstractInsnNode)new InsnNode(83));
        }
        if (cnt > 0) {
            InsnList newArray = new InsnList();
            newArray.add((AbstractInsnNode)new LdcInsnNode((Object)cnt));
            newArray.add((AbstractInsnNode)new TypeInsnNode(189, EXITHANDLER_INTERNAL));
            il.insert(newArray);
        } else {
            il.insert((AbstractInsnNode)new InsnNode(1));
        }
        return il;
    }

    private void startRuntime(ClassNode cNode, MethodNode clinit1) {
        for (AbstractInsnNode n = clinit1.instructions.getFirst(); n != null; n = n.getNext()) {
            if (n.getOpcode() != 177) continue;
            AbstractInsnNode prev = n.getPrevious();
            if (prev != null && prev.getType() == 5) {
                MethodInsnNode min = (MethodInsnNode)prev;
                if (min.name.equals("leave")) continue;
            }
            InsnList il = new InsnList();
            il.add((AbstractInsnNode)this.getRuntimeImpl(cNode));
            il.add((AbstractInsnNode)new MethodInsnNode(182, "org/openjdk/btrace/runtime/BTraceRuntimeImplBase", "start", "()V", false));
            clinit1.instructions.insertBefore(n, il);
        }
    }

    private FieldInsnNode getRuntimeImpl(ClassNode cn) {
        return new FieldInsnNode(178, cn.name, this.rtField.name, this.rtField.desc);
    }

    private InsnList getRuntimeExit(ClassNode cn) {
        InsnList il = new InsnList();
        il.add((AbstractInsnNode)this.getRuntimeImpl(cn));
        il.add((AbstractInsnNode)new MethodInsnNode(182, "org/openjdk/btrace/runtime/BTraceRuntimeImplBase", "leave", "()V", false));
        return il;
    }

    private void addRuntimeNode(ClassNode cn) {
        this.rtField = new FieldNode(458752, 9, "runtime", Type.getDescriptor(BTraceRuntimeImplBase.class), null, null);
        cn.fields.add(0, this.rtField);
    }

    private void addBTraceErrorHandler(ClassNode cn, MethodNode mn) {
        if (!mn.name.equals("<clinit>") && Preprocessor.isUnannotated(mn)) {
            return;
        }
        EnumSet<MethodClassifier> clsf = this.getClassifiers(mn);
        if (!clsf.isEmpty()) {
            LabelNode from = new LabelNode();
            LabelNode to = new LabelNode();
            InsnList l = mn.instructions;
            l.insert((AbstractInsnNode)from);
            l.add((AbstractInsnNode)to);
            l.add((AbstractInsnNode)this.throwableHandlerFrame(mn));
            l.add((AbstractInsnNode)this.getRuntimeImpl(cn));
            l.add((AbstractInsnNode)new InsnNode(90));
            l.add((AbstractInsnNode)new InsnNode(95));
            l.add((AbstractInsnNode)new MethodInsnNode(182, "org/openjdk/btrace/runtime/BTraceRuntimeImplBase", "handleException", BTRACERT_HANDLE_EXCEPTION_DESC, false));
            l.add(this.getReturnSequence(cn, mn, true));
            mn.tryCatchBlocks.add(new TryCatchBlockNode(from, to, to, "java/lang/Throwable"));
        }
    }

    private FrameNode throwableHandlerFrame(MethodNode mn) {
        ArrayList<Object> locals = new ArrayList<Object>();
        for (Type argType : Type.getArgumentTypes((String)mn.desc)) {
            if (TypeUtils.isPrimitive(argType)) {
                switch (argType.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        locals.add(Opcodes.INTEGER);
                        break;
                    }
                    case 6: {
                        locals.add(Opcodes.FLOAT);
                        break;
                    }
                    case 8: {
                        locals.add(Opcodes.DOUBLE);
                        break;
                    }
                    case 7: {
                        locals.add(Opcodes.LONG);
                    }
                }
                continue;
            }
            locals.add(argType.getInternalName());
        }
        return new FrameNode(0, locals.size(), locals.toArray(new Object[0]), 1, new Object[]{"java/lang/Throwable"});
    }

    private void addBTraceRuntimeEnter(ClassNode cn, MethodNode mn) {
        if (mn.name.equals("<clinit>")) {
            return;
        }
        EnumSet<MethodClassifier> clsf = this.getClassifiers(mn);
        if (clsf.contains((Object)MethodClassifier.RT_AWARE)) {
            InsnList entryCheck = new InsnList();
            entryCheck.add((AbstractInsnNode)this.getRuntimeImpl(cn));
            if (clsf.contains((Object)MethodClassifier.GUARDED)) {
                this.addRuntimeCheck(cn, mn, entryCheck, false);
            }
            mn.instructions.insert(entryCheck);
        }
    }

    private void addRuntimeCheck(ClassNode cn, MethodNode mn, InsnList entryCheck, boolean b) {
        LabelNode start = new LabelNode();
        entryCheck.add((AbstractInsnNode)new MethodInsnNode(184, "org/openjdk/btrace/runtime/BTraceRuntimeAccess", "enter", BTRACERT_ENTER_DESC, false));
        entryCheck.add((AbstractInsnNode)new JumpInsnNode(154, start));
        entryCheck.add(this.getReturnSequence(cn, mn, b));
        entryCheck.add((AbstractInsnNode)start);
        entryCheck.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
    }

    private void addBTraceRuntimeExit(ClassNode cn, InsnNode n, InsnList l) {
        l.insertBefore((AbstractInsnNode)n, this.getRuntimeExit(cn));
    }

    private void addJfrHandlerField(ClassNode cn, MethodNode mn) {
        if (mn.visibleAnnotations != null) {
            for (AnnotationNode annotation : mn.visibleAnnotations) {
                if (!annotation.desc.equals(Constants.JFRPERIODIC_DESC)) continue;
                String fldName = JFR_HANDLER_FIELD_PREFIX + mn.name;
                cn.fields.add(new FieldNode(458752, 9, fldName, Constants.JFREVENTFACTORY_DESC, null, null));
                this.eventFlds.put(fldName, annotation);
            }
        }
    }

    private List<MethodNode> getMethods(ClassNode cn) {
        return cn.methods;
    }

    private List<FieldNode> getFields(ClassNode cn) {
        return cn.fields;
    }

    private List<AnnotationNode> getAnnotations(MethodNode mn) {
        return mn.visibleAnnotations != null ? mn.visibleAnnotations : Collections.emptyList();
    }

    private EnumSet<MethodClassifier> getClassifiers(MethodNode mn) {
        EnumSet<MethodClassifier> classifiers = this.classifierMap.get(mn);
        if (classifiers != null) {
            return classifiers;
        }
        if (mn.name.equals("<clinit>")) {
            return EnumSet.of(MethodClassifier.RT_AWARE);
        }
        if (this.jfrHandlerNames.contains(mn.name)) {
            return EnumSet.of(MethodClassifier.RT_AWARE, MethodClassifier.GUARDED);
        }
        List<AnnotationNode> annots = this.getAnnotations(mn);
        classifiers = EnumSet.noneOf(MethodClassifier.class);
        if (!annots.isEmpty()) {
            for (AnnotationNode an : annots) {
                if (RT_AWARE_ANNOTS.contains(an.desc)) {
                    classifiers.add(MethodClassifier.RT_AWARE);
                }
                if (!GUARDED_ANNOTS.contains(an.desc)) continue;
                classifiers.add(MethodClassifier.GUARDED);
            }
        }
        return classifiers;
    }

    private FieldInsnNode findNodeInitialization(FieldNode fn) {
        for (AbstractInsnNode n = this.clinit.instructions.getFirst(); n != null; n = n.getNext()) {
            FieldInsnNode fldInsnNode;
            if (n.getType() != 4 || (fldInsnNode = (FieldInsnNode)n).getOpcode() != 179 || !fldInsnNode.name.equals(fn.name)) continue;
            return fldInsnNode;
        }
        return null;
    }

    private MethodInsnNode findBTraceRuntimeStart() {
        for (AbstractInsnNode n = this.clinit.instructions.getFirst(); n != null; n = n.getNext()) {
            MethodInsnNode min;
            if (n.getType() != 5 || (min = (MethodInsnNode)n).getOpcode() != 182 || !min.owner.equals("org/openjdk/btrace/runtime/BTraceRuntimeImplBase") || !min.name.equals("start")) continue;
            return min;
        }
        return null;
    }

    private AbstractInsnNode updateTLSUsage(FieldInsnNode fin, InsnList l) {
        String unboxedDesc = fin.desc;
        int opcode = fin.getOpcode();
        fin.setOpcode(178);
        fin.desc = "Ljava/lang/ThreadLocal;";
        String boxedDesc = this.boxDesc(unboxedDesc);
        if (opcode == 178) {
            MethodInsnNode unboxNode;
            InsnList toInsert = new InsnList();
            MethodInsnNode getNode = new MethodInsnNode(182, "java/lang/ThreadLocal", "get", TLS_GET_DESC, false);
            toInsert.add((AbstractInsnNode)getNode);
            String boxedInternal = boxedDesc.substring(1, boxedDesc.length() - 1);
            toInsert.add((AbstractInsnNode)new TypeInsnNode(192, boxedInternal));
            if (!boxedDesc.equals(unboxedDesc) && (unboxNode = this.unboxNode(boxedDesc, boxedInternal, unboxedDesc)) != null) {
                toInsert.add((AbstractInsnNode)unboxNode);
            }
            l.insert((AbstractInsnNode)fin, toInsert);
        } else if (opcode == 179) {
            MethodInsnNode boxNode = null;
            if (!boxedDesc.equals(unboxedDesc)) {
                boxNode = this.boxNode(unboxedDesc, boxedDesc);
                l.insert(fin.getPrevious(), (AbstractInsnNode)boxNode);
            }
            MethodInsnNode setNode = new MethodInsnNode(182, "java/lang/ThreadLocal", "set", TLS_SET_DESC, false);
            l.insert((AbstractInsnNode)fin, (AbstractInsnNode)setNode);
            l.insertBefore((AbstractInsnNode)setNode, (AbstractInsnNode)new InsnNode(95));
        }
        return fin;
    }

    private AbstractInsnNode updateExportUsage(ClassNode cn, FieldInsnNode fin, InsnList l) {
        String prefix = null;
        boolean isPut = false;
        if (fin.getOpcode() == 178) {
            prefix = "getPerf";
        } else {
            isPut = true;
            prefix = "putPerf";
        }
        String methodName = null;
        Type tType = null;
        Type t = Type.getType((String)fin.desc);
        switch (t.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                methodName = prefix + "Int";
                tType = Type.INT_TYPE;
                break;
            }
            case 7: {
                methodName = prefix + "Long";
                tType = Type.LONG_TYPE;
                break;
            }
            case 6: {
                methodName = prefix + "Float";
                tType = Type.FLOAT_TYPE;
                break;
            }
            case 8: {
                methodName = prefix + "Double";
                tType = Type.DOUBLE_TYPE;
                break;
            }
            case 10: {
                if (!t.equals((Object)Constants.STRING_TYPE)) break;
                methodName = prefix + "String";
                tType = Constants.STRING_TYPE;
            }
        }
        if (methodName == null) {
            l.insert((AbstractInsnNode)fin, (AbstractInsnNode)(isPut ? new InsnNode(87) : new InsnNode(1)));
        } else {
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)this.getRuntimeImpl(cn));
            if (isPut) {
                if (tType.getSize() == 1) {
                    toInsert.add((AbstractInsnNode)new InsnNode(95));
                } else {
                    toInsert.add((AbstractInsnNode)new InsnNode(91));
                    toInsert.add((AbstractInsnNode)new InsnNode(87));
                }
            }
            toInsert.add((AbstractInsnNode)new LdcInsnNode((Object)this.perfCounterName(cn, fin.name)));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "org/openjdk/btrace/runtime/BTraceRuntimeImplBase", methodName, isPut ? Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{tType, Constants.STRING_TYPE}) : Type.getMethodDescriptor((Type)tType, (Type[])new Type[]{Constants.STRING_TYPE}), false));
            l.insert((AbstractInsnNode)fin, toInsert);
        }
        AbstractInsnNode ret = fin.getNext();
        l.remove((AbstractInsnNode)fin);
        return ret;
    }

    private AbstractInsnNode updateInjectedUsage(ClassNode cn, FieldInsnNode fin, InsnList l, LocalVarGenerator lvg) {
        if (this.serviceLocals.containsKey(fin.name)) {
            VarInsnNode load = new VarInsnNode(Type.getType((String)fin.desc).getOpcode(21), this.serviceLocals.get(fin.name).intValue());
            l.insert((AbstractInsnNode)fin, (AbstractInsnNode)load);
            l.remove((AbstractInsnNode)fin);
            return load;
        }
        InsnList toInsert = new InsnList();
        AnnotationNode an = this.injectedFlds.get(fin.name);
        Type implType = Type.getType((String)fin.desc);
        String svcType = "SIMPLE";
        String fctryMethod = null;
        if (an.values != null) {
            Iterator iter = an.values.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object val = iter.next();
                switch (name) {
                    case "value": {
                        svcType = ((String[])val)[1];
                        break;
                    }
                    case "factoryMethod": {
                        fctryMethod = (String)val;
                    }
                }
            }
        }
        int varIdx = lvg.newVar(implType);
        if (svcType.equals("SIMPLE")) {
            if (fctryMethod == null || fctryMethod.isEmpty()) {
                toInsert.add((AbstractInsnNode)new TypeInsnNode(187, implType.getInternalName()));
                toInsert.add((AbstractInsnNode)new InsnNode(89));
                toInsert.add((AbstractInsnNode)new InsnNode(89));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(183, implType.getInternalName(), "<init>", "()V", false));
            } else {
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, implType.getInternalName(), fctryMethod, Type.getMethodDescriptor((Type)implType, (Type[])new Type[0]), false));
                toInsert.add((AbstractInsnNode)new InsnNode(89));
            }
        } else if (fctryMethod == null || fctryMethod.isEmpty()) {
            toInsert.add((AbstractInsnNode)new TypeInsnNode(187, implType.getInternalName()));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)this.getRuntimeImpl(cn));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(183, implType.getInternalName(), "<init>", RT_SERVICE_CTR_DESC, false));
        } else {
            toInsert.add((AbstractInsnNode)this.getRuntimeImpl(cn));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, implType.getInternalName(), fctryMethod, Type.getMethodDescriptor((Type)implType, (Type[])new Type[]{RT_CTX_TYPE}), false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
        }
        toInsert.add((AbstractInsnNode)new VarInsnNode(58, varIdx));
        l.insert((AbstractInsnNode)fin, toInsert);
        AbstractInsnNode next = fin.getNext();
        l.remove((AbstractInsnNode)fin);
        this.serviceLocals.put(fin.name, varIdx);
        return next;
    }

    private AbstractInsnNode unfoldServiceInstantiation(ClassNode cn, MethodInsnNode min, InsnList l) {
        if (min.owner.equals(SERVICE_INTERNAL)) {
            AbstractInsnNode next = min.getNext();
            switch (min.name) {
                case "simple": {
                    Type[] args = Type.getArgumentTypes((String)min.desc);
                    if (args.length == 1) {
                        AbstractInsnNode ldcType = min.getPrevious();
                        if (ldcType.getType() != 9) break;
                        l.remove((AbstractInsnNode)min);
                        l.remove(ldcType);
                        if (next.getOpcode() == 192) {
                            next = next.getNext();
                            l.remove(next.getPrevious());
                        }
                        String sType = ((Type)((LdcInsnNode)ldcType).cst).getInternalName();
                        InsnList toInsert = new InsnList();
                        toInsert.add((AbstractInsnNode)new TypeInsnNode(187, sType));
                        toInsert.add((AbstractInsnNode)new InsnNode(89));
                        toInsert.add((AbstractInsnNode)new MethodInsnNode(183, sType, "<init>", "()V", false));
                        l.insertBefore(next, toInsert);
                        break;
                    }
                    if (args.length != 2) break;
                    AbstractInsnNode ldcType = min.getPrevious();
                    AbstractInsnNode ldcFMethod = ldcType.getPrevious();
                    if (ldcType.getType() != 9 || ldcFMethod.getType() != 9) break;
                    l.remove((AbstractInsnNode)min);
                    l.remove(ldcType);
                    l.remove(ldcFMethod);
                    if (next.getOpcode() == 192) {
                        next = next.getNext();
                        l.remove(next.getPrevious());
                    }
                    String sType = ((Type)((LdcInsnNode)ldcType).cst).getInternalName();
                    String fMethod = (String)((LdcInsnNode)ldcFMethod).cst;
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new TypeInsnNode(187, sType));
                    toInsert.add((AbstractInsnNode)new InsnNode(89));
                    toInsert.add((AbstractInsnNode)new LdcInsnNode((Object)fMethod));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(183, sType, "<init>", SERVICE_CTR_DESC, false));
                    l.insertBefore(next, toInsert);
                    break;
                }
                case "runtime": {
                    AbstractInsnNode ldcType;
                    Type[] args = Type.getArgumentTypes((String)min.desc);
                    if (args.length != 1 || (ldcType = min.getPrevious()).getType() != 9) break;
                    l.remove((AbstractInsnNode)min);
                    l.remove(ldcType);
                    if (next.getOpcode() == 192) {
                        next = next.getNext();
                        l.remove(next.getPrevious());
                    }
                    String sType = ((Type)((LdcInsnNode)ldcType).cst).getInternalName();
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new TypeInsnNode(187, sType));
                    toInsert.add((AbstractInsnNode)new InsnNode(89));
                    toInsert.add((AbstractInsnNode)this.getRuntimeImpl(cn));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(183, sType, "<init>", RT_SERVICE_CTR_DESC, false));
                    l.insertBefore(next, toInsert);
                    break;
                }
            }
            return next;
        }
        return min;
    }

    private InsnList getReturnSequence(ClassNode cn, MethodNode mn, boolean addRuntimeExit) {
        InsnList l = new InsnList();
        Type retType = Type.getReturnType((String)mn.desc);
        if (!retType.equals((Object)Type.VOID_TYPE)) {
            int retIndex = -1;
            if (mn.visibleParameterAnnotations != null) {
                int offset = 0;
                Type[] params = Type.getArgumentTypes((String)mn.desc);
                for (int i = 0; i < mn.visibleParameterAnnotations.length; ++i) {
                    if (mn.visibleParameterAnnotations[i] != null) {
                        for (AnnotationNode an : mn.visibleParameterAnnotations[i]) {
                            if (!an.desc.equals(Type.getDescriptor(Return.class))) continue;
                            retIndex = offset;
                        }
                    }
                    offset += params[i].getSize();
                }
            }
            if (retIndex > -1) {
                l.add((AbstractInsnNode)new VarInsnNode(retType.getOpcode(21), retIndex));
            } else {
                switch (retType.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        l.add((AbstractInsnNode)new InsnNode(3));
                        break;
                    }
                    case 7: {
                        l.add((AbstractInsnNode)new InsnNode(9));
                        break;
                    }
                    case 6: {
                        l.add((AbstractInsnNode)new InsnNode(11));
                        break;
                    }
                    case 8: {
                        l.add((AbstractInsnNode)new InsnNode(14));
                        break;
                    }
                    case 9: 
                    case 10: {
                        l.add((AbstractInsnNode)new InsnNode(1));
                    }
                }
            }
        }
        if (addRuntimeExit) {
            l.add(this.getRuntimeExit(cn));
        }
        l.add((AbstractInsnNode)new InsnNode(retType.getOpcode(172)));
        return l;
    }

    private String perfCounterName(ClassNode cn, String fieldName) {
        return BTRACE_COUNTER_PREFIX + Type.getObjectType((String)cn.name).getInternalName() + "." + fieldName;
    }

    private String boxDesc(String desc) {
        String boxed_desc = BOX_TYPE_MAP.get(desc);
        return boxed_desc != null ? boxed_desc : desc;
    }

    private MethodInsnNode boxNode(String unboxedDesc) {
        String boxedDesc = this.boxDesc(unboxedDesc);
        if (boxedDesc != null) {
            return this.boxNode(unboxedDesc, boxedDesc);
        }
        return null;
    }

    private MethodInsnNode boxNode(String unboxedDesc, String boxedDesc) {
        return new MethodInsnNode(184, boxedDesc.substring(1, boxedDesc.length() - 1), "valueOf", "(" + unboxedDesc + ")" + boxedDesc, false);
    }

    private InsnList debugPrint(String msg) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)(msg != null ? new LdcInsnNode((Object)msg) : new InsnNode(1)));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "org/openjdk/btrace/core/DebugSupport", "info", SERVICE_CTR_DESC));
        return list;
    }

    private MethodInsnNode unboxNode(String boxedDesc, String boxedInternal, String unboxedDesc) {
        String mName = null;
        switch (boxedDesc) {
            case "Ljava/lang/Integer;": {
                mName = "intValue";
                break;
            }
            case "Ljava/lang/Short;": {
                mName = "shortValue";
                break;
            }
            case "Ljava/lang/Long;": {
                mName = "longValue";
                break;
            }
            case "Ljava/lang/Float;": {
                mName = "floatValue";
                break;
            }
            case "Ljava/lang/Double;": {
                mName = "doubleValue";
                break;
            }
            case "Ljava/lang/Boolean;": {
                mName = "booleanValue";
                break;
            }
            case "Ljava/lang/Character;": {
                mName = "charValue";
            }
        }
        if (mName != null) {
            return new MethodInsnNode(182, boxedInternal, mName, "()" + unboxedDesc, false);
        }
        return null;
    }

    private int getReturnMethodParameter(MethodNode mn) {
        if (mn.visibleParameterAnnotations != null) {
            for (int i = 0; i < mn.visibleParameterAnnotations.length; ++i) {
                List paList = mn.visibleParameterAnnotations[i];
                if (paList == null) continue;
                for (Object anObj : paList) {
                    AnnotationNode an = (AnnotationNode)anObj;
                    if (!an.desc.equals(Constants.RETURN_DESC)) continue;
                    return i;
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    static {
        BOX_TYPE_MAP.put("I", "Ljava/lang/Integer;");
        BOX_TYPE_MAP.put("S", "Ljava/lang/Short;");
        BOX_TYPE_MAP.put("J", "Ljava/lang/Long;");
        BOX_TYPE_MAP.put("F", "Ljava/lang/Float;");
        BOX_TYPE_MAP.put("D", "Ljava/lang/Double;");
        BOX_TYPE_MAP.put("B", "Ljava/lang/Byte;");
        BOX_TYPE_MAP.put("Z", "Ljava/lang/Boolean;");
        BOX_TYPE_MAP.put("C", "Ljava/lang/Character;");
        RT_AWARE_ANNOTS.add(Constants.ONMETHOD_DESC);
        RT_AWARE_ANNOTS.add(Constants.ONTIMER_DESC);
        RT_AWARE_ANNOTS.add(Constants.ONEVENT_DESC);
        RT_AWARE_ANNOTS.add(Constants.ONERROR_DESC);
        RT_AWARE_ANNOTS.add(Constants.ONPROBE_DESC);
        RT_AWARE_ANNOTS.add(Constants.JFRPERIODIC_DESC);
        GUARDED_ANNOTS.addAll(RT_AWARE_ANNOTS);
        RT_AWARE_ANNOTS.add(Constants.ONEXIT_DESC);
    }

    private static class LocalVarGenerator {
        private int offset = 0;

        LocalVarGenerator(MethodNode mn) {
            Type[] args;
            for (Type t : args = Type.getArgumentTypes((String)mn.desc)) {
                this.offset += t.getSize();
            }
        }

        static int translateIdx(int idx) {
            if (idx < 0) {
                return -idx - 1;
            }
            return idx;
        }

        int newVar(Type t) {
            int ret = -this.offset - 1;
            this.offset += t.getSize();
            return ret;
        }

        int maxVar() {
            return this.offset;
        }
    }

    private static enum MethodClassifier {
        RT_AWARE,
        GUARDED;

    }
}

