/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.instr.ProbeDescriptor;

final class ProbeDescriptorLoader {
    private static final Map<String, ProbeDescriptor> probeDescMap = new ConcurrentHashMap<String, ProbeDescriptor>();
    private final String[] probeDescDirs;
    private final DebugSupport debug;

    ProbeDescriptorLoader(String probeDescPath, DebugSupport ds) {
        this.probeDescDirs = probeDescPath != null ? probeDescPath.split(File.pathSeparator) : null;
        this.debug = ds;
    }

    ProbeDescriptor load(String namespace) {
        ProbeDescriptor res = probeDescMap.get(namespace);
        if (res != null) {
            if (this.debug.isDebug()) {
                this.debug.debug("probe descriptor cache hit for " + namespace);
            }
            return res;
        }
        InputStream file = this.openDescriptor(namespace);
        if (file == null) {
            if (this.debug.isDebug()) {
                this.debug.debug("didn't find probe descriptor file " + namespace);
            }
            return null;
        }
        ProbeDescriptor pd = this.load(file);
        if (pd != null) {
            if (this.debug.isDebug()) {
                this.debug.debug("read probe descriptor for " + namespace);
            }
            probeDescMap.put(namespace, pd);
        }
        return pd;
    }

    private ProbeDescriptor load(InputStream stream) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.openjdk.btrace.core.annotations:org.openjdk.btrace.instr");
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            ProbeDescriptor pd = (ProbeDescriptor)u.unmarshal(stream);
            pd.setProbes(pd.getProbes());
            return pd;
        }
        catch (JAXBException exp) {
            if (this.debug.isDebug()) {
                this.debug.debug((Throwable)exp);
            }
            return null;
        }
    }

    private InputStream openDescriptor(String namespace) {
        InputStream is = null;
        if (this.probeDescDirs != null) {
            is = this.openDescriptorFromDirs(namespace);
        }
        if (is == null) {
            is = this.openDescriptorFromClassPath(namespace);
        }
        if (is == null && this.debug.isDebug()) {
            this.debug.debug("no probe descriptor found for " + namespace);
        }
        return is;
    }

    private InputStream openDescriptorFromDirs(String namespace) {
        String desc = namespace.trim() + ".xml";
        for (String dir : this.probeDescDirs) {
            File f = new File(dir.trim(), desc);
            if (this.debug.isDebug()) {
                this.debug.debug("looking for probe descriptor file '" + f.getPath() + "' (" + f.exists() + ", " + f.isFile() + ")");
            }
            if (!f.exists() || !f.isFile()) continue;
            if (this.debug.isDebug()) {
                this.debug.debug("probe descriptor for " + namespace + " is " + f);
            }
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream openDescriptorFromClassPath(String namespace) {
        String target = "META-INF/btrace/" + namespace.trim() + ".xml";
        if (this.debug.isDebug()) {
            this.debug.debug("looking for probe descriptor file '" + target);
        }
        return ClassLoader.getSystemResourceAsStream(target);
    }
}

