/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr.templates;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.openjdk.btrace.instr.templates.Template;

public final class BTraceTemplates {
    private static final Map<String, Template> TEMPLATE_MAP = new HashMap<String, Template>();

    public static void registerTemplates(Template ... templates) {
        for (Template t : templates) {
            TEMPLATE_MAP.put(t.getId(), t);
        }
    }

    public static Template getTemplate(String owner, String name, String sig) {
        Template t;
        if (!owner.equals("#")) {
            return null;
        }
        int idx = name.indexOf(58);
        if (idx > -1) {
            String tName = name.substring(0, idx);
            String tagList = name.substring(idx + 1);
            t = BTraceTemplates.getTemplate(Template.getId(owner, tName, sig));
            if (t != null) {
                StringTokenizer st = new StringTokenizer(tagList, ",");
                HashSet<String> tags = new HashSet<String>();
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    tags.add(param);
                }
                t.setTags(tags);
            }
        } else {
            t = BTraceTemplates.getTemplate(Template.getId(owner, name, sig));
        }
        return t;
    }

    private static Template getTemplate(String id) {
        Template t = TEMPLATE_MAP.get(id);
        return t != null ? t.duplicate() : null;
    }
}

