/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr.templates;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openjdk.btrace.instr.templates.BTraceTemplates;
import org.openjdk.btrace.instr.templates.Template;
import org.openjdk.btrace.instr.templates.TemplateExpander;
import org.openjdk.btrace.instr.templates.TemplateExpanderVisitor;

public abstract class BaseTemplateExpander
implements TemplateExpander {
    private final Set<Template> supportedTemplates = new HashSet<Template>();
    private Template lastTemplate = null;

    public BaseTemplateExpander(Template ... templates) {
        this.supportedTemplates.addAll(Arrays.asList(templates));
        BTraceTemplates.registerTemplates(templates);
    }

    @Override
    public final TemplateExpander.Result expand(TemplateExpanderVisitor v, Template t) {
        if (this.lastTemplate == null) {
            if (t == null || !this.supportedTemplates.contains(t)) {
                return TemplateExpander.Result.IGNORED;
            }
            this.recordTemplate(t);
            this.lastTemplate = t;
            return TemplateExpander.Result.CLAIMED;
        }
        if (this.lastTemplate.equals(t)) {
            this.recordTemplate(t);
            return TemplateExpander.Result.CLAIMED;
        }
        TemplateExpander.Result r = this.expandTemplate(v, this.lastTemplate);
        this.lastTemplate = t;
        return t != null ? r : TemplateExpander.Result.IGNORED;
    }

    protected abstract void recordTemplate(Template var1);

    protected abstract TemplateExpander.Result expandTemplate(TemplateExpanderVisitor var1, Template var2);
}

