/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr.templates;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

public final class Template {
    static final String OWNER = "#";
    private final String name;
    private final String sig;
    private final Set<String> tags = new HashSet<String>();
    private final String id;

    public Template(String name, String sig) {
        this.name = name;
        this.sig = sig;
        this.id = Template.getId(OWNER, name, sig);
    }

    public Template(String name, String sig, String ... tags) {
        this.name = name;
        this.sig = sig;
        this.tags.addAll(Arrays.asList(tags));
        this.id = Template.getId(OWNER, name, sig);
    }

    static String getId(String owner, String name, String sig) {
        return owner + '#' + name + OWNER + sig;
    }

    public String getOwner() {
        return OWNER;
    }

    public String getName() {
        return this.name;
    }

    public String getSig() {
        return this.sig;
    }

    public void insert(MethodVisitor mv) {
        this.insert(mv, Collections.emptySet());
    }

    public void insert(MethodVisitor mv, String ... tags) {
        this.insert(mv, new HashSet<String>(Arrays.asList(tags)));
    }

    public void insert(MethodVisitor mv, Set<String> tags) {
        StringBuilder sb = new StringBuilder(this.name);
        boolean head = true;
        for (String t : tags) {
            if (head) {
                head = false;
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(t);
        }
        mv.visitMethodInsn(184, OWNER, sb.toString(), this.sig, false);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    void setTags(String ... tags) {
        this.setTags(Arrays.asList(tags));
    }

    void setTags(Collection<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public Map<String, String> getTagMap() {
        HashMap<String, String> tMap = new HashMap<String, String>();
        for (String t : this.tags) {
            int idx = t.indexOf(61);
            if (idx > -1) {
                String key = t.substring(0, idx);
                String val = t.substring(idx + 1);
                tMap.put(key, val);
                continue;
            }
            tMap.put(t, "");
        }
        return tMap;
    }

    String getId() {
        return this.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "Template{name=" + this.name + ", tags=" + this.tags + '}';
    }

    public final Template duplicate() {
        return new Template(this.name, this.sig);
    }
}

