/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.data;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.dataset.table.Increment;
import io.cdap.cdap.api.dataset.table.Put;
import io.cdap.cdap.api.dataset.table.Table;

public class CountTable<T extends Table> {
    protected static final byte[] TOTALS_ROW_KEY = new byte[]{0};
    protected static final String TOTALS_COL = "totals";
    protected final T table;

    public CountTable(T table) {
        this.table = table;
    }

    protected long getTotalCount() {
        return this.getTotalCount(TOTALS_COL);
    }

    protected long getTotalCount(String col) {
        byte[] total = this.table.get(TOTALS_ROW_KEY, Bytes.toBytes((String)col));
        return total == null ? 0L : Bytes.toLong((byte[])total);
    }

    protected void incrementRowCount() {
        this.incrementRowCount(TOTALS_COL);
    }

    protected void incrementRowCount(String col) {
        this.table.increment(new Increment(TOTALS_ROW_KEY).add(col, 1L));
    }

    protected void decrementRowCount(int rowCount) {
        this.decrementRowCount(rowCount, TOTALS_COL);
    }

    protected void decrementRowCount(int rowCount, String col) {
        long totalCount = this.getTotalCount(col);
        if (totalCount - (long)rowCount < 0L) {
            throw new IllegalStateException("Cannot decrement row count below 0");
        }
        this.table.put(new Put(TOTALS_ROW_KEY).add(col, totalCount - (long)rowCount));
    }
}

