/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.data;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.mmds.splitter.DatasetSplitter;
import io.cdap.mmds.splitter.Splitters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataSplit {
    private final String description;
    private final String type;
    private final Map<String, String> params;
    private final List<String> directives;
    private final Schema schema;

    public DataSplit(String description, String type, Map<String, String> params, List<String> directives, Schema schema) {
        this.description = description;
        this.type = type;
        this.params = params;
        this.directives = directives;
        this.schema = schema;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params == null ? new HashMap() : this.params);
    }

    public List<String> getDirectives() {
        return Collections.unmodifiableList(this.directives == null ? new ArrayList() : this.directives);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSplit that = (DataSplit)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.type, that.type) && Objects.equals(this.params, that.params) && Objects.equals(this.directives, that.directives) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.type, this.params, this.directives, this.schema);
    }

    public void validate() {
        if (this.type == null) {
            throw new IllegalArgumentException("A type must be specified.");
        }
        if (this.schema == null) {
            throw new IllegalArgumentException("A schema must be specified.");
        }
        if (this.directives == null) {
            throw new IllegalArgumentException("Directives must be specified.");
        }
        DatasetSplitter splitter = Splitters.getSplitter(this.type);
        if (splitter == null) {
            throw new IllegalArgumentException("No splitter of type " + this.type + " exists.");
        }
        splitter.getParams(this.getParams());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder> {
        protected String description = "";
        protected String type;
        protected Map<String, String> params = new HashMap<String, String>();
        protected List<String> directives = new ArrayList<String>();
        protected Schema schema;

        public T setDescription(String description) {
            this.description = description;
            return (T)this;
        }

        public T setType(String type) {
            this.type = type;
            return (T)this;
        }

        public T setParams(Map<String, String> params) {
            this.params.clear();
            this.params.putAll(params);
            return (T)this;
        }

        public T setDirectives(List<String> directives) {
            this.directives.clear();
            this.directives.addAll(directives);
            return (T)this;
        }

        public T setSchema(Schema schema) {
            this.schema = schema;
            return (T)this;
        }

        public DataSplit build() {
            DataSplit split = new DataSplit(this.description, this.type, this.params, this.directives, this.schema);
            split.validate();
            return split;
        }
    }
}

