/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.data;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.dataset.DatasetProperties;
import io.cdap.cdap.api.dataset.lib.IndexedTable;
import io.cdap.cdap.api.dataset.table.Put;
import io.cdap.cdap.api.dataset.table.Row;
import io.cdap.cdap.api.dataset.table.Scanner;
import io.cdap.mmds.data.CountTable;
import io.cdap.mmds.data.Experiment;
import io.cdap.mmds.data.ExperimentsMeta;
import io.cdap.mmds.data.SortInfo;
import io.cdap.mmds.data.SortType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class ExperimentMetaTable
extends CountTable<IndexedTable> {
    private static final Gson GSON = new Gson();
    private static final Type LIST_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final String NAME_COL = "name";
    private static final String DESC_COL = "description";
    private static final String SRCPATH_COL = "srcpath";
    private static final String OUTCOME_COL = "outcome";
    private static final String OUTCOME_TYPE_COL = "outcomeType";
    private static final String DIRECTIVES_COL = "directives";
    public static final DatasetProperties DATASET_PROPERTIES = DatasetProperties.builder().add("columnsToIndex", Joiner.on((String)",").join((Object)"name", (Object)"srcpath", new Object[0])).build();

    public ExperimentMetaTable(IndexedTable table) {
        super(table);
    }

    public ExperimentsMeta list(int offset, int limit) {
        return this.list(offset, limit, null, new SortInfo(SortType.ASC));
    }

    public ExperimentsMeta list(int offset, int limit, Predicate<Experiment> predicate, SortInfo sortInfo) {
        int count = 0;
        int cursor = 0;
        SortType sortType = sortInfo.getSortType();
        if (sortType.equals((Object)SortType.DESC) && (offset = (int)(this.getTotalCount() - (long)offset - (long)limit)) < 0) {
            limit -= Math.abs(offset);
            offset = 0;
        }
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        try (Scanner scanner = ((IndexedTable)this.table).scanByIndex(Bytes.toBytes((String)sortInfo.getFields().get(0)), new byte[]{0, 0}, null);){
            Row row;
            while ((row = scanner.next()) != null) {
                if (cursor < offset) {
                    ++cursor;
                    continue;
                }
                if (count >= limit) {
                    break;
                }
                Experiment e = this.fromRow(row);
                if (predicate != null && !predicate.test(e)) continue;
                experiments.add(e);
                ++count;
            }
        }
        if (sortType.equals((Object)SortType.DESC)) {
            Collections.sort(experiments, new Comparator<Experiment>(){

                @Override
                public int compare(Experiment o1, Experiment o2) {
                    return o2.getName().compareTo(o1.getName());
                }
            });
        }
        return new ExperimentsMeta(this.getTotalCount(), experiments);
    }

    @Nullable
    public Experiment get(String name) {
        Row row = ((IndexedTable)this.table).get(Bytes.toBytes((String)name));
        return row.isEmpty() ? null : this.fromRow(row);
    }

    public void delete(String name) {
        ((IndexedTable)this.table).delete(Bytes.toBytes((String)name));
        this.decrementRowCount(1);
    }

    public void put(Experiment experiment) {
        boolean isNewExperiment = this.get(experiment.getName()) == null;
        Put put = new Put(experiment.getName()).add(NAME_COL, experiment.getName()).add(DESC_COL, experiment.getDescription()).add(SRCPATH_COL, experiment.getSrcpath()).add(OUTCOME_COL, experiment.getOutcome()).add(OUTCOME_TYPE_COL, experiment.getOutcomeType()).add(DIRECTIVES_COL, GSON.toJson(experiment.getDirectives()));
        ((IndexedTable)this.table).put(put);
        if (isNewExperiment) {
            this.incrementRowCount();
        }
    }

    private Experiment fromRow(Row row) {
        return new Experiment(row.getString(NAME_COL), row.getString(DESC_COL), row.getString(SRCPATH_COL), row.getString(OUTCOME_COL), row.getString(OUTCOME_TYPE_COL), (List)GSON.fromJson(row.getString(DIRECTIVES_COL), LIST_TYPE));
    }
}

