/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.data;

import io.cdap.mmds.data.ColumnStats;
import io.cdap.mmds.data.Experiment;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExperimentStats
extends Experiment {
    private final Map<String, ColumnStats> evaluationMetrics;
    private final ColumnStats algorithms;
    private final ColumnStats statuses;

    public ExperimentStats(Experiment experiment, Map<String, ColumnStats> evaluationMetrics, ColumnStats algorithms, ColumnStats statuses) {
        super(experiment.getName(), experiment.getDescription(), experiment.getSrcpath(), experiment.getOutcome(), experiment.getOutcomeType(), experiment.getDirectives());
        this.evaluationMetrics = Collections.unmodifiableMap(new HashMap<String, ColumnStats>(evaluationMetrics));
        this.algorithms = algorithms;
        this.statuses = statuses;
    }

    public Map<String, ColumnStats> getEvaluationMetrics() {
        return this.evaluationMetrics;
    }

    public ColumnStats getAlgorithms() {
        return this.algorithms;
    }

    public ColumnStats getStatuses() {
        return this.statuses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExperimentStats that = (ExperimentStats)o;
        return Objects.equals(this.evaluationMetrics, that.evaluationMetrics) && Objects.equals(this.algorithms, that.algorithms) && Objects.equals(this.statuses, that.statuses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.evaluationMetrics, this.algorithms, this.statuses);
    }

    @Override
    public String toString() {
        return "ExperimentStats{evaluationMetrics=" + this.evaluationMetrics + ", algorithms=" + this.algorithms + ", statuses=" + this.statuses + "} " + super.toString();
    }
}

