/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler.param;

import com.google.common.collect.ImmutableSet;
import io.cdap.mmds.modeler.param.RegressionParams;
import io.cdap.mmds.spec.BoolParam;
import io.cdap.mmds.spec.ParamSpec;
import io.cdap.mmds.spec.Params;
import io.cdap.mmds.spec.StringParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;

public class GeneralizedLinearRegressionParams
extends RegressionParams {
    private final StringParam family;
    private final StringParam link;
    private final BoolParam fitIntercept;

    public GeneralizedLinearRegressionParams(Map<String, String> modelParams) {
        super(modelParams);
        this.family = new StringParam("family", "Family", "The error distribution to be used in the model.", "gaussian", (Set<String>)ImmutableSet.of((Object)"gaussian", (Object)"binomial", (Object)"poisson", (Object)"gamma"), modelParams);
        this.link = new StringParam("link", "Link", "Relationship between the linear predictor and the mean of the distribution function.", "identity", (Set<String>)ImmutableSet.of((Object)"identity", (Object)"log", (Object)"inverse", (Object)"logit", (Object)"probit", (Object)"cloglog", (Object[])new String[]{"sqrt"}), modelParams);
        this.fitIntercept = new BoolParam("fitIntercept", "Fit Intercept", "If the intercept should be fit", true, modelParams);
    }

    public void setParams(GeneralizedLinearRegression modeler) {
        modeler.setMaxIter(((Integer)this.maxIterations.getVal()).intValue());
        modeler.setRegParam(((Double)this.regularizationParam.getVal()).doubleValue());
        modeler.setTol(((Double)this.tolerance.getVal()).doubleValue());
        modeler.setFitIntercept(((Boolean)this.fitIntercept.getVal()).booleanValue());
        modeler.setFamily((String)this.family.getVal());
        modeler.setLink((String)this.link.getVal());
    }

    @Override
    public Map<String, String> toMap() {
        return Params.putParams(super.toMap(), this.family, this.link, this.fitIntercept);
    }

    @Override
    public List<ParamSpec> getSpec() {
        return Params.addParams(super.getSpec(), this.family, this.link, this.fitIntercept);
    }
}

