/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler.param;

import com.google.common.collect.ImmutableSet;
import io.cdap.mmds.modeler.param.RegressionParams;
import io.cdap.mmds.spec.BoolParam;
import io.cdap.mmds.spec.ParamSpec;
import io.cdap.mmds.spec.Params;
import io.cdap.mmds.spec.StringParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.ml.regression.LinearRegression;

public class LinearRegressionParams
extends RegressionParams {
    private final BoolParam fitIntercept;
    private final StringParam solver;

    public LinearRegressionParams(Map<String, String> modelParams) {
        super(modelParams);
        this.fitIntercept = new BoolParam("fitIntercept", "Fit Intercept", "If the intercept should be fit", true, modelParams);
        this.solver = new StringParam("solver", "Solver", "The solver algorithm used for optimization. 'l-bfgs' uses Limited-memory BFGS, which is a limited-memory quasi-Newton optimization method. 'normal' uses the Normal Equation as an analytical solution to the problem. 'auto' (default) means that the solver algorithm is selected automatically. The Normal Equations solver will be used when possible, but will automatically fallback to iterative optimization methods when needed.", "auto", (Set<String>)ImmutableSet.of((Object)"auto", (Object)"l-bfgs", (Object)"normal"), modelParams);
    }

    public void setParams(LinearRegression modeler) {
        modeler.setMaxIter(((Integer)this.maxIterations.getVal()).intValue());
        modeler.setStandardization(((Boolean)this.standardization.getVal()).booleanValue());
        modeler.setRegParam(((Double)this.regularizationParam.getVal()).doubleValue());
        modeler.setElasticNetParam(((Double)this.elasticNetParam.getVal()).doubleValue());
        modeler.setTol(((Double)this.tolerance.getVal()).doubleValue());
        modeler.setFitIntercept(((Boolean)this.fitIntercept.getVal()).booleanValue());
        modeler.setSolver((String)this.solver.getVal());
    }

    @Override
    public List<ParamSpec> getSpec() {
        return Params.addParams(super.getSpec(), this.fitIntercept, this.solver);
    }

    @Override
    public Map<String, String> toMap() {
        return Params.putParams(super.toMap(), this.fitIntercept, this.solver);
    }
}

