/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler.param;

import com.google.common.collect.ImmutableSet;
import io.cdap.mmds.spec.DoubleParam;
import io.cdap.mmds.spec.IntArrayParam;
import io.cdap.mmds.spec.IntParam;
import io.cdap.mmds.spec.ParamSpec;
import io.cdap.mmds.spec.Parameters;
import io.cdap.mmds.spec.Params;
import io.cdap.mmds.spec.Range;
import io.cdap.mmds.spec.StringParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;

public class MultilayerPerceptronParams
implements Parameters {
    private final IntParam blockSize;
    private final IntParam maxIterations;
    private final DoubleParam tolerance;
    private final DoubleParam stepSize;
    private final StringParam solver;
    private final IntArrayParam layers;

    public MultilayerPerceptronParams(Map<String, String> modelParams) {
        this.blockSize = new IntParam("blockSize", "Block Size", "Block size for stacking input data in matrices to speed up the computation. Data is stacked within partitions. If block size is more than remaining data in a partition then it is adjusted to the size of this data. Recommended size is between 10 and 1000.", 128, new Range(1, true), modelParams);
        this.maxIterations = new IntParam("maxIterations", "Max Iterations", "maximum number of iterations", 100, new Range(0, true), modelParams);
        this.tolerance = new DoubleParam("tolerance", "Tolerance", "Convergence tolerance of iterations. Smaller values will lead to higher accuracy with the cost of more iterations.", 1.0E-6, new Range(0.0, true), modelParams);
        this.stepSize = new DoubleParam("stepSize", "Step Size", "Step size to be used for each iteration of optimization. (only for 'gd' solver).", 0.03, new Range(0.0, false), modelParams);
        this.solver = new StringParam("solver", "Solver", "The solver algorithm for optimization. 'gd' uses minibatch gradient descent. 'l-bfgs' uses Limited-memory BFGS, which is a limited-memory quasi-Newton optimization method.", "l-bfgs", (Set<String>)ImmutableSet.of((Object)"gd", (Object)"l-bfgs"), modelParams);
        this.layers = new IntArrayParam("layers", "Layers", "Sizes of layers from input layer to output layer. E.g., Array(780, 100, 10) means 780 inputs, one hidden layer with 100 neurons and output layer of 10 neurons.", new int[]{200, 50, 10}, modelParams);
    }

    public void setParams(MultilayerPerceptronClassifier modeler) {
        modeler.setLayers((int[])this.layers.getVal());
        modeler.setBlockSize(((Integer)this.blockSize.getVal()).intValue());
        modeler.setMaxIter(((Integer)this.maxIterations.getVal()).intValue());
        modeler.setTol(((Double)this.tolerance.getVal()).doubleValue());
        modeler.setStepSize(((Double)this.stepSize.getVal()).doubleValue());
        modeler.setSolver((String)this.solver.getVal());
    }

    @Override
    public Map<String, String> toMap() {
        return Params.putParams(new HashMap<String, String>(), this.blockSize, this.maxIterations, this.tolerance, this.stepSize, this.solver, this.layers);
    }

    @Override
    public List<ParamSpec> getSpec() {
        return Params.addParams(new ArrayList<ParamSpec>(), this.blockSize, this.maxIterations, this.tolerance, this.stepSize, this.solver, this.layers);
    }
}

