/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler.param;

import com.google.common.collect.ImmutableSet;
import io.cdap.mmds.spec.DoubleParam;
import io.cdap.mmds.spec.ParamSpec;
import io.cdap.mmds.spec.Parameters;
import io.cdap.mmds.spec.Params;
import io.cdap.mmds.spec.Range;
import io.cdap.mmds.spec.StringParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.ml.classification.NaiveBayes;

public class NaiveBayesParams
implements Parameters {
    private final DoubleParam smoothing;
    private final StringParam type;

    public NaiveBayesParams(Map<String, String> modelParams) {
        this.smoothing = new DoubleParam("smoothing", "Smoothing", "smoothing parameter", 1.0, new Range(0, true), modelParams);
        this.type = new StringParam("type", "Type", "model type", "multinomial", (Set<String>)ImmutableSet.of((Object)"multinomial", (Object)"bernoulli"), modelParams);
    }

    public void setParams(NaiveBayes modeler) {
        modeler.setSmoothing(((Double)this.smoothing.getVal()).doubleValue());
        modeler.setModelType((String)this.type.getVal());
    }

    @Override
    public Map<String, String> toMap() {
        return Params.putParams(new HashMap<String, String>(), this.smoothing, this.type);
    }

    @Override
    public List<ParamSpec> getSpec() {
        return Params.addParams(new ArrayList<ParamSpec>(), this.smoothing, this.type);
    }
}

