/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler.param;

import io.cdap.mmds.spec.BoolParam;
import io.cdap.mmds.spec.DoubleParam;
import io.cdap.mmds.spec.IntParam;
import io.cdap.mmds.spec.ParamSpec;
import io.cdap.mmds.spec.Parameters;
import io.cdap.mmds.spec.Params;
import io.cdap.mmds.spec.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RegressionParams
implements Parameters {
    protected final IntParam maxIterations;
    protected final BoolParam standardization;
    protected final DoubleParam regularizationParam;
    protected final DoubleParam elasticNetParam;
    protected final DoubleParam tolerance;

    protected RegressionParams(Map<String, String> modelParams) {
        this.maxIterations = new IntParam("maxIterations", "Max Iterations", "max number of iterations", 100, new Range(1, true), modelParams);
        this.standardization = new BoolParam("standardization", "Standardization", "Whether to standardize the training features before fitting the model.", true, modelParams);
        this.regularizationParam = new DoubleParam("regularizationParam", "Regularization Param", "regularization parameter", 0.0, new Range(0.0, true), modelParams);
        this.elasticNetParam = new DoubleParam("elasticNetParam", "Elastic Net Param", "The ElasticNet mixing parameter. For alpha = 0, the penalty is an L2 penalty. For alpha = 1, it is an L1 penalty. For alpha in (0,1), the penalty is a combination of L1 and L2.", 0.0, new Range(0.0, 1.0, true, true), modelParams);
        this.tolerance = new DoubleParam("tolerance", "Tolerance", "Convergence tolerance of iterations. Smaller values will lead to higher accuracy with the cost of more iterations.", 1.0E-6, new Range(0.0, true), modelParams);
    }

    @Override
    public List<ParamSpec> getSpec() {
        ArrayList<ParamSpec> specs = new ArrayList<ParamSpec>();
        return Params.addParams(specs, this.maxIterations, this.standardization, this.regularizationParam, this.elasticNetParam, this.tolerance);
    }

    @Override
    public Map<String, String> toMap() {
        return Params.putParams(new HashMap<String, String>(), this.maxIterations, this.standardization, this.regularizationParam, this.elasticNetParam, this.tolerance);
    }
}

