/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.proto;

import io.cdap.mmds.proto.BadRequestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class CreateModelRequest {
    private final String name;
    private final String description;
    private final String split;
    private final List<String> directives;

    public CreateModelRequest(String name, String description, List<String> directives) {
        this(name, description, directives, null);
    }

    public CreateModelRequest(String name, String description, List<String> directives, @Nullable String split) {
        this.name = name;
        this.description = description;
        this.directives = Collections.unmodifiableList(directives);
        this.split = split;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSplit() {
        return this.split;
    }

    public List<String> getDirectives() {
        return this.directives == null ? new ArrayList() : this.directives;
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new BadRequestException("Must specify a name");
        }
        if (this.split != null && this.directives != null) {
            throw new BadRequestException("Cannot specify both directives and a split.");
        }
    }
}

