/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.splitter;

import io.cdap.mmds.stats.CategoricalHisto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.sql.Row;
import scala.Tuple2;

public class ToCatHisto
implements PairFlatMapFunction<Row, String, CategoricalHisto> {
    private final List<String> columns;

    public ToCatHisto(List<String> columns) {
        this.columns = new ArrayList<String>(columns);
    }

    public Iterator<Tuple2<String, CategoricalHisto>> call(Row row) throws Exception {
        ArrayList<Tuple2> histograms = new ArrayList<Tuple2>();
        for (String column : this.columns) {
            HashMap<String, Long> counts = new HashMap<String, Long>();
            String val = (String)row.getAs(column);
            long nullCount = 1L;
            long emptyCount = 0L;
            if (val != null) {
                counts.put(val, 1L);
                nullCount = 0L;
                if (val.isEmpty()) {
                    emptyCount = 1L;
                }
            }
            CategoricalHisto histo = new CategoricalHisto(1L, nullCount, emptyCount, counts);
            histograms.add(new Tuple2((Object)column, (Object)histo));
        }
        return histograms.iterator();
    }
}

