/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.stats;

import io.cdap.mmds.stats.Histogram;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CategoricalHisto
extends Histogram<CategoricalHisto>
implements Serializable {
    private static final long serialVersionUID = 5788076293831975440L;
    private final Map<String, Long> counts;
    private long emptyCount;

    public CategoricalHisto() {
        this(0L, 0L, 0L, new HashMap<String, Long>());
    }

    public CategoricalHisto(long totalCount, long nullCount, long emptyCount, Map<String, Long> counts) {
        super(totalCount, nullCount);
        this.counts = new HashMap<String, Long>(counts);
        this.emptyCount = emptyCount;
    }

    public long getEmptyCount() {
        return this.emptyCount;
    }

    public Map<String, Long> getCounts() {
        return this.counts;
    }

    public void update(String val) {
        Long currentVal;
        ++this.totalCount;
        if (val == null) {
            ++this.nullCount;
            return;
        }
        if (val.isEmpty()) {
            ++this.emptyCount;
        }
        if ((currentVal = this.counts.get(val)) == null) {
            this.counts.put(val, 1L);
        } else {
            this.counts.put(val, currentVal + 1L);
        }
    }

    @Override
    public CategoricalHisto merge(CategoricalHisto other) {
        for (Map.Entry<String, Long> entry : other.counts.entrySet()) {
            String key = entry.getKey();
            Long count = entry.getValue();
            Long existing = this.counts.get(key);
            this.counts.put(key, existing == null ? count : count + existing);
        }
        return new CategoricalHisto(this.totalCount + other.totalCount, this.nullCount + other.nullCount, this.emptyCount + other.emptyCount, this.counts);
    }
}

