/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.stats;

import java.io.Serializable;

public class NumericBin
implements Serializable {
    private static final long serialVersionUID = -4458231951109307443L;
    private final double lo;
    private final double hi;
    private final boolean hiInclusive;
    private long count;

    public NumericBin(double lo, double hi, long count, boolean hiInclusive) {
        this.lo = lo;
        this.hi = hi;
        this.count = count;
        this.hiInclusive = hiInclusive;
    }

    public NumericBin merge(NumericBin other) {
        if (this.lo != other.lo || this.hi != other.hi || this.hiInclusive != other.hiInclusive) {
            throw new IllegalArgumentException("Cannot merge histograms with different bins.");
        }
        return new NumericBin(this.lo, this.hi, this.count + other.count, this.hiInclusive);
    }

    public boolean incrementIfInBin(Double val) {
        if (val == null) {
            return false;
        }
        if (val < this.lo) {
            return false;
        }
        if (val == this.hi && this.hiInclusive) {
            ++this.count;
            return true;
        }
        if (val < this.hi) {
            ++this.count;
            return true;
        }
        return false;
    }

    public double getLo() {
        return this.lo;
    }

    public double getHi() {
        return this.hi;
    }

    public long getCount() {
        return this.count;
    }

    public boolean isHiInclusive() {
        return this.hiInclusive;
    }

    public String toString() {
        return "NumericBin{lo=" + this.lo + ", hi=" + this.hi + ", hiInclusive=" + this.hiInclusive + ", count=" + this.count + '}';
    }
}

