package io.ciogram.storage.inmemory

import io.ciogram.storage.core.Storage
import java.util.concurrent.ConcurrentHashMap

public actual class InMemoryStorage : Storage {
    private val storage = ConcurrentHashMap<String, String>()

    override suspend fun get(key: String): String? {
        return storage[key]
    }

    override suspend fun getAll(keys: List<String>): List<String> {
        return keys.mapNotNull(storage::get)
    }

    override suspend fun put(key: String, value: String) {
        storage[key] = value
    }

    override suspend fun putAll(pairs: Map<String, String>) {
        storage.putAll(pairs)
    }

    override suspend fun remove(key: String) {
        storage.remove(key)
    }

    override suspend fun removeAll(keys: List<String>) {
        keys.forEach(storage::remove)
    }

    override fun close() {
        //
    }
}