/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.accurest.maven;

import io.codearte.accurest.config.AccurestConfigProperties;
import io.codearte.accurest.wiremock.DslToWireMockClientConverter;
import io.codearte.accurest.wiremock.RecursiveFilesConverter;
import io.codearte.accurest.wiremock.SingleFileConverter;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="convert", requiresProject=false)
public class ConvertMojo
extends AbstractMojo {
    @Parameter(property="contractsDir", defaultValue="${basedir}")
    private File contractsDir;
    @Parameter(property="mappingsDir", defaultValue="${basedir}")
    private File mappingsDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AccurestConfigProperties config = new AccurestConfigProperties();
        config.setContractsDslDir(this.contractsDir);
        config.setStubsOutputDir(this.mappingsDir);
        this.getLog().info((CharSequence)"Converting from accurest contracts written in GroovyDSL to WireMock stubs mappings");
        this.getLog().info((CharSequence)String.format("     Accurest contracts directory: %s", config.getContractsDslDir().getAbsolutePath()));
        this.getLog().info((CharSequence)String.format("WireMock stubs mappings directory: %s", config.getStubsOutputDir().getAbsolutePath()));
        RecursiveFilesConverter converter = new RecursiveFilesConverter((SingleFileConverter)new DslToWireMockClientConverter(), config);
        converter.processFiles();
    }
}

