/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.accurest.maven;

import io.codearte.accurest.config.AccurestConfigProperties;
import io.codearte.accurest.wiremock.DslToWireMockClientConverter;
import io.codearte.accurest.wiremock.RecursiveFilesConverter;
import io.codearte.accurest.wiremock.SingleFileConverter;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generateStubs", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class GenerateStubsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File projectBuildDirectory;
    @Parameter(defaultValue="/src/test/accurest")
    private String contractsDir;
    @Parameter(defaultValue="mappings")
    private String mappingsDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AccurestConfigProperties config = new AccurestConfigProperties();
        config.setContractsDslDir(new File(this.baseDir, this.contractsDir));
        config.setStubsOutputDir(new File(this.projectBuildDirectory, this.mappingsDir));
        this.getLog().info((CharSequence)"Accurest Plugin: Invoking GroovyDSL to WireMock client stubs conversion");
        this.getLog().info((CharSequence)String.format("From '%s' to '%s'", config.getContractsDslDir(), config.getStubsOutputDir()));
        RecursiveFilesConverter converter = new RecursiveFilesConverter((SingleFileConverter)new DslToWireMockClientConverter(), config);
        converter.processFiles();
    }
}

