/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.accurest.maven;

import io.codearte.accurest.AccurestException;
import io.codearte.accurest.TestGenerator;
import io.codearte.accurest.config.AccurestConfigProperties;
import io.codearte.accurest.config.TestFramework;
import io.codearte.accurest.config.TestMode;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generateTests", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class GenerateTestsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File projectBuildDirectory;
    @Parameter(defaultValue="/src/test/accurest")
    private String contractsDir;
    @Parameter(defaultValue="/generated-test-sources/accurest")
    private String generatedTestSourcesDir;
    @Parameter(defaultValue="io.codearte.accurest.tests")
    private String basePackageForTests;
    @Parameter
    private String baseClassForTests;
    @Parameter(defaultValue="MOCKMVC")
    private TestMode testMode;
    @Parameter(defaultValue="JUNIT")
    private TestFramework testFramework;
    @Parameter
    private String ruleClassForTests;
    @Parameter
    private String nameSuffixForTests;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Generating server tests source code for Accurest contract verification");
        AccurestConfigProperties config = new AccurestConfigProperties();
        config.setContractsDslDir(new File(this.baseDir, this.contractsDir));
        config.setGeneratedTestSourcesDir(new File(this.projectBuildDirectory, this.generatedTestSourcesDir));
        config.setTargetFramework(this.testFramework);
        config.setTestMode(this.testMode);
        config.setBasePackageForTests(this.basePackageForTests);
        config.setBaseClassForTests(this.baseClassForTests);
        config.setRuleClassForTests(this.ruleClassForTests);
        config.setNameSuffixForTests(this.nameSuffixForTests);
        this.getLog().info((CharSequence)String.format("Using %s as test source directory", config.getGeneratedTestSourcesDir()));
        this.getLog().info((CharSequence)String.format("Using %s as base class for test classes", config.getBaseClassForTests()));
        try {
            TestGenerator generator = new TestGenerator(config);
            int generatedClasses = generator.generate();
            this.getLog().info((CharSequence)String.format("Generated %s test classes.", generatedClasses));
        }
        catch (AccurestException e) {
            throw new MojoExecutionException(String.format("Accurest Plugin exception: %s", e.getMessage()), (Exception)((Object)e));
        }
    }
}

