#!/usr/bin/env bash
#
# Copyright 2022 Confluent Inc.
#
set -o errexit \
    -o verbose

namespace=${1}

echo "===> Adding logging json layout to CLASSPATH ... "
export CLASSPATH=/usr/share/java/cc-base/log4j-json-layout-${CC_BASE_VERSION}.jar

echo "===> Adding kafka log4j config ... "
cp /mnt/config/shared/log4j.properties /
if [ -n "${namespace}" ]; then
  echo -e "\nlog4j.appender.jsonlog.layout.fields=app:kafka-restore,clusterId:${namespace},server:0" >> /log4j.properties
  echo -e "\nlog4j.appender.stdout.layout.fields=app:kafka-restore,clusterId:${namespace},server:0" >> /log4j.properties
fi
export KAFKA_LOG4J_OPTS="-Dlog4j.configuration=file:/log4j.properties"

echo "===> Running restore ... "
exec /opt/confluent/bin/kafka-run-class.sh kafka.restore.Restore --partition-file /mnt/restore/partitions.yaml --clusterid "${namespace}"
