/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.ResponseContainer;
import io.confluent.rest.RollHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class RollHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void testStatusReport() throws IOException {
        MockBrokerShutdownHandle handle = new MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        rollHandler.handle("/status", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assert.assertEquals((long)handle.brokerId, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerId);
        Assert.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assert.assertEquals((long)handle.underReplicatedPartitions, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).underReplicatedPartitions);
        Assert.assertEquals((Object)handle.controllerId, (Object)((RollHandler.StatusResponse)statusResponse.data.attributes).controllerId);
    }

    @Test
    public void testStatusReportNoController() throws IOException {
        MockBrokerShutdownHandle handle = new MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = null;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        rollHandler.handle("/status", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assert.assertEquals((long)handle.brokerId, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerId);
        Assert.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assert.assertEquals((long)handle.underReplicatedPartitions, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).underReplicatedPartitions);
        Assert.assertEquals((Object)handle.controllerId, (Object)((RollHandler.StatusResponse)statusResponse.data.attributes).controllerId);
    }

    @Test
    public void testBeginShutdown() throws IOException {
        MockBrokerShutdownHandle handle = new MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RollHandler.ShutdownRequest shutdownRequest = new RollHandler.ShutdownRequest(handle.brokerId, handle.brokerEpoch);
        byte[] shutdownRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)shutdownRequest);
        MockServletInputStream inputStream = new MockServletInputStream(new ByteArrayInputStream(shutdownRequestBytes));
        BDDMockito.given((Object)response.getWriter()).willReturn((Object)new PrintWriter(new ByteArrayOutputStream()));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        rollHandler.handle("/shutdown", null, request, response);
        Assert.assertTrue((boolean)handle.shutdownTriggered);
    }

    @Test
    public void testBeginShutdownIncorrectEpoch() throws IOException {
        MockBrokerShutdownHandle handle = new MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        RollHandler.ShutdownRequest shutdownRequest = new RollHandler.ShutdownRequest(handle.brokerId, handle.brokerEpoch - 1L);
        byte[] shutdownRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)shutdownRequest);
        MockServletInputStream inputStream = new MockServletInputStream(new ByteArrayInputStream(shutdownRequestBytes));
        BDDMockito.given((Object)response.getWriter()).willReturn((Object)new PrintWriter(new ByteArrayOutputStream()));
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        rollHandler.handle("/shutdown", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assert.assertEquals((String)"expected no data in response", (Object)statusResponse.data, null);
        Assert.assertEquals((String)"expected one error struct", (long)statusResponse.errors.size(), (long)1L);
        Assert.assertEquals((long)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).status, (long)500L);
        Assert.assertEquals((long)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).id, (long)0L);
    }

    private static class MockServletInputStream
    extends ServletInputStream {
        public final ByteArrayInputStream bais;

        MockServletInputStream(ByteArrayInputStream bais) {
            this.bais = bais;
        }

        public boolean isFinished() {
            return this.bais.available() > 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() {
            return this.bais.read();
        }
    }

    private static class MockServletOutputStream
    extends ServletOutputStream {
        public final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        MockServletOutputStream() {
        }

        public void write(int i) {
            this.baos.write(i);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    private static class MockBrokerShutdownHandle
    implements BeginShutdownBrokerHandle {
        long brokerId;
        long brokerEpoch;
        Integer controllerId;
        long underReplicatedPartitions;
        boolean shutdownTriggered = false;

        private MockBrokerShutdownHandle() {
        }

        public long brokerId() {
            return this.brokerId;
        }

        public long brokerEpoch() {
            return this.brokerEpoch;
        }

        public Integer controllerId() {
            return this.controllerId;
        }

        public long underReplicatedPartitions() {
            return this.underReplicatedPartitions;
        }

        public void beginShutdown(long brokerEpoch) throws StaleBrokerEpochException {
            if (this.brokerEpoch != brokerEpoch) {
                throw new StaleBrokerEpochException("");
            }
            this.shutdownTriggered = true;
        }
    }
}

