/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.KafkaRestorePartitionHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Optional;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.apache.kafka.common.errors.StaleBrokerEpochException;

public class MockUtil {

    public static class MockKafkaRestorePartitionHandle
    implements KafkaRestorePartitionHandle {
        int leaderReplica;
        long tierPartitionStatus;

        public int leaderReplica(String topic, int partition) {
            return this.leaderReplica;
        }

        public long tierPartitionStatus(String topic, int partition) {
            return this.tierPartitionStatus;
        }

        public Optional<File> ftpsFile(String topic, int partition) {
            return Optional.empty();
        }

        public int setFenceTierTopicPartition(String topic, int partition) {
            return 1;
        }

        public int setForceRestoreTierPartition(String topic, int partition, long startOffset, long endOffset, String contentHash) {
            return 1;
        }

        public int setUnfreezeLogStartOffset(String topic, int partition) {
            return 1;
        }

        public int validateLogRange(String topic, int partition, long startOffset, long endOffset) {
            return 1;
        }
    }

    public static class MockServletInputStream
    extends ServletInputStream {
        public final ByteArrayInputStream bais;

        MockServletInputStream(ByteArrayInputStream bais) {
            this.bais = bais;
        }

        public boolean isFinished() {
            return this.bais.available() > 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() {
            return this.bais.read();
        }
    }

    public static class MockServletOutputStream
    extends ServletOutputStream {
        public final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        MockServletOutputStream() {
        }

        public void write(int i) {
            this.baos.write(i);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    public static class MockBrokerShutdownHandle
    implements BeginShutdownBrokerHandle {
        long brokerId;
        long brokerEpoch;
        Integer controllerId;
        long underReplicatedPartitions;
        boolean shutdownTriggered = false;

        public long brokerId() {
            return this.brokerId;
        }

        public long brokerEpoch() {
            return this.brokerEpoch;
        }

        public Integer controllerId() {
            return this.controllerId;
        }

        public long underReplicatedPartitions() {
            return this.underReplicatedPartitions;
        }

        public void beginShutdown(long brokerEpoch) throws StaleBrokerEpochException {
            if (this.brokerEpoch != brokerEpoch) {
                throw new StaleBrokerEpochException("");
            }
            this.shutdownTriggered = true;
        }
    }
}

