/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.KafkaRestorePartitionHandle;
import io.confluent.rest.RestoreHandler;
import io.confluent.rest.RollHandler;
import java.util.Objects;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalRestServer {
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    private final BeginShutdownBrokerHandle beginShutdownBrokerHandle;
    private final KafkaRestorePartitionHandle kafkaRestorePartitionHandle;
    private final int port;
    private Server server;

    public InternalRestServer(int port, BeginShutdownBrokerHandle beginShutdownBrokerHandle, KafkaRestorePartitionHandle kafkaRestorePartitionHandle) {
        log.isDebugEnabled();
        this.port = port;
        this.beginShutdownBrokerHandle = Objects.requireNonNull(beginShutdownBrokerHandle, "null beginShutdownBrokerHandle");
        this.kafkaRestorePartitionHandle = Objects.requireNonNull(kafkaRestorePartitionHandle, "null kafkaRestorePartitionHandle");
    }

    public synchronized void start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException("Server is already running.");
        }
        log.info("Binding to port " + this.port);
        this.server = new Server(this.port);
        ContextHandler rollContext = new ContextHandler("/v1/roll");
        rollContext.setContextPath("/v1/roll");
        rollContext.setHandler((Handler)new RollHandler(this.beginShutdownBrokerHandle));
        ContextHandler restoreContext = new ContextHandler("/v1/restore");
        restoreContext.setContextPath("/v1/restore");
        restoreContext.setHandler((Handler)new RestoreHandler(this.kafkaRestorePartitionHandle));
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{rollContext, restoreContext, new DefaultHandler()});
        this.server.setHandler((Handler)contexts);
        this.server.start();
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running.");
        }
        log.info("Stopping");
        this.server.stop();
        this.server.join();
        this.server = null;
    }
}

