/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.KafkaRestorePartitionHandle;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import io.confluent.rest.RestoreHandler;
import io.confluent.rest.RollHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class RestoreHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void testFtpsFileDownloadNotFound() throws IOException {
        KafkaRestorePartitionHandle handle = (KafkaRestorePartitionHandle)Mockito.mock(KafkaRestorePartitionHandle.class);
        RestoreHandler restoreHandler = new RestoreHandler(handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RestoreHandler.FtpsDownloadRequest ftpsDownloadRequest = new RestoreHandler.FtpsDownloadRequest("test", 0);
        byte[] ftpsDownloadRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)ftpsDownloadRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(ftpsDownloadRequestBytes));
        BDDMockito.given((Object)response.getWriter()).willReturn((Object)new PrintWriter(new ByteArrayOutputStream()));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        restoreHandler.handle("/ftps", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assertions.assertNull((Object)statusResponse.data, (String)"expected no data in response");
        Assertions.assertEquals((int)statusResponse.errors.size(), (int)1, (String)"expected one error struct");
        Assertions.assertEquals((int)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).status, (int)500);
        Assertions.assertEquals((int)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).id, (int)0);
    }

    @Test
    public void testFtpsFileDownload() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5000; ++i) {
            sb.append("a");
        }
        String inputFtpsContent = sb.toString();
        File ftpsFile = File.createTempFile("ftps-temp", null);
        FileOutputStream ftpsOutputStream = new FileOutputStream(ftpsFile.getAbsolutePath());
        byte[] strToBytes = inputFtpsContent.getBytes();
        ftpsOutputStream.write(strToBytes);
        ftpsOutputStream.close();
        ftpsFile.deleteOnExit();
        KafkaRestorePartitionHandle handle = (KafkaRestorePartitionHandle)Mockito.mock(KafkaRestorePartitionHandle.class);
        Mockito.when((Object)handle.ftpsFile(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(ftpsFile));
        RestoreHandler restoreHandler = new RestoreHandler(handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RestoreHandler.FtpsDownloadRequest ftpsDownloadRequest = new RestoreHandler.FtpsDownloadRequest("test", 0);
        byte[] ftpsDownloadRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)ftpsDownloadRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(ftpsDownloadRequestBytes));
        BDDMockito.given((Object)response.getWriter()).willReturn((Object)new PrintWriter(new ByteArrayOutputStream()));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        restoreHandler.handle("/ftps", null, request, response);
        byte[] outputFtpsContent = outputStream.baos.toByteArray();
        Assertions.assertEquals((Object)inputFtpsContent, (Object)new String(outputFtpsContent));
    }

    @Test
    public void testGetTierState() throws IOException {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        handle.leaderReplica = 1;
        handle.tierPartitionStatus = 1L;
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RestoreHandler.TierPartitionStatusRequest tierPartitionStateRequest = new RestoreHandler.TierPartitionStatusRequest("test", 0);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionStateRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        restoreHandler.handle("/tier-state", null, request, response);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.TierPartitionStateResponse>>(){});
        Assertions.assertEquals((long)handle.leaderReplica, (long)((RestoreHandler.TierPartitionStateResponse)stateResponse.data.attributes).tierPartitionState);
    }

    @Test
    public void testGetLeaderReplica() throws IOException {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        handle.leaderReplica = 1;
        handle.tierPartitionStatus = 1L;
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RestoreHandler.LeaderReplicaRequest tierPartitionStateRequest = new RestoreHandler.LeaderReplicaRequest("test", 0);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionStateRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        restoreHandler.handle("/leader-replica", null, request, response);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.LeaderReplicaResponse>>(){});
        Assertions.assertEquals((int)handle.leaderReplica, (int)((RestoreHandler.LeaderReplicaResponse)stateResponse.data.attributes).broker);
    }

    @Test
    public void testSetFenceTierPartitionState() throws IOException {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RestoreHandler.TierPartitionFenceRequest tierPartitionFenceRequest = new RestoreHandler.TierPartitionFenceRequest("test", 0);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionFenceRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        restoreHandler.handle("/fence", null, request, response);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.TierPartitionStateSetResponse>>(){});
        Assertions.assertEquals((int)1, (int)((RestoreHandler.TierPartitionStateSetResponse)stateResponse.data.attributes).response);
    }

    @Test
    public void testUnfreezeTierPartitionState() throws IOException {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RestoreHandler.TierPartitionUnfreezeRequest tierPartitionUnfreezeRequest = new RestoreHandler.TierPartitionUnfreezeRequest("test", 0);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionUnfreezeRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        restoreHandler.handle("/unfreeze", null, request, response);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.TierPartitionStateSetResponse>>(){});
        Assertions.assertEquals((int)1, (int)((RestoreHandler.TierPartitionStateSetResponse)stateResponse.data.attributes).response);
    }

    @Test
    public void testRestoreTierPartitionState() throws IOException {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RestoreHandler.TierPartitionRestoreRequest tierPartitionRestoreRequest = new RestoreHandler.TierPartitionRestoreRequest("test", 0, 0L, 100L, "testHash");
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionRestoreRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        restoreHandler.handle("/restore", null, request, response);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.TierPartitionStateSetResponse>>(){});
        Assertions.assertEquals((int)1, (int)((RestoreHandler.TierPartitionStateSetResponse)stateResponse.data.attributes).response);
    }

    @Test
    public void validateLogRangeTest() throws IOException {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RestoreHandler.ValidateLogRangeRequest validateLogRangeRequest = new RestoreHandler.ValidateLogRangeRequest("test", 0, 0L, 100L);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)validateLogRangeRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        restoreHandler.handle("/validate-log-range", null, request, response);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.TierPartitionStateSetResponse>>(){});
        Assertions.assertEquals((int)1, (int)((RestoreHandler.TierPartitionStateSetResponse)stateResponse.data.attributes).response);
    }
}

