/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import io.confluent.rest.RollHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class RollHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void testStatusReport() throws IOException {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        rollHandler.handle("/status", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assertions.assertEquals((long)handle.brokerId, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerId);
        Assertions.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assertions.assertEquals((long)handle.underReplicatedPartitions, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).underReplicatedPartitions);
        Assertions.assertEquals((Integer)handle.controllerId, (Integer)((RollHandler.StatusResponse)statusResponse.data.attributes).controllerId);
    }

    @Test
    public void testStatusReportNoController() throws IOException {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = null;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        rollHandler.handle("/status", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assertions.assertEquals((long)handle.brokerId, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerId);
        Assertions.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assertions.assertEquals((long)handle.underReplicatedPartitions, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).underReplicatedPartitions);
        Assertions.assertEquals((Integer)handle.controllerId, (Integer)((RollHandler.StatusResponse)statusResponse.data.attributes).controllerId);
    }

    @Test
    public void testBeginShutdown() throws IOException {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RollHandler.ShutdownRequest shutdownRequest = new RollHandler.ShutdownRequest(handle.brokerId, handle.brokerEpoch);
        byte[] shutdownRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)shutdownRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(shutdownRequestBytes));
        BDDMockito.given((Object)response.getWriter()).willReturn((Object)new PrintWriter(new ByteArrayOutputStream()));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        rollHandler.handle("/shutdown", null, request, response);
        Assertions.assertTrue((boolean)handle.shutdownTriggered);
    }

    @Test
    public void testBeginShutdownIncorrectEpoch() throws IOException {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        RollHandler.ShutdownRequest shutdownRequest = new RollHandler.ShutdownRequest(handle.brokerId, handle.brokerEpoch - 1L);
        byte[] shutdownRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)shutdownRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(shutdownRequestBytes));
        BDDMockito.given((Object)response.getWriter()).willReturn((Object)new PrintWriter(new ByteArrayOutputStream()));
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        rollHandler.handle("/shutdown", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assertions.assertNull((Object)statusResponse.data, (String)"expected no data in response");
        Assertions.assertEquals((int)statusResponse.errors.size(), (int)1, (String)"expected one error struct");
        Assertions.assertEquals((int)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).status, (int)500);
        Assertions.assertEquals((int)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).id, (int)0);
    }
}

