/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.AuditJobHandle;
import io.confluent.rest.AuditJobHandler;
import io.confluent.rest.AuditJobRestApiResponseStatus;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class AuditJobHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Map<String, Set<Integer>> TOPIC_PARTITIONS_MAP = new HashMap<String, Set<Integer>>();
    private static final Map<String, String> AUDIT_JOB_STATUS_SUMMARY = new HashMap<String, String>();
    private static final Map<String, String> AUDIT_JOB_STATUS_DETAIL = new HashMap<String, String>();

    @Test
    public void testStartAuditJob() throws IOException, ServletException {
        this.populateTopicPartitionsMap();
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("jobId", String.valueOf(1));
        responseMap.put("newJob", String.valueOf(true));
        responseMap.put("status", String.valueOf(AuditJobRestApiResponseStatus.success));
        AuditJobHandle handle = (AuditJobHandle)Mockito.mock(AuditJobHandle.class);
        Mockito.when((Object)handle.mayBeStartAuditJob(ArgumentMatchers.anyMap(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn(responseMap);
        AuditJobHandler auditJobHandler = new AuditJobHandler(handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        AuditJobHandler.StartAuditJobRequest startAuditJobRequest = new AuditJobHandler.StartAuditJobRequest(TOPIC_PARTITIONS_MAP, 0, false, false);
        byte[] startAuditJobRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)startAuditJobRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(startAuditJobRequestBytes));
        BDDMockito.given((Object)response.getWriter()).willReturn((Object)new PrintWriter(new ByteArrayOutputStream()));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        auditJobHandler.handle("/start-audit-job", null, request, response);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<AuditJobHandler.StartAuditJobResponse>>(){});
        Assertions.assertEquals((int)1, (Integer)((AuditJobHandler.StartAuditJobResponse)stateResponse.data.attributes).jobId);
    }

    @Test
    public void testGetAuditJobStatus() throws IOException, ServletException {
        this.populateTopicPartitionsMap();
        this.populateGetAuditJobStatusResponseSummaryMap();
        AuditJobHandle handle = (AuditJobHandle)Mockito.mock(AuditJobHandle.class);
        Mockito.when((Object)handle.mayBeGetAuditJobStatusSummary()).thenReturn(AUDIT_JOB_STATUS_SUMMARY);
        AuditJobHandler auditJobHandler = new AuditJobHandler(handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        AuditJobHandler.GetAuditJobStatusRequest getAuditJobStatusRequest = new AuditJobHandler.GetAuditJobStatusRequest(false);
        byte[] getAuditJobStatusRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)getAuditJobStatusRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(getAuditJobStatusRequestBytes));
        BDDMockito.given((Object)response.getWriter()).willReturn((Object)new PrintWriter(new ByteArrayOutputStream()));
        BDDMockito.given((Object)request.getInputStream()).willReturn((Object)inputStream);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        auditJobHandler.handle("/get-audit-job-status", null, request, response);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<AuditJobHandler.GetAuditJobStatusResponseSummary>>(){});
        Assertions.assertEquals((int)100, (Integer)((AuditJobHandler.GetAuditJobStatusResponseSummary)stateResponse.data.attributes).jobId);
    }

    private void populateTopicPartitionsMap() {
        TOPIC_PARTITIONS_MAP.put("topicA", new HashSet());
        TOPIC_PARTITIONS_MAP.get("topicA").add(0);
        TOPIC_PARTITIONS_MAP.get("topicA").add(1);
        TOPIC_PARTITIONS_MAP.get("topicA").add(2);
        TOPIC_PARTITIONS_MAP.get("topicA").add(3);
    }

    private void populateGetAuditJobStatusResponseSummaryMap() {
        AUDIT_JOB_STATUS_SUMMARY.put("jobId", "100");
        AUDIT_JOB_STATUS_SUMMARY.put("topicPartitionsRequested", "100");
        AUDIT_JOB_STATUS_SUMMARY.put("status", "InProgress");
        AUDIT_JOB_STATUS_SUMMARY.put("topicPartitionScannedSuccess", "100");
        AUDIT_JOB_STATUS_SUMMARY.put("topicPartitionSkipped", "0");
        AUDIT_JOB_STATUS_SUMMARY.put("topicPartitionScanned", "100");
        AUDIT_JOB_STATUS_SUMMARY.put("totalTierCompactedPartitionsRequested", "0");
        AUDIT_JOB_STATUS_SUMMARY.put("totalOffsetCountAcrossPartitions", "100000");
        AUDIT_JOB_STATUS_SUMMARY.put("totalGapCountAcrossPartitions", "0");
        AUDIT_JOB_STATUS_SUMMARY.put("totalTimeTakeInMillis", "20000");
        AUDIT_JOB_STATUS_SUMMARY.put("jobType", "OnDemand");
        AUDIT_JOB_STATUS_SUMMARY.put("startTime", "123456");
        AUDIT_JOB_STATUS_SUMMARY.put("completionTime", "123457");
    }

    private void populateGetAuditJobStatusDetailMap() {
        AUDIT_JOB_STATUS_DETAIL.put("detail", "detail");
        AUDIT_JOB_STATUS_DETAIL.put("jobId", "100");
    }
}

