/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.CheckReadyControllerHandle;
import io.confluent.rest.CheckReadyControllerStatus;
import io.confluent.rest.ControllerReadyHandler;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class CheckReadyControllerHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void testReadinessStatusReport() throws IOException {
        MockUtil.MockCheckReadyControllerHandle handle = new MockUtil.MockCheckReadyControllerHandle();
        handle.ready = true;
        handle.reason = "";
        ControllerReadyHandler readyHandler = new ControllerReadyHandler((CheckReadyControllerHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        readyHandler.handle("/status", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<CheckReadyControllerStatus>>(){});
        CheckReadyControllerStatus expected = handle.generateReadinessStatus();
        Assertions.assertEquals((Object)expected.ready(), (Object)((CheckReadyControllerStatus)statusResponse.data.attributes).ready());
        Assertions.assertEquals((Object)expected.reason(), (Object)((CheckReadyControllerStatus)statusResponse.data.attributes).reason());
    }

    @Test
    public void testNotRollableStatusReport() throws IOException {
        MockUtil.MockCheckReadyControllerHandle handle = new MockUtil.MockCheckReadyControllerHandle();
        handle.ready = false;
        handle.reason = "The reason why";
        ControllerReadyHandler readyHandler = new ControllerReadyHandler((CheckReadyControllerHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        readyHandler.handle("/status", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<CheckReadyControllerStatus>>(){});
        CheckReadyControllerStatus expected = handle.generateReadinessStatus();
        Assertions.assertEquals((Object)expected.ready(), (Object)((CheckReadyControllerStatus)statusResponse.data.attributes).ready());
        Assertions.assertEquals((Object)expected.reason(), (Object)((CheckReadyControllerStatus)statusResponse.data.attributes).reason());
    }
}

