/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.BeginShutdownControllerStatus;
import io.confluent.rest.ControllerRollHandler;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class ControllerRollHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void testRollableStatusReport() throws IOException {
        MockUtil.MockControllerShutdownHandle handle = new MockUtil.MockControllerShutdownHandle();
        handle.rollable = true;
        handle.reason = "";
        ControllerRollHandler rollHandler = new ControllerRollHandler((BeginShutdownControllerHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        rollHandler.handle("/status", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<BeginShutdownControllerStatus>>(){});
        BeginShutdownControllerStatus expected = handle.generateRollableStatus();
        Assertions.assertEquals((Object)expected.rollable(), (Object)((BeginShutdownControllerStatus)statusResponse.data.attributes).rollable());
        Assertions.assertEquals((Object)expected.reason(), (Object)((BeginShutdownControllerStatus)statusResponse.data.attributes).reason());
    }

    @Test
    public void testNotRollableStatusReport() throws IOException {
        MockUtil.MockControllerShutdownHandle handle = new MockUtil.MockControllerShutdownHandle();
        handle.rollable = false;
        handle.reason = "The reason why";
        ControllerRollHandler rollHandler = new ControllerRollHandler((BeginShutdownControllerHandle)handle);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        BDDMockito.given((Object)response.getOutputStream()).willReturn((Object)outputStream);
        rollHandler.handle("/status", null, request, response);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<BeginShutdownControllerStatus>>(){});
        BeginShutdownControllerStatus expected = handle.generateRollableStatus();
        Assertions.assertEquals((Object)expected.rollable(), (Object)((BeginShutdownControllerStatus)statusResponse.data.attributes).rollable());
        Assertions.assertEquals((Object)expected.reason(), (Object)((BeginShutdownControllerStatus)statusResponse.data.attributes).reason());
    }
}

