/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations;

import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.util.MigrationsUtil;
import io.confluent.ksql.tools.migrations.util.ServerVersionUtil;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public final class MigrationConfig
extends AbstractConfig {
    public static final String KSQL_SERVER_URL = "ksql.server.url";
    public static final String KSQL_BASIC_AUTH_USERNAME = "ksql.auth.basic.username";
    public static final String KSQL_BASIC_AUTH_PASSWORD = "ksql.auth.basic.password";
    public static final String SSL_TRUSTSTORE_LOCATION = "ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD = "ssl.truststore.password";
    public static final String SSL_KEYSTORE_LOCATION = "ssl.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
    public static final String SSL_KEY_PASSWORD = "ssl.key.password";
    public static final String SSL_KEY_ALIAS = "ssl.key.alias";
    public static final String SSL_ALPN = "ssl.alpn";
    public static final String SSL_VERIFY_HOST = "ssl.verify.host";
    public static final String KSQL_MIGRATIONS_STREAM_NAME = "ksql.migrations.stream.name";
    public static final String KSQL_MIGRATIONS_STREAM_NAME_DEFAULT = "MIGRATION_EVENTS";
    public static final String KSQL_MIGRATIONS_TABLE_NAME = "ksql.migrations.table.name";
    public static final String KSQL_MIGRATIONS_TABLE_NAME_DEFAULT = "MIGRATION_SCHEMA_VERSIONS";
    public static final String KSQL_MIGRATIONS_STREAM_TOPIC_NAME = "ksql.migrations.stream.topic.name";
    public static final String KSQL_MIGRATIONS_TABLE_TOPIC_NAME = "ksql.migrations.table.topic.name";
    public static final String KSQL_MIGRATIONS_TOPIC_REPLICAS = "ksql.migrations.topic.replicas";
    public static final int KSQL_MIGRATIONS_TOPIC_REPLICAS_DEFAULT = 1;
    public static final MigrationConfig DEFAULT_CONFIG = new MigrationConfig(Collections.emptyMap(), "ksql-service-id");

    public static MigrationConfig load(String configFile) {
        Map configsMap = PropertiesUtil.loadProperties((File)new File(configFile));
        return new MigrationConfig(configsMap, MigrationConfig.getServiceId(configsMap));
    }

    private MigrationConfig(Map<String, String> configs, String id) {
        super(new ConfigDef().define(KSQL_SERVER_URL, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The URL for the KSQL server").define(KSQL_BASIC_AUTH_USERNAME, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The username for the KSQL server").define(KSQL_BASIC_AUTH_PASSWORD, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The password for the KSQL server").define(SSL_TRUSTSTORE_LOCATION, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The trust store path").define(SSL_TRUSTSTORE_PASSWORD, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The trust store password").define(SSL_KEYSTORE_LOCATION, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The key store path").define(SSL_KEYSTORE_PASSWORD, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The key store password").define(SSL_KEY_PASSWORD, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The key password").define(SSL_KEY_ALIAS, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The key alias").define(SSL_ALPN, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether ALPN should be used. It defaults to false.").define(SSL_VERIFY_HOST, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Whether hostname verification is enabled. It defaults to true.").define(KSQL_MIGRATIONS_STREAM_NAME, ConfigDef.Type.STRING, (Object)KSQL_MIGRATIONS_STREAM_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, "The name of the migration stream. It defaults to MIGRATION_EVENTS").define(KSQL_MIGRATIONS_TABLE_NAME, ConfigDef.Type.STRING, (Object)KSQL_MIGRATIONS_TABLE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, "The name of the migration table. It defaults to MIGRATION_SCHEMA_VERSIONS").define(KSQL_MIGRATIONS_STREAM_TOPIC_NAME, ConfigDef.Type.STRING, (Object)(id + "ksql_" + configs.getOrDefault(KSQL_MIGRATIONS_STREAM_NAME, KSQL_MIGRATIONS_STREAM_NAME_DEFAULT)), ConfigDef.Importance.MEDIUM, "The name of the migration stream topic. It defaults to '<ksql_service_id>ksql_<migrations_stream_name>'").define(KSQL_MIGRATIONS_TABLE_TOPIC_NAME, ConfigDef.Type.STRING, (Object)(id + "ksql_" + configs.getOrDefault(KSQL_MIGRATIONS_TABLE_NAME, KSQL_MIGRATIONS_TABLE_NAME_DEFAULT)), ConfigDef.Importance.MEDIUM, "The name of the migration table topic. It defaults to '<ksql_service_id>ksql_<migrations_table_name>'").define(KSQL_MIGRATIONS_TOPIC_REPLICAS, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, "The number of replicas for the migration stream topic. It defaults to 1"), configs, false);
    }

    private static String getServiceId(Map<String, String> configs) throws MigrationException {
        String ksqlServerUrl = configs.get(KSQL_SERVER_URL);
        if (ksqlServerUrl == null) {
            throw new MigrationException("Missing required property: ksql.server.url");
        }
        Client ksqlClient = MigrationsUtil.getKsqlClient(ksqlServerUrl, configs.get(KSQL_BASIC_AUTH_USERNAME), configs.get(KSQL_BASIC_AUTH_PASSWORD), configs.get(SSL_TRUSTSTORE_LOCATION), configs.get(SSL_TRUSTSTORE_PASSWORD), configs.get(SSL_KEYSTORE_LOCATION), configs.get(SSL_KEYSTORE_PASSWORD), configs.get(SSL_KEY_PASSWORD), configs.get(SSL_KEY_ALIAS), configs.getOrDefault(SSL_ALPN, "false").equalsIgnoreCase("true"), configs.getOrDefault(SSL_VERIFY_HOST, "true").equalsIgnoreCase("true"));
        try {
            String serviceId = ServerVersionUtil.getServerInfo(ksqlClient, ksqlServerUrl).getKsqlServiceId();
            ksqlClient.close();
            return serviceId;
        }
        catch (MigrationException e) {
            ksqlClient.close();
            throw e;
        }
    }
}

