/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.commands;

import com.github.rvesse.airline.annotations.Command;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.commands.BaseCommand;
import io.confluent.ksql.tools.migrations.util.MigrationsUtil;
import io.confluent.ksql.tools.migrations.util.ServerVersionUtil;
import io.confluent.ksql.util.KsqlException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="initialize-metadata", description="Initializes the migrations schema metadata (ksqlDB stream and table) on the ksqlDB server.")
public class InitializeMigrationCommand
extends BaseCommand {
    static final String INITIALIZE_COMMAND_NAME = "initialize-metadata";
    private static final Logger LOGGER = LoggerFactory.getLogger(InitializeMigrationCommand.class);

    private String createEventStream(String name, String topic, int replicas) {
        return "CREATE STREAM " + name + " (\n  version_key  STRING KEY,\n  version      STRING,\n  name         STRING,\n  state        STRING,  \n  checksum     STRING,\n  started_on   STRING,\n  completed_on STRING,\n  previous     STRING,\n  error_reason STRING\n) WITH (  \n  KAFKA_TOPIC='" + topic + "',\n  VALUE_FORMAT='JSON',\n  PARTITIONS=1,\n  REPLICAS= " + replicas + " \n);\n";
    }

    private String createVersionTable(String tableName, String streamName, String topic) {
        return "CREATE TABLE " + tableName + "\n  WITH (\n    KAFKA_TOPIC='" + topic + "'\n  )\n  AS SELECT \n    version_key, \n    latest_by_offset(version) as version, \n    latest_by_offset(name) AS name, \n    latest_by_offset(state) AS state,     \n    latest_by_offset(checksum) AS checksum, \n    latest_by_offset(started_on) AS started_on, \n    latest_by_offset(completed_on) AS completed_on, \n    latest_by_offset(previous) AS previous, \n    latest_by_offset(error_reason) AS error_reason \n  FROM " + streamName + " \n  GROUP BY version_key;\n";
    }

    @Override
    protected int command() {
        MigrationConfig config;
        if (!this.validateConfigFilePresent()) {
            return 1;
        }
        try {
            config = MigrationConfig.load(this.getConfigFile());
        }
        catch (MigrationException | KsqlException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        return this.command(config, MigrationsUtil::getKsqlClient);
    }

    @VisibleForTesting
    int command(MigrationConfig config, Function<MigrationConfig, Client> clientSupplier) {
        Client ksqlClient;
        String streamName = config.getString("ksql.migrations.stream.name");
        String tableName = config.getString("ksql.migrations.table.name");
        String eventStreamCommand = this.createEventStream(streamName, config.getString("ksql.migrations.stream.topic.name"), config.getInt("ksql.migrations.topic.replicas"));
        String versionTableCommand = this.createVersionTable(tableName, streamName, config.getString("ksql.migrations.table.topic.name"));
        try {
            ksqlClient = clientSupplier.apply(config);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        LOGGER.info("Initializing migrations metadata");
        if (!(ServerVersionUtil.serverVersionCompatible(ksqlClient, config) && InitializeMigrationCommand.tryCreate(ksqlClient, eventStreamCommand, streamName, true) && InitializeMigrationCommand.tryCreate(ksqlClient, versionTableCommand, tableName, false))) {
            ksqlClient.close();
            return 1;
        }
        LOGGER.info("Migrations metadata initialized successfully");
        ksqlClient.close();
        return 0;
    }

    private static boolean tryCreate(Client client, String command, String name, boolean isStream) {
        String type = isStream ? "stream" : "table";
        try {
            LOGGER.info("Creating " + type + ": " + name);
            client.executeStatement(command).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error(String.format("Failed to create %s %s: %s", type, name, e.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

