/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.commands;

import com.github.rvesse.airline.annotations.Command;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.commands.BaseCommand;
import io.confluent.ksql.tools.migrations.util.MetadataUtil;
import io.confluent.ksql.tools.migrations.util.MigrationFile;
import io.confluent.ksql.tools.migrations.util.MigrationVersionInfo;
import io.confluent.ksql.tools.migrations.util.MigrationVersionInfoFormatter;
import io.confluent.ksql.tools.migrations.util.MigrationsDirectoryUtil;
import io.confluent.ksql.tools.migrations.util.MigrationsUtil;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="info", description="Displays information about the current and available migrations.")
public class MigrationInfoCommand
extends BaseCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationInfoCommand.class);

    @Override
    protected int command() {
        MigrationConfig config;
        if (!this.validateConfigFilePresent()) {
            return 1;
        }
        try {
            config = MigrationConfig.load(this.getConfigFile());
        }
        catch (MigrationException | KsqlException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        return this.command(config, MigrationsUtil::getKsqlClient, MigrationsDirectoryUtil.getMigrationsDirFromConfigFile(this.getConfigFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int command(MigrationConfig config, Function<MigrationConfig, Client> clientSupplier, String migrationsDir) {
        boolean success;
        Client ksqlClient;
        try {
            ksqlClient = clientSupplier.apply(config);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        if (!this.validateMetadataInitialized(ksqlClient, config)) {
            ksqlClient.close();
            return 1;
        }
        try {
            this.printCurrentVersion(config, ksqlClient);
            this.printVersionInfoTable(config, ksqlClient, migrationsDir);
            success = true;
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            success = false;
        }
        finally {
            ksqlClient.close();
        }
        return success ? 0 : 1;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private void printCurrentVersion(MigrationConfig config, Client ksqlClient) {
        String currentVersion = MetadataUtil.getCurrentVersion(config, ksqlClient);
        LOGGER.info("Current migration version: {}", (Object)currentVersion);
    }

    private void printVersionInfoTable(MigrationConfig config, Client ksqlClient, String migrationsDir) {
        List<MigrationFile> allMigrations = MigrationsDirectoryUtil.getAllMigrations(migrationsDir);
        List<Integer> allVersions = allMigrations.stream().map(MigrationFile::getVersion).collect(Collectors.toList());
        if (allMigrations.size() != 0) {
            Map<Integer, Optional<MigrationVersionInfo>> versionInfos = MetadataUtil.getOptionalInfoForVersions(allVersions, config, ksqlClient);
            MigrationInfoCommand.printAsTable(allMigrations, versionInfos);
        } else {
            LOGGER.info("No migrations files found");
        }
    }

    private static void printAsTable(List<MigrationFile> allMigrations, Map<Integer, Optional<MigrationVersionInfo>> versionInfos) {
        MigrationVersionInfoFormatter formatter = new MigrationVersionInfoFormatter();
        for (MigrationFile migration : allMigrations) {
            MigrationVersionInfo versionInfo = versionInfos.get(migration.getVersion()).orElse(MigrationVersionInfo.pendingMigration(migration.getVersion(), migration.getName()));
            formatter.addVersionInfo(versionInfo);
        }
        LOGGER.info(formatter.getFormatted());
    }
}

