/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.commands;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.help.Discussion;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.commands.BaseCommand;
import io.confluent.ksql.tools.migrations.util.MetadataUtil;
import io.confluent.ksql.tools.migrations.util.MigrationVersionInfo;
import io.confluent.ksql.tools.migrations.util.MigrationsDirectoryUtil;
import io.confluent.ksql.tools.migrations.util.MigrationsUtil;
import io.confluent.ksql.util.KsqlException;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="validate", description="Validates applied migrations against local files.")
@Discussion(paragraphs={"This command checks whether the migration files that have been applied are the same as the local migration files with the same version, by computing hashes for the local files and comparing them to the checksums saved with the applied migrations."})
public class ValidateMigrationsCommand
extends BaseCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateMigrationsCommand.class);

    @Override
    protected int command() {
        MigrationConfig config;
        if (!this.validateConfigFilePresent()) {
            return 1;
        }
        try {
            config = MigrationConfig.load(this.getConfigFile());
        }
        catch (MigrationException | KsqlException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        return this.command(config, MigrationsUtil::getKsqlClient, MigrationsDirectoryUtil.getMigrationsDirFromConfigFile(this.getConfigFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int command(MigrationConfig config, Function<MigrationConfig, Client> clientSupplier, String migrationsDir) {
        boolean success;
        Client ksqlClient;
        try {
            ksqlClient = clientSupplier.apply(config);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        if (!this.validateMetadataInitialized(ksqlClient, config)) {
            ksqlClient.close();
            return 1;
        }
        try {
            success = ValidateMigrationsCommand.validate(config, migrationsDir, ksqlClient);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            success = false;
        }
        finally {
            ksqlClient.close();
        }
        if (success) {
            LOGGER.info("Successfully validated checksums for migrations that have already been applied");
            return 0;
        }
        return 1;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    static boolean validate(MigrationConfig config, String migrationsDir, Client ksqlClient) {
        String version = MetadataUtil.getLatestMigratedVersion(config, ksqlClient);
        String nextVersion = null;
        while (!version.equals("<none>")) {
            String filename;
            MigrationVersionInfo versionInfo = MetadataUtil.getInfoForVersion(version, config, ksqlClient);
            if (nextVersion != null) {
                MetadataUtil.validateVersionIsMigrated(version, versionInfo, nextVersion);
            }
            try {
                filename = MigrationsDirectoryUtil.getMigrationForVersion(version, migrationsDir).get().getFilepath();
            }
            catch (MigrationException | NoSuchElementException e) {
                LOGGER.error("No migrations file found for version with status {}. Version: {}", (Object)MetadataUtil.MigrationState.MIGRATED, (Object)version);
                return false;
            }
            String hash = MigrationsDirectoryUtil.computeHashForFile(filename);
            String expectedHash = versionInfo.getExpectedHash();
            if (!expectedHash.equals(hash)) {
                LOGGER.error("Migrations file found for version {} does not match the checksum saved for this version. Expected checksum: {}. Actual checksum: {}. File name: {}", new Object[]{version, expectedHash, hash, filename});
                return false;
            }
            nextVersion = version;
            version = versionInfo.getPrevVersion();
        }
        return true;
    }
}

