/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.VariableSubstitutor;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.tree.CreateConnector;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.tools.migrations.MigrationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;

public final class CommandParser {
    private static final String QUOTED_STRING_OR_WHITESPACE = "('([^']*|(''))*')|\\s+";
    private static final Pattern SET_PROPERTY = Pattern.compile("\\s*SET\\s+'((?:[^']*|(?:''))*)'\\s*=\\s*'((?:[^']*|(?:''))*)'\\s*;\\s*", 2);
    private static final Pattern UNSET_PROPERTY = Pattern.compile("\\s*UNSET\\s+'((?:[^']*|(?:''))*)'\\s*;\\s*", 2);
    private static final Pattern DROP_CONNECTOR = Pattern.compile("\\s*DROP\\s+CONNECTOR\\s+(.*?)\\s*;\\s*", 2);
    private static final Pattern DEFINE_VARIABLE = Pattern.compile("\\s*DEFINE\\s+([a-zA-Z_][a-zA-Z0-9_@]*)\\s*=\\s*'((?:[^']*|(?:''))*)'\\s*;\\s*", 2);
    private static final Pattern UNDEFINE_VARIABLE = Pattern.compile("\\s*UNDEFINE\\s+([a-zA-Z_][a-zA-Z0-9_@]*)\\s*;\\s*", 2);
    private static final KsqlParser KSQL_PARSER = new DefaultKsqlParser();
    private static final String INSERT = "INSERT";
    private static final String INTO = "INTO";
    private static final String VALUES = "VALUES";
    private static final String SELECT = "SELECT";
    private static final String CREATE = "CREATE";
    private static final String SINK = "SINK";
    private static final String SOURCE = "SOURCE";
    private static final String DROP = "DROP";
    private static final String CONNECTOR = "CONNECTOR";
    private static final String SET = "SET";
    private static final String UNSET = "UNSET";
    private static final String DEFINE = "DEFINE";
    private static final String UNDEFINE = "UNDEFINE";
    private static final String DESCRIBE = "DESCRIBE";
    private static final String EXPLAIN = "EXPLAIN";
    private static final String PRINT = "PRINT";
    private static final String SHOW = "SHOW";
    private static final String LIST = "LIST";
    private static final String RUN = "RUN";
    private static final String SCRIPT = "SCRIPT";
    private static final String SHORT_COMMENT_OPENER = "--";
    private static final String SHORT_COMMENT_CLOSER = "\n";
    private static final String LONG_COMMENT_OPENER = "/*";
    private static final String LONG_COMMENT_CLOSER = "*/";
    private static final char SINGLE_QUOTE = '\'';
    private static final char SEMICOLON = ';';
    private static final List<String> UNSUPPORTED_STATEMENTS = ImmutableList.of((Object)"DESCRIBE", (Object)"EXPLAIN", (Object)"SELECT", (Object)"PRINT", (Object)"SHOW", (Object)"LIST");

    private CommandParser() {
    }

    public static List<String> splitSql(String sql) {
        ArrayList<String> commands = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int index = 0;
        while (index < sql.length()) {
            if (sql.charAt(index) == '\'') {
                int closingToken = sql.indexOf(39, index + 1);
                CommandParser.validateToken(String.valueOf('\''), closingToken);
                current.append(sql, index, closingToken + 1);
                index = closingToken + 1;
                continue;
            }
            if (index < sql.length() - 1 && sql.startsWith(SHORT_COMMENT_OPENER, index)) {
                index = sql.indexOf(SHORT_COMMENT_CLOSER, index + 1) + 1;
                CommandParser.validateToken(SHORT_COMMENT_CLOSER, index - 1);
                continue;
            }
            if (index < sql.length() - 1 && sql.startsWith(LONG_COMMENT_OPENER, index)) {
                index = sql.indexOf(LONG_COMMENT_CLOSER, index + 1) + 2;
                CommandParser.validateToken(LONG_COMMENT_CLOSER, index - 2);
                continue;
            }
            if (sql.charAt(index) == ';') {
                current.append(';');
                commands.add(current.toString());
                current = new StringBuilder();
                ++index;
                continue;
            }
            current.append(sql.charAt(index));
            ++index;
        }
        if (!current.toString().trim().isEmpty()) {
            throw new MigrationException(String.format("Unmatched command at end of file; missing semicolon: '%s'", current));
        }
        return commands;
    }

    private static void validateToken(String token, int index) {
        if (index < 0) {
            throw new MigrationException("Invalid sql - failed to find closing token '" + token + "'");
        }
    }

    public static Object toFieldType(Expression expressionValue) {
        if (expressionValue instanceof StringLiteral) {
            return ((StringLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof IntegerLiteral) {
            return ((IntegerLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof LongLiteral) {
            return ((LongLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof DoubleLiteral) {
            return ((DoubleLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof BooleanLiteral) {
            return ((BooleanLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof DecimalLiteral) {
            return ((DecimalLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof CreateArrayExpression) {
            return ((CreateArrayExpression)expressionValue).getValues().stream().map(CommandParser::toFieldType).collect(Collectors.toList());
        }
        if (expressionValue instanceof CreateMapExpression) {
            HashMap resolvedMap = new HashMap();
            ((CreateMapExpression)expressionValue).getMap().forEach((k, v) -> resolvedMap.put(CommandParser.toFieldType(k), CommandParser.toFieldType(v)));
            return resolvedMap;
        }
        if (expressionValue instanceof CreateStructExpression) {
            HashMap resolvedStruct = new HashMap();
            ((CreateStructExpression)expressionValue).getFields().forEach(field -> resolvedStruct.put(field.getName(), CommandParser.toFieldType(field.getValue())));
            return resolvedStruct;
        }
        throw new IllegalStateException("Expression type not recognized: " + expressionValue.toString());
    }

    public static SqlCommand transformToSqlCommand(String sql, Map<String, String> variables) {
        List<String> tokens = Arrays.stream(sql.toUpperCase().split(QUOTED_STRING_OR_WHITESPACE)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        switch (CommandParser.getStatementType(tokens)) {
            case INSERT_VALUES: {
                return CommandParser.getInsertValuesStatement(sql, variables);
            }
            case CREATE_CONNECTOR: {
                return CommandParser.getCreateConnectorStatement(sql);
            }
            case DROP_CONNECTOR: {
                return CommandParser.getDropConnectorStatement(sql);
            }
            case STATEMENT: {
                return new SqlStatement(sql);
            }
            case SET_PROPERTY: {
                return CommandParser.getSetPropertyCommand(sql, variables);
            }
            case UNSET_PROPERTY: {
                return CommandParser.getUnsetPropertyCommand(sql, variables);
            }
            case DEFINE_VARIABLE: {
                return CommandParser.getDefineVariableCommand(sql, variables);
            }
            case UNDEFINE_VARIABLE: {
                return CommandParser.getUndefineVariableCommand(sql);
            }
        }
        throw new IllegalStateException();
    }

    private static SqlInsertValues getInsertValuesStatement(String sql, Map<String, String> variables) {
        InsertValues parsedStatement;
        try {
            String substituted = VariableSubstitutor.substitute((KsqlParser.ParsedStatement)((KsqlParser.ParsedStatement)KSQL_PARSER.parse(sql).get(0)), variables);
            parsedStatement = (InsertValues)new AstBuilder(TypeRegistry.EMPTY).buildStatement((ParserRuleContext)((KsqlParser.ParsedStatement)KSQL_PARSER.parse(substituted).get(0)).getStatement());
        }
        catch (ParseFailedException e) {
            throw new MigrationException(String.format("Failed to parse INSERT VALUES statement. Statement: %s. Reason: %s", sql, e.getMessage()));
        }
        return new SqlInsertValues(sql, CommandParser.preserveCase(parsedStatement.getTarget().text()), parsedStatement.getValues(), parsedStatement.getColumns().stream().map(Name::text).collect(Collectors.toList()));
    }

    private static SqlCreateConnectorStatement getCreateConnectorStatement(String sql) {
        CreateConnector createConnector;
        try {
            createConnector = (CreateConnector)new AstBuilder(TypeRegistry.EMPTY).buildStatement((ParserRuleContext)((KsqlParser.ParsedStatement)KSQL_PARSER.parse(sql).get(0)).getStatement());
        }
        catch (ParseFailedException e2) {
            throw new MigrationException(String.format("Failed to parse CREATE CONNECTOR statement. Statement: %s. Reason: %s", sql, e2.getMessage()));
        }
        return new SqlCreateConnectorStatement(sql, CommandParser.preserveCase(createConnector.getName()), createConnector.getType() == CreateConnector.Type.SOURCE, createConnector.getConfig().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CommandParser.toFieldType((Expression)e.getValue()))));
    }

    private static SqlDropConnectorStatement getDropConnectorStatement(String sql) {
        Matcher dropConnectorMatcher = DROP_CONNECTOR.matcher(sql);
        if (!dropConnectorMatcher.matches()) {
            throw new MigrationException("Invalid DROP CONNECTOR command: " + sql);
        }
        return new SqlDropConnectorStatement(sql, dropConnectorMatcher.group(1));
    }

    private static SqlPropertyCommand getSetPropertyCommand(String sql, Map<String, String> variables) {
        Matcher setPropertyMatcher = SET_PROPERTY.matcher(sql);
        if (!setPropertyMatcher.matches()) {
            throw new MigrationException("Invalid SET command: " + sql);
        }
        return new SqlPropertyCommand(sql, true, VariableSubstitutor.substitute((String)setPropertyMatcher.group(1), variables), Optional.of(VariableSubstitutor.substitute((String)setPropertyMatcher.group(2), variables)));
    }

    private static SqlPropertyCommand getUnsetPropertyCommand(String sql, Map<String, String> variables) {
        Matcher unsetPropertyMatcher = UNSET_PROPERTY.matcher(sql);
        if (!unsetPropertyMatcher.matches()) {
            throw new MigrationException("Invalid UNSET command: " + sql);
        }
        return new SqlPropertyCommand(sql, false, VariableSubstitutor.substitute((String)unsetPropertyMatcher.group(1), variables), Optional.empty());
    }

    private static SqlDefineVariableCommand getDefineVariableCommand(String sql, Map<String, String> variables) {
        Matcher defineVariableMatcher = DEFINE_VARIABLE.matcher(sql);
        if (!defineVariableMatcher.matches()) {
            throw new MigrationException("Invalid DEFINE command: " + sql);
        }
        return new SqlDefineVariableCommand(sql, defineVariableMatcher.group(1), VariableSubstitutor.substitute((String)defineVariableMatcher.group(2), variables));
    }

    private static SqlUndefineVariableCommand getUndefineVariableCommand(String sql) {
        Matcher undefineVariableMatcher = UNDEFINE_VARIABLE.matcher(sql);
        if (!undefineVariableMatcher.matches()) {
            throw new MigrationException("Invalid UNDEFINE command: " + sql);
        }
        return new SqlUndefineVariableCommand(sql, undefineVariableMatcher.group(1));
    }

    private static StatementType getStatementType(List<String> tokens) {
        if (CommandParser.isInsertValuesStatement(tokens)) {
            return StatementType.INSERT_VALUES;
        }
        if (CommandParser.isCreateConnectorStatement(tokens)) {
            return StatementType.CREATE_CONNECTOR;
        }
        if (CommandParser.isDropConnectorStatement(tokens)) {
            return StatementType.DROP_CONNECTOR;
        }
        if (CommandParser.isSetStatement(tokens)) {
            return StatementType.SET_PROPERTY;
        }
        if (CommandParser.isUnsetStatement(tokens)) {
            return StatementType.UNSET_PROPERTY;
        }
        if (CommandParser.isDefineStatement(tokens)) {
            return StatementType.DEFINE_VARIABLE;
        }
        if (CommandParser.isUndefineStatement(tokens)) {
            return StatementType.UNDEFINE_VARIABLE;
        }
        CommandParser.validateSupportedStatementType(tokens);
        return StatementType.STATEMENT;
    }

    private static boolean isInsertValuesStatement(List<String> tokens) {
        return tokens.size() > 3 && tokens.get(0).equals(INSERT) && tokens.get(1).equals(INTO) && !tokens.get(3).equals(SELECT) && tokens.contains(VALUES);
    }

    private static boolean isCreateConnectorStatement(List<String> tokens) {
        return tokens.size() > 2 && tokens.get(0).equals(CREATE) && (tokens.get(1).equals(SINK) || tokens.get(1).equals(SOURCE)) && tokens.get(2).equals(CONNECTOR);
    }

    private static boolean isDropConnectorStatement(List<String> tokens) {
        return tokens.size() > 1 && tokens.get(0).equals(DROP) && tokens.get(1).equals(CONNECTOR);
    }

    private static boolean isSetStatement(List<String> tokens) {
        return tokens.size() > 0 && tokens.get(0).equals(SET);
    }

    private static boolean isUnsetStatement(List<String> tokens) {
        return tokens.size() > 0 && tokens.get(0).equals(UNSET);
    }

    private static boolean isDefineStatement(List<String> tokens) {
        return tokens.size() > 0 && tokens.get(0).equals(DEFINE);
    }

    private static boolean isUndefineStatement(List<String> tokens) {
        return tokens.size() > 0 && tokens.get(0).equals(UNDEFINE);
    }

    private static void validateSupportedStatementType(List<String> tokens) {
        if (tokens.size() > 0 && UNSUPPORTED_STATEMENTS.contains(tokens.get(0))) {
            throw new MigrationException("'" + tokens.get(0) + "' statements are not supported.");
        }
        if (tokens.size() > 1 && tokens.get(0).equals(RUN) && tokens.get(1).equals(SCRIPT)) {
            throw new MigrationException("'RUN SCRIPT' statements are not supported.");
        }
    }

    public static String preserveCase(String fieldOrSourceName) {
        return "`" + fieldOrSourceName + "`";
    }

    public static class SqlUndefineVariableCommand
    extends SqlCommand {
        private final String variable;

        SqlUndefineVariableCommand(String command, String variable) {
            super(command);
            this.variable = Objects.requireNonNull(variable);
        }

        public String getVariable() {
            return this.variable;
        }
    }

    public static class SqlDefineVariableCommand
    extends SqlCommand {
        private final String variable;
        private final String value;

        SqlDefineVariableCommand(String command, String variable, String value) {
            super(command);
            this.variable = Objects.requireNonNull(variable);
            this.value = Objects.requireNonNull(value);
        }

        public String getVariable() {
            return this.variable;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class SqlPropertyCommand
    extends SqlCommand {
        private final boolean set;
        private final String property;
        private final Optional<String> value;

        SqlPropertyCommand(String command, boolean set, String property, Optional<String> value) {
            super(command);
            this.set = set;
            this.property = Objects.requireNonNull(property);
            this.value = Objects.requireNonNull(value);
        }

        public boolean isSetCommand() {
            return this.set;
        }

        public String getProperty() {
            return this.property;
        }

        public Optional<String> getValue() {
            return this.value;
        }
    }

    public static class SqlDropConnectorStatement
    extends SqlCommand {
        final String name;

        SqlDropConnectorStatement(String command, String name) {
            super(command);
            this.name = Objects.requireNonNull(name);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SqlCreateConnectorStatement
    extends SqlCommand {
        final String name;
        final boolean isSource;
        final ImmutableMap<String, Object> properties;

        SqlCreateConnectorStatement(String command, String name, boolean isSource, Map<String, Object> properties) {
            super(command);
            this.name = Objects.requireNonNull(name);
            this.isSource = isSource;
            this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties));
        }

        public String getName() {
            return this.name;
        }

        public boolean isSource() {
            return this.isSource;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="properties is ImmutableMap")
        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    public static class SqlStatement
    extends SqlCommand {
        SqlStatement(String command) {
            super(command);
        }
    }

    public static class SqlInsertValues
    extends SqlCommand {
        private final String sourceName;
        private final ImmutableList<String> columns;
        private final ImmutableList<Expression> values;

        SqlInsertValues(String command, String sourceName, List<Expression> values, List<String> columns) {
            super(command);
            this.sourceName = sourceName;
            this.values = ImmutableList.copyOf(values);
            this.columns = ImmutableList.copyOf(columns);
        }

        public String getSourceName() {
            return this.sourceName;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="values is ImmutableList")
        public List<Expression> getValues() {
            return this.values;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columns is ImmutableList")
        public List<String> getColumns() {
            return this.columns;
        }
    }

    public static abstract class SqlCommand {
        private final String command;

        SqlCommand(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }

    private static enum StatementType {
        INSERT_VALUES,
        CREATE_CONNECTOR,
        DROP_CONNECTOR,
        STATEMENT,
        SET_PROPERTY,
        UNSET_PROPERTY,
        DEFINE_VARIABLE,
        UNDEFINE_VARIABLE;

    }
}

