/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.util;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.client.Row;
import io.confluent.ksql.tools.migrations.util.MetadataUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public final class MigrationVersionInfo {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS z";
    private static final String EMPTY_MIGRATION_TIMESTAMP = "N/A";
    private final int version;
    private final String expectedHash;
    private final String prevVersion;
    private final MetadataUtil.MigrationState state;
    private final String name;
    private final String startedOn;
    private final String completedOn;
    private final String errorReason;

    public static MigrationVersionInfo fromResultRow(Row row) {
        return new MigrationVersionInfo(Integer.parseInt(row.getString(1)), row.getString(2), row.getString(3), row.getString(4), row.getString(5), row.getString(6), row.getString(7), row.getString(8));
    }

    public static MigrationVersionInfo pendingMigration(int version, String name) {
        return new MigrationVersionInfo(version, EMPTY_MIGRATION_TIMESTAMP, EMPTY_MIGRATION_TIMESTAMP, MetadataUtil.MigrationState.PENDING.toString(), name, EMPTY_MIGRATION_TIMESTAMP, EMPTY_MIGRATION_TIMESTAMP, EMPTY_MIGRATION_TIMESTAMP);
    }

    @VisibleForTesting
    MigrationVersionInfo(int version, String expectedHash, String prevVersion, String state, String name, String startedOn, String completedOn, String errorReason) {
        this.version = version;
        this.expectedHash = Objects.requireNonNull(expectedHash, "expectedHash");
        this.prevVersion = Objects.requireNonNull(prevVersion, "prevVersion");
        this.state = MetadataUtil.MigrationState.valueOf(Objects.requireNonNull(state, "state"));
        this.name = Objects.requireNonNull(name, "name");
        this.errorReason = Objects.requireNonNull(errorReason, "errorReason");
        Objects.requireNonNull(startedOn, "startedOn");
        Objects.requireNonNull(completedOn, "completedOn");
        this.startedOn = MigrationVersionInfo.formatTimestamp(startedOn);
        this.completedOn = MigrationVersionInfo.formatTimestamp(completedOn);
    }

    public int getVersion() {
        return this.version;
    }

    public String getExpectedHash() {
        return this.expectedHash;
    }

    public String getPrevVersion() {
        return this.prevVersion;
    }

    public MetadataUtil.MigrationState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public String getStartedOn() {
        return this.startedOn;
    }

    public String getCompletedOn() {
        return this.completedOn;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    private static String formatTimestamp(String epochTime) {
        if (epochTime.equals("") || epochTime.equals(EMPTY_MIGRATION_TIMESTAMP)) {
            return epochTime;
        }
        return new SimpleDateFormat(DATE_FORMAT).format(new Date(Long.parseLong(epochTime)));
    }
}

