/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.util;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.ClientOptions;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import java.net.MalformedURLException;
import java.net.URL;

public final class MigrationsUtil {
    public static final String MIGRATIONS_COMMAND = "ksql-migrations";

    private MigrationsUtil() {
    }

    public static Client getKsqlClient(MigrationConfig config) throws MigrationException {
        return MigrationsUtil.getKsqlClient(config.getString("ksql.server.url"), config.getString("ksql.auth.basic.username"), config.getString("ksql.auth.basic.password"), config.getString("ssl.truststore.location"), config.getString("ssl.truststore.password"), config.getString("ssl.keystore.location"), config.getString("ssl.keystore.password"), config.getString("ssl.key.password"), config.getString("ssl.key.alias"), config.getBoolean("ssl.alpn"), config.getBoolean("ssl.verify.host"));
    }

    public static Client getKsqlClient(String ksqlServerUrl, String username, String password, String sslTrustStoreLocation, String sslTrustStorePassword, String sslKeystoreLocation, String sslKeystorePassword, String sslKeyPassword, String sslKeyAlias, boolean sslAlpn, boolean sslVerifyHost) {
        return Client.create((ClientOptions)MigrationsUtil.createClientOptions(ksqlServerUrl, username, password, sslTrustStoreLocation, sslTrustStorePassword, sslKeystoreLocation, sslKeystorePassword, sslKeyPassword, sslKeyAlias, sslAlpn, sslVerifyHost));
    }

    @VisibleForTesting
    static ClientOptions createClientOptions(String ksqlServerUrl, String username, String password, String sslTrustStoreLocation, String sslTrustStorePassword, String sslKeystoreLocation, String sslKeystorePassword, String sslKeyPassword, String sslKeyAlias, boolean useAlpn, boolean verifyHost) {
        URL url;
        try {
            url = new URL(ksqlServerUrl);
        }
        catch (MalformedURLException e) {
            throw new MigrationException("Invalid ksql server URL: " + ksqlServerUrl);
        }
        ClientOptions options = ClientOptions.create().setHost(url.getHost()).setPort(url.getPort());
        if (username != null || password != null) {
            options.setBasicAuthCredentials(username, password);
        }
        boolean useTls = ksqlServerUrl.trim().toLowerCase().startsWith("https://");
        options.setUseTls(useTls);
        if (useTls) {
            options.setTrustStore(sslTrustStoreLocation);
            options.setTrustStorePassword(sslTrustStorePassword);
            options.setKeyStore(sslKeystoreLocation);
            options.setKeyStorePassword(sslKeystorePassword);
            options.setKeyPassword(sslKeyPassword);
            options.setKeyAlias(sslKeyAlias);
            options.setUseAlpn(useAlpn);
            options.setVerifyHost(verifyHost);
        }
        return options;
    }
}

