/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacperf.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.AssertJUnit;
import retrofit2.Response;

public class PerfTestUtils {
    public static void profileApi(ProfilableApiCall profilableApiCall, List<Object> argList, String msg, boolean dryRun, boolean printOutput) throws IOException {
        if (dryRun) {
            System.out.println("Arglist length: " + argList.size());
        } else {
            ArrayList<Long> times = new ArrayList<Long>();
            Long totalTime = 0L;
            for (Object arg : argList) {
                if (printOutput) {
                    System.out.println("> Input: " + arg);
                }
                Long startTime = System.nanoTime();
                Response<?> response = profilableApiCall.apiCall(arg);
                Long endTime = System.nanoTime();
                times.add(endTime - startTime);
                AssertJUnit.assertEquals((int)200, (int)response.code());
                if (printOutput) {
                    System.out.println("> Output: " + response.body());
                }
                if ((totalTime = Long.valueOf(totalTime + (endTime - startTime))) / 1000000000L <= 30L) continue;
                break;
            }
            List iterTimesInMilliSecond = times.stream().map(ns -> (double)ns.longValue() / 1000000.0).collect(Collectors.toList());
            DoubleSummaryStatistics statistics = iterTimesInMilliSecond.stream().mapToDouble(f -> f).summaryStatistics();
            System.out.println(String.format("%s, %d, %f, %f, %f, %f", msg, statistics.getCount(), statistics.getSum(), statistics.getMin(), statistics.getAverage(), statistics.getMax()));
        }
    }

    public static void printProfileHeader() {
        System.out.println();
        System.out.println(String.format("#### Testing %s ####", Thread.currentThread().getStackTrace()[2].getMethodName()));
        System.out.println("# What we vary, number of samples, total ms, min ms, average ms, max ms");
    }

    public static void printTestName() {
        System.out.println();
        System.out.println(">>> BeginTest: " + Thread.currentThread().getStackTrace()[2].getMethodName());
        System.out.println();
    }

    public static interface ProfilableApiCall {
        public Response<?> apiCall(Object var1) throws IOException;
    }
}

