/*
 * Decompiled with CFR 0.152.
 */
package utils;

import io.confluent.common.security.util.PemUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;

public final class JwtTestHelper {
    private final KeyPair keyPair = JwtTestHelper.generateKeyPair();

    public String buildJwt(String ... clusterIds) {
        return this.buildJwt(TimeUnit.HOURS.toMillis(1L), clusterIds);
    }

    public String buildJwt(long expiryMs, String ... clusterIds) {
        long expirationMs = Instant.now().toEpochMilli() + expiryMs;
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("Confluent");
        claims.setExpirationTime(NumericDate.fromMilliseconds((long)expirationMs));
        claims.setJwtId("000-111-222-333");
        claims.setStringListClaim("clusters", clusterIds);
        claims.setSubject("franz");
        return this.buildJwt(claims);
    }

    public String buildJwt(JwtClaims claims) {
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)this.keyPair.getPrivate());
            jws.setAlgorithmHeaderValue("RS256");
            return jws.getCompactSerialization();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build JWT", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path createJwtPublicKey(Path file) {
        KeyPair keyPair = JwtTestHelper.generateKeyPair();
        try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            PemUtils.writePublicKey((OutputStream)os, (PublicKey)keyPair.getPublic());
            Path path = file;
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load JWT PEM file", e);
        }
    }

    public static void generateKeyPair(Path pemOut) {
        KeyPair keyPair = JwtTestHelper.generateKeyPair();
        try (OutputStream os = Files.newOutputStream(pemOut, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            PemUtils.writeKeyPair((OutputStream)os, (KeyPair)keyPair);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load JWT PEM file", e);
        }
    }

    public static void extractPublicKey(Path pemIn, Path pemOut) {
        try (FileInputStream pemStream = new FileInputStream(pemIn.toFile());){
            KeyPair keys = PemUtils.loadKeyPair((InputStream)pemStream);
            JwtTestHelper.writePublicKey(pemOut, keys);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract public key from pem", e);
        }
    }

    public static KeyPair writeKeys(Path privateOut, Path publicOut) {
        KeyPair keyPair = JwtTestHelper.generateKeyPair();
        JwtTestHelper.writeKeyPair(privateOut, keyPair);
        JwtTestHelper.writePublicKey(publicOut, keyPair);
        return keyPair;
    }

    private static void writeKeyPair(Path out, KeyPair keys) {
        try (OutputStream os = Files.newOutputStream(out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            PemUtils.writeKeyPair((OutputStream)os, (KeyPair)keys);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write PEM encoded private key", e);
        }
    }

    public static void writePublicKey(Path out, KeyPair keys) {
        try (OutputStream os = Files.newOutputStream(out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            PemUtils.writePublicKey((OutputStream)os, (PublicKey)keys.getPublic());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write PEM encoded private key", e);
        }
    }

    private static synchronized KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate key pair", e);
        }
    }
}

