/*
 * Decompiled with CFR 0.152.
 */
package utils;

import io.confluent.security.test.utils.RbacClusters;
import io.confluent.tokenapi.jwt.JwtProvider;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.jose4j.lang.JoseException;
import org.slf4j.bridge.SLF4JBridgeHandler;
import utils.JwtTestHelper;
import utils.MdsTestUtil;

public class KafkaConfigTool {
    public static RbacClusters.Config noAuth() {
        return KafkaConfigTool.noAuth("mds");
    }

    public static RbacClusters.Config noAuth(String brokerUser) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("super.users", "User:" + brokerUser + ";User:ANONYMOUS");
        String portToUse = MdsTestUtil.acquirePort(8090);
        props.put("confluent.metadata.server.listeners", MdsTestUtil.DEFAULT_HTTP_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.advertised.listeners", MdsTestUtil.DEFAULT_HTTP_ADVERTISED_HOST + ":" + portToUse);
        props.put("confluent.security.event.logger.exporter.kafka.topic.replicas", "1");
        props.put("confluent.metadata.server.authentication.method", "NONE");
        RbacClusters.Config config = new RbacClusters.Config().users("mds", Collections.emptyList());
        KafkaConfigTool.applyProperties(props, config);
        KafkaConfigTool.turnOffAuditLogs(config);
        config.withManagedCluster(false);
        return config;
    }

    public static RbacClusters.Config justLDAPv1(int ldapPort, String brokerUser) {
        return KafkaConfigTool.justLDAPv1(ldapPort, brokerUser, Collections.emptyList());
    }

    public static RbacClusters.Config justLDAPv1(int ldapPort, int mdsPort, String brokerUser) {
        return KafkaConfigTool.justLDAP(ldapPort, mdsPort, brokerUser, Collections.emptyList(), "CP");
    }

    public static RbacClusters.Config justLDAPv1(int ldapPort, String brokerUser, List<String> userNames) {
        return KafkaConfigTool.justLDAP(ldapPort, 8090, brokerUser, userNames, "CP");
    }

    public static RbacClusters.Config justLDAPv1(int ldapPort, int mdsPort, String brokerUser, List<String> userNames) {
        return KafkaConfigTool.justLDAP(ldapPort, mdsPort, brokerUser, userNames, "CP_TRANSITIONAL");
    }

    public static RbacClusters.Config justLDAPv1v2(int ldapPort, String brokerUser) {
        return KafkaConfigTool.justLDAPv1v2(ldapPort, brokerUser, Collections.emptyList());
    }

    public static RbacClusters.Config justLDAPv1v2(int ldapPort, int mdsPort, String brokerUser) {
        return KafkaConfigTool.justLDAP(ldapPort, mdsPort, brokerUser, Collections.emptyList(), "CP_TRANSITIONAL");
    }

    public static RbacClusters.Config justLDAPv1v2(int ldapPort, String brokerUser, List<String> userNames) {
        return KafkaConfigTool.justLDAP(ldapPort, 8090, brokerUser, userNames, "CP_TRANSITIONAL");
    }

    private static RbacClusters.Config justLDAP(int ldapPort, int mdsPort, String brokerUser, List<String> userNames, String flavor) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("confluent.metadata.server.api.flavor", flavor);
        props.put("super.users", "User:" + brokerUser);
        String portToUse = MdsTestUtil.acquirePort(mdsPort);
        props.put("confluent.metadata.server.listeners", MdsTestUtil.DEFAULT_HTTP_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.advertised.listeners", MdsTestUtil.DEFAULT_HTTP_ADVERTISED_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.authentication.method", "BASIC");
        props.put("ldap.java.naming.provider.url", "ldap://localhost:" + ldapPort + "/dc=example,dc=com");
        props.put("ldap.refresh.interval.ms", "50");
        props.put("ldap.java.naming.security.principal", "uid=admin,ou=system");
        props.put("ldap.java.naming.security.credentials", "secret");
        props.put("ldap.java.naming.security.authentication", "simple");
        props.put("ldap.group.name.attribute", "cn");
        props.put("ldap.group.member.attribute.pattern", "uid=(.*),ou=users,dc=example,dc=com");
        props.put("confluent.security.event.logger.exporter.kafka.topic.replicas", "1");
        RbacClusters.Config config = new RbacClusters.Config().users(brokerUser, userNames);
        KafkaConfigTool.applyProperties(props, config);
        KafkaConfigTool.turnOffAuditLogs(config);
        config.withManagedCluster(false);
        return config;
    }

    public static RbacClusters.Config justHash(String brokerUser) {
        return KafkaConfigTool.justHash(8090, brokerUser, Collections.emptyList());
    }

    public static RbacClusters.Config justHash(String brokerUser, String ... otherUsers) {
        return KafkaConfigTool.justHash(8090, brokerUser, Arrays.asList(otherUsers));
    }

    public static RbacClusters.Config justHash(String brokerUser, List<String> otherUsers) {
        return KafkaConfigTool.justHash(8090, brokerUser, otherUsers);
    }

    public static RbacClusters.Config justHash(int mdsPort, String brokerUser, List<String> otherUsers) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("super.users", "User:" + brokerUser);
        String portToUse = MdsTestUtil.acquirePort(mdsPort);
        props.put("confluent.metadata.server.listeners", MdsTestUtil.DEFAULT_HTTP_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.advertised.listeners", MdsTestUtil.DEFAULT_HTTP_ADVERTISED_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.authentication.method", "BASIC");
        props.put("confluent.metadata.server.user.store", "FILE");
        props.put("confluent.security.event.logger.exporter.kafka.topic.replicas", "1");
        ArrayList<String> users = new ArrayList<String>(otherUsers);
        users.add(brokerUser);
        File hashPropsFile = KafkaConfigTool.createHashLoginPropFile(users);
        props.put("confluent.metadata.server.user.store.file.path", hashPropsFile.getPath());
        RbacClusters.Config config = new RbacClusters.Config().users(brokerUser, Collections.emptyList());
        KafkaConfigTool.applyProperties(props, config);
        KafkaConfigTool.turnOffAuditLogs(config);
        config.withManagedCluster(false);
        return config;
    }

    public static RbacClusters.Config ldapWithTokens(String brokerUser) {
        return KafkaConfigTool.ldapWithTokens(8389, brokerUser);
    }

    public static RbacClusters.Config ldapWithTokensTwoNodes(int ldapPort, String brokerUser) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("super.users", "User:" + brokerUser);
        props.put("confluent.license", "test");
        props.put("confluent.metadata.server.authentication.method", "BEARER");
        props.put("ldap.java.naming.provider.url", "ldap://localhost:" + ldapPort + "/dc=example,dc=com");
        props.put("ldap.refresh.interval.ms", "50");
        props.put("ldap.java.naming.security.principal", "uid=admin,ou=system");
        props.put("ldap.java.naming.security.credentials", "secret");
        props.put("ldap.java.naming.security.authentication", "simple");
        props.put("ldap.group.name.attribute", "cn");
        props.put("ldap.group.member.attribute.pattern", "uid=(.*),ou=users,dc=example,dc=com");
        TokenPemFiles pemFiles = KafkaConfigTool.createTokenPemFiles();
        props.put("confluent.metadata.server.token.key.path", pemFiles.tokenKeyPair);
        props.put("confluent.security.event.logger.exporter.kafka.topic.replicas", "1");
        RbacClusters.Config config = new RbacClusters.Config().users(brokerUser, Collections.emptyList());
        KafkaConfigTool.applyProperties(props, config);
        config.withTokenLogin(pemFiles.tokenPublicKey);
        config.addMetadataServer();
        return config;
    }

    public static RbacClusters.Config ldapWithTokens(int ldapPort, String brokerUser) {
        return KafkaConfigTool.ldapWithTokens(ldapPort, brokerUser, -1);
    }

    public static RbacClusters.Config ldapWithTokens(int ldapPort, String brokerUser, int kafkaListenerPortBase) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("super.users", "User:" + brokerUser);
        String portToUse = MdsTestUtil.acquirePort(8090);
        props.put("confluent.metadata.server.listeners", MdsTestUtil.DEFAULT_HTTP_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.advertised.listeners", MdsTestUtil.DEFAULT_HTTP_ADVERTISED_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.authentication.method", "BEARER");
        props.put("ldap.java.naming.provider.url", "ldap://localhost:" + ldapPort + "/dc=example,dc=com");
        props.put("ldap.refresh.interval.ms", "50");
        props.put("ldap.java.naming.security.principal", "uid=admin,ou=system");
        props.put("ldap.java.naming.security.credentials", "secret");
        props.put("ldap.java.naming.security.authentication", "simple");
        props.put("ldap.group.name.attribute", "cn");
        props.put("ldap.group.member.attribute.pattern", "uid=(.*),ou=users,dc=example,dc=com");
        TokenPemFiles pemFiles = KafkaConfigTool.createTokenPemFiles();
        props.put("confluent.metadata.server.token.key.path", pemFiles.tokenKeyPair);
        props.put("confluent.security.event.logger.exporter.kafka.topic.replicas", "1");
        if (kafkaListenerPortBase != -1) {
            props.put("listeners", String.format("EXTERNAL://localhost:%d,INTERNAL://localhost:%d", kafkaListenerPortBase, kafkaListenerPortBase + 1));
        }
        RbacClusters.Config config = new RbacClusters.Config().users(brokerUser, Collections.emptyList());
        KafkaConfigTool.applyProperties(props, config);
        KafkaConfigTool.turnOffAuditLogs(config);
        config.withTokenLogin(pemFiles.tokenPublicKey);
        config.withManagedCluster(false);
        return config;
    }

    public static RbacClusters.Config hashWithTokens(String brokerUser, List<String> users) {
        return KafkaConfigTool.hashWithTokens(brokerUser, users, 8090);
    }

    public static RbacClusters.Config hashWithTokens(String brokerUser, List<String> users, int mdsPort) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("super.users", "User:" + brokerUser);
        String portToUse = MdsTestUtil.acquirePort(mdsPort);
        props.put("confluent.metadata.server.listeners", MdsTestUtil.DEFAULT_HTTP_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.advertised.listeners", MdsTestUtil.DEFAULT_HTTP_ADVERTISED_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.authentication.method", "BEARER");
        props.put("confluent.metadata.server.user.store", "FILE");
        File hashPropsFile = KafkaConfigTool.createHashLoginPropFile(users);
        props.put("confluent.metadata.server.user.store.file.path", hashPropsFile.getPath());
        TokenPemFiles pemFiles = KafkaConfigTool.createTokenPemFiles();
        props.put("confluent.metadata.server.token.key.path", pemFiles.tokenKeyPair);
        RbacClusters.Config config = new RbacClusters.Config().users(brokerUser, Collections.emptyList());
        KafkaConfigTool.applyProperties(props, config);
        KafkaConfigTool.turnOffAuditLogs(config);
        config.withTokenLogin(pemFiles.tokenPublicKey);
        config.withManagedCluster(false);
        return config;
    }

    public static RbacClusters.Config hashWithTokensAndOidc(String brokerUser, List<String> users, Map<String, String> idpConfigs) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("super.users", "User:" + brokerUser);
        String portToUse = MdsTestUtil.acquirePort(8090);
        props.put("confluent.metadata.server.listeners", MdsTestUtil.DEFAULT_HTTP_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.advertised.listeners", MdsTestUtil.DEFAULT_HTTP_ADVERTISED_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.authentication.method", "BEARER");
        props.put("confluent.metadata.server.user.store", "FILE");
        File hashPropsFile = KafkaConfigTool.createHashLoginPropFile(users);
        props.put("confluent.metadata.server.user.store.file.path", hashPropsFile.getPath());
        TokenPemFiles pemFiles = KafkaConfigTool.createTokenPemFiles();
        props.put("confluent.metadata.server.token.key.path", pemFiles.tokenKeyPair);
        props.put("confluent.metadata.server.sso.mode", "oidc");
        props.putAll(idpConfigs);
        RbacClusters.Config config = new RbacClusters.Config().users(brokerUser, Collections.emptyList());
        KafkaConfigTool.applyProperties(props, config);
        KafkaConfigTool.turnOffAuditLogs(config);
        config.withTokenLogin(pemFiles.tokenPublicKey);
        config.withManagedCluster(false);
        return config;
    }

    public static RbacClusters.Config actualCloudConfig(String brokerUser, int mdsPort, String publicKeyPath) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("super.users", "User:ANONYMOUS;User:" + brokerUser);
        String portToUse = MdsTestUtil.acquirePort(mdsPort);
        props.put("confluent.metadata.server.listeners", MdsTestUtil.DEFAULT_HTTP_HOST + ":" + portToUse);
        props.put("confluent.metadata.server.advertised.listeners", MdsTestUtil.DEFAULT_HTTP_ADVERTISED_HOST + ":" + portToUse);
        props.put("authorizer.class.name", "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer");
        props.put("confluent.authorizer.access.rule.providers", "MULTI_TENANT,CONFLUENT");
        props.put("confluent.metadata.server.authentication.method", "BEARER");
        props.put("confluent.metadata.server.api.flavor", "CP");
        props.put("confluent.metadata.server.user.store", "NONE");
        props.put("confluent.metadata.server.issuer", "Confluent");
        props.put("confluent.metadata.server.jwksLocation", publicKeyPath);
        props.put("confluent.metadata.server.verificationKeyResolver", "pemFile");
        RbacClusters.Config config = new RbacClusters.Config().users(brokerUser, Collections.emptyList());
        KafkaConfigTool.applyProperties(props, config);
        KafkaConfigTool.turnOffAuditLogs(config);
        config.withTokenLogin(publicKeyPath);
        config.withManagedCluster(false);
        return config;
    }

    private static void applyProperties(Map<String, String> props, RbacClusters.Config config) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            config.overrideMetadataBrokerConfig(entry.getKey(), entry.getValue());
        }
    }

    public static File createHashLoginPropFile(List<String> users) {
        try {
            File propFile = File.createTempFile("intTest-hashLoginService-", ".properties");
            propFile.deleteOnExit();
            OutputStream os = Files.newOutputStream(propFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            PrintStream printStream = new PrintStream(os);
            for (String user : users) {
                printStream.println(user + ": " + user);
            }
            printStream.close();
            return propFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create HashLogin property file", e);
        }
    }

    public static void minimizeBackgroundServices(RbacClusters.Config config) {
        config.overrideMetadataBrokerConfig("confluent.security.event.logger.enable", "false");
        config.overrideMetadataBrokerConfig("confluent.telemetry.events.enable", "false");
    }

    public static TokenPemFiles createTokenPemFiles() {
        try {
            File publicPem = File.createTempFile("integTest-token-public", ".pem");
            publicPem.deleteOnExit();
            File keyPairPem = File.createTempFile("integTest-token-keypair", ".pem");
            keyPairPem.deleteOnExit();
            JwtTestHelper.writeKeys(keyPairPem.toPath(), publicPem.toPath());
            return new TokenPemFiles(keyPairPem.getPath(), publicPem.getPath());
        }
        catch (IOException e) {
            throw new ConfigException("Failed to generate required pem file", (Object)e);
        }
    }

    public static String generateToken(String keyPairPath, String principal) throws JoseException {
        JwtProvider provider = new JwtProvider();
        provider.configure(Collections.singletonMap("token.key.path", keyPairPath));
        return provider.newJwsToken((Principal)new KafkaPrincipal("User", principal), new String[0]);
    }

    public static String generateToken(final String keyPairPath, String principal, final String issuer) throws JoseException {
        JwtProvider provider = new JwtProvider();
        HashMap<String, String> props = new HashMap<String, String>(){
            {
                this.put("token.key.path", keyPairPath);
                this.put("token.issuer", issuer);
            }
        };
        provider.configure((Map)props);
        return provider.newJwsToken((Principal)new KafkaPrincipal("User", principal), new String[0]);
    }

    public static String generateTokenWithOrgResourceId(final String keyPairPath, String principal, final String issuer, String orgResourceId, String ... audience) throws JoseException {
        JwtProvider provider = new JwtProvider();
        HashMap<String, String> props = new HashMap<String, String>(){
            {
                this.put("token.key.path", keyPairPath);
                this.put("token.issuer", issuer);
            }
        };
        provider.configure((Map)props);
        return provider.newJwsToken(orgResourceId, (Principal)new KafkaPrincipal("User", principal), audience);
    }

    public static void turnOffAuditLogs(RbacClusters.Config config) {
        config.overrideMetadataBrokerConfig("confluent.security.event.logger.enable", "false");
    }

    public static void turnOnAuditLogs(RbacClusters.Config config) {
        config.overrideMetadataBrokerConfig("confluent.security.event.logger.enable", "true");
        config.overrideMetadataBrokerConfig("confluent.security.event.logger.exporter.kafka.delivery.timeout.ms", "1000");
        config.overrideMetadataBrokerConfig("confluent.security.event.logger.exporter.kafka.request.timeout.ms", "500");
    }

    static {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
    }

    public static class TokenPemFiles {
        public final String tokenKeyPair;
        public final String tokenPublicKey;

        public TokenPemFiles(String tokenKeyPair, String tokenPublicKey) {
            this.tokenPublicKey = tokenPublicKey;
            this.tokenKeyPair = tokenKeyPair;
        }
    }
}

