/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.bazaarvoice.jolt.JsonUtil;
import com.bazaarvoice.jolt.JsonUtilImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.confluent.rbacapi.jackson.MdsObjectMapperProvider;
import java.io.IOException;

public class MdsJsonUtil {
    private static final ObjectMapper om = MdsObjectMapperProvider.getObjectMapper();
    private static final ObjectWriter prettyPrintWriter = om.writerWithDefaultPrettyPrinter();
    public static final JsonUtil joltJsonUtil = new JsonUtilImpl(om);

    public static <T> T deserializeJson(String input, TypeReference<T> typeReference) throws IOException {
        return (T)om.readValue(input, typeReference);
    }

    public static <T> T deserializeJavason(String input, TypeReference<T> typeReference) throws IOException {
        return (T)om.readValue(input.replace("'", "\"").getBytes(), typeReference);
    }

    public static String toJson(Object o) throws JsonProcessingException {
        return om.writeValueAsString(o);
    }

    public static String toPrettyJson(Object o) throws JsonProcessingException {
        return prettyPrintWriter.writeValueAsString(o);
    }
}

