/*
 * Decompiled with CFR 0.152.
 */
package utils;

import io.confluent.http.server.KafkaHttpServerImpl;
import io.confluent.security.test.utils.RbacClusters;
import io.confluent.testing.ldap.DefaultPortMutex;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.KafkaBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsTestUtil {
    public static final String TEST_INFRA_LOGGER_NAME = "TEST_INFRA_LOGGER";
    public static String DEFAULT_HTTP_HOST = "http://0.0.0.0";
    public static String DEFAULT_HTTP_ADVERTISED_HOST = "http://localhost";
    private static final AtomicInteger uniqueishMdsPortInt = new AtomicInteger(9009);
    private static final DefaultPortMutex DEFAULT_PORT_MUTEX = new DefaultPortMutex(8090);
    public static final Logger testInfraLogger = LoggerFactory.getLogger((String)"TEST_INFRA_LOGGER");

    public static int getUniqueishMdsPort() {
        return uniqueishMdsPortInt.incrementAndGet();
    }

    public static String acquirePort(int requestedPort) {
        return Integer.toString(DEFAULT_PORT_MUTEX.assignPort(requestedPort));
    }

    public static void releasePort(int releasedPort) {
        DEFAULT_PORT_MUTEX.releasePort(releasedPort);
    }

    public static int lookupActualMdsPort(RbacClusters rbacClusters) throws InterruptedException {
        return MdsTestUtil.lookupActualMdsPort(rbacClusters, 0);
    }

    public static int lookupActualMdsPort(RbacClusters rbacClusters, int brokerNumber) throws InterruptedException {
        KafkaHttpServerImpl httpServer = MdsTestUtil.getHttpServer(rbacClusters, brokerNumber);
        httpServer.awaitStarted();
        int actualMdsPort = httpServer.getPrimaryPort();
        testInfraLogger.info("Actual MDS Port is " + actualMdsPort);
        return actualMdsPort;
    }

    public static String basicAuthHeader(String username, String password) {
        String basicAuthStr = username + ":" + password;
        basicAuthStr = Base64.getEncoder().encodeToString(basicAuthStr.getBytes());
        return "Basic " + basicAuthStr;
    }

    public static String basicAuthHeader(String username) {
        return MdsTestUtil.basicAuthHeader(username, username);
    }

    public static KafkaHttpServerImpl getHttpServer(RbacClusters rbacClusters) {
        return MdsTestUtil.getHttpServer(rbacClusters, 0);
    }

    public static KafkaHttpServerImpl getHttpServer(RbacClusters rbacClusters, int brokerNumber) {
        return (KafkaHttpServerImpl)((KafkaBroker)rbacClusters.metadataCluster.kafkaBrokers().get(brokerNumber)).httpServer().get();
    }

    public static void awaitHttpServer(RbacClusters rbacClusters) throws InterruptedException {
        MdsTestUtil.getHttpServer(rbacClusters).awaitStarted();
    }

    public static int findUnusedPort() {
        return 0;
    }
}

