/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.bazaarvoice.jolt.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import io.confluent.security.authorizer.utils.JsonMapper;
import io.confluent.security.rbac.AccessPolicy;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.rbac.Role;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.testng.Assert;

public class RolesTestUtils {
    public static final Role SYSTEM_ADMIN_ROLE = RolesTestUtils.role("SystemAdmin", RolesTestUtils.clusterPolicy(Arrays.asList(RolesTestUtils.resourceOperation("All", (Collection<String>)ImmutableSet.of((Object)"All")))));
    public static final Role SECURITY_ADMIN_ROLE = RolesTestUtils.role("SecurityAdmin", RolesTestUtils.clusterPolicy(Arrays.asList(RolesTestUtils.resourceOperation("All", (Collection<String>)ImmutableSet.of((Object)"DescribeAccess")))));
    public static final Role CLUSTER_ADMIN_ROLE = RolesTestUtils.role("ClusterAdmin", RolesTestUtils.clusterPolicy(Arrays.asList(RolesTestUtils.resourceOperation("Topic", Collections.emptySet()), RolesTestUtils.resourceOperation("Group", Collections.emptySet()))));
    static final List<AccessPolicy.ResourceOperations> resourceOwnerOps = Arrays.asList(RolesTestUtils.resourceOperation("Cluster", (Collection<String>)ImmutableSet.of((Object)"DescribeAccess", (Object)"AlterAccess")), RolesTestUtils.resourceOperation("Topic", (Collection<String>)ImmutableSet.of((Object)"DescribeAccess", (Object)"AlterAccess")), RolesTestUtils.resourceOperation("Group", (Collection<String>)ImmutableSet.of((Object)"DescribeAccess", (Object)"AlterAccess")), RolesTestUtils.resourceOperation("TransactionalId", (Collection<String>)ImmutableSet.of((Object)"DescribeAccess", (Object)"AlterAccess")), RolesTestUtils.resourceOperation("Connector", (Collection<String>)ImmutableSet.of((Object)"DescribeAccess", (Object)"AlterAccess")));
    public static final Role RESOURCE_OWNER_ROLE = RolesTestUtils.role("ResourceOwner", RolesTestUtils.resourcePolicy(resourceOwnerOps));
    public static final Role DEVELOPER_READ_ROLE = RolesTestUtils.role("DeveloperRead", RolesTestUtils.resourcePolicy(Arrays.asList(RolesTestUtils.resourceOperation("Topic", Collections.emptySet()), RolesTestUtils.resourceOperation("Group", Collections.emptySet()))));
    public static final Role ORG_RESOURCE_OWNER_ROLE = RolesTestUtils.role("OrgResourceOwner", RolesTestUtils.scopedResourcePolicy("organization", resourceOwnerOps));
    public static final Role ENV_RESOURCE_OWNER_ROLE = RolesTestUtils.role("EnvResourceOwner", RolesTestUtils.scopedResourcePolicy("environment", resourceOwnerOps));

    public static Role role(String roleName) {
        return new Role(roleName, null, "public", false, new AccessPolicy("cluster", Boolean.valueOf(false), Collections.emptyList()), null);
    }

    public static Role role(String roleName, AccessPolicy accessPolicy) {
        return new Role(roleName, null, "public", Boolean.FALSE.booleanValue(), accessPolicy, null);
    }

    public static AccessPolicy clusterPolicy(Collection<AccessPolicy.ResourceOperations> resourceOperations) {
        return new AccessPolicy("cluster", Boolean.valueOf(false), resourceOperations);
    }

    public static AccessPolicy resourcePolicy(Collection<AccessPolicy.ResourceOperations> resourceOperations) {
        return new AccessPolicy("cluster", Boolean.valueOf(true), resourceOperations);
    }

    public static AccessPolicy scopedResourcePolicy(String scope, Collection<AccessPolicy.ResourceOperations> resourceOperations) {
        return new AccessPolicy(scope, Boolean.valueOf(true), resourceOperations);
    }

    public static AccessPolicy.ResourceOperations resourceOperation(String resourceType, Collection<String> operations) {
        return new AccessPolicy.ResourceOperations(resourceType, operations);
    }

    public static boolean isClusterRole(String rolename) {
        HashSet<String> clusterRoles = new HashSet<String>(Arrays.asList("SystemAdmin", "UserAdmin", "SecurityAdmin", "Operator", "ClusterAdmin"));
        return clusterRoles.contains(rolename);
    }

    public static JsonNode rolesJsonNode(String rolesFileName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(RbacRoles.class.getClassLoader().getResourceAsStream(rolesFileName)));){
            JsonNode fromFile = JsonMapper.objectMapper().readTree((Reader)reader).get("roles");
            for (JsonNode role : fromFile) {
                JsonNode policy = role.get("policy");
                if (policy == null) continue;
                ((ObjectNode)role).remove("policy");
                ArrayNode policies = (ArrayNode)role.get("policies");
                if (policies != null) {
                    policies.add(policy);
                    continue;
                }
                policies = new ArrayNode(JsonNodeFactory.instance);
                policies.add(policy);
                ((ObjectNode)role).set("policies", (JsonNode)policies);
            }
            Iterator iterator = fromFile;
            return iterator;
        }
    }

    public static JsonNode roleJsonNode(String rolesFileName, String roleName) throws IOException {
        JsonNode roles = RolesTestUtils.rolesJsonNode(rolesFileName);
        for (JsonNode r : roles) {
            if (!r.get("name").asText().equals(roleName)) continue;
            return r;
        }
        return null;
    }

    public static JsonNode rolesJsonFromRolesEndpoint(String version, int actualMdsPort, String authHeaderValue, String namespace, int expectedStatus) throws JsonProcessingException {
        Client client = ClientBuilder.newClient();
        Response response = client.target(String.format("http://localhost:%s/security", actualMdsPort)).path("/" + version + "/roles").queryParam("namespace", new Object[]{namespace}).request(new String[]{"application/json"}).header("Authorization", (Object)authHeaderValue).get();
        Assert.assertEquals((int)response.getStatus(), (int)expectedStatus);
        if (response.getStatus() != 200) {
            return null;
        }
        return JsonMapper.objectMapper().readTree((String)response.readEntity(String.class));
    }

    public static Map<String, Object> roleJsonFromRolesEndpoint(String roleName, String version, int actualMdsPort, String authHeaderValue, int expectedStatus) {
        Client client = ClientBuilder.newClient();
        Response response = client.target(String.format("http://localhost:%s/security", actualMdsPort)).path("/" + version + "/roles/" + roleName).request(new String[]{"application/json"}).header("Authorization", (Object)authHeaderValue).get();
        Assert.assertEquals((int)response.getStatus(), (int)expectedStatus);
        if (response.getStatus() != 200) {
            return null;
        }
        return (Map)JsonUtils.stringToType((String)((String)response.readEntity(String.class)), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static Role roleFromRolesEndpoint(String roleName, String version, int actualMdsPort, String authHeaderValue, int expectedStatus) {
        Client client = ClientBuilder.newClient();
        Response response = client.target(String.format("http://localhost:%s/security", actualMdsPort)).path("/" + version + "/roles/" + roleName).request(new String[]{"application/json"}).header("Authorization", (Object)authHeaderValue).get();
        Assert.assertEquals((int)response.getStatus(), (int)expectedStatus);
        if (response.getStatus() != 200) {
            return null;
        }
        return (Role)JsonUtils.stringToType((String)((String)response.readEntity(String.class)), (TypeReference)new TypeReference<Role>(){});
    }
}

