/*
 * Decompiled with CFR 0.152.
 */
package utils;

import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.security.authorizer.Scope;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;

public class ScopeBuilder {
    final String kafkaClusterId;
    final Map<String, String> subClusters = new HashMap<String, String>();
    final String niceName;

    public static ScopeBuilder withKafka(String kafkaClusterId) {
        return new ScopeBuilder(kafkaClusterId, false);
    }

    public static ScopeBuilder withNiceName(String niceName) {
        return new ScopeBuilder(niceName, true);
    }

    private ScopeBuilder(String identifier, boolean isNiceName) {
        if (isNiceName) {
            this.niceName = identifier;
            this.kafkaClusterId = "";
        } else {
            this.niceName = "";
            this.kafkaClusterId = identifier;
        }
    }

    public ScopeBuilder withConnect(String connectClusterId) {
        this.subClusters.put("connect-cluster", connectClusterId);
        return this;
    }

    public ScopeBuilder withSR(String schemaRegistryClusterId) {
        this.subClusters.put("schema-registry-cluster", schemaRegistryClusterId);
        return this;
    }

    public ScopeBuilder withKSQL(String ksqlClusterId) {
        this.subClusters.put("ksql-cluster", ksqlClusterId);
        return this;
    }

    public MdsScope build() {
        Scope.Builder builder = new Scope.Builder(new String[0]).withKafkaCluster(this.kafkaClusterId);
        if (this.subClusters.size() == 0) {
            Scope scope = builder.build();
            return new MdsScope(scope);
        }
        Assert.assertTrue((String)"Should only be one subcluster defined", (this.subClusters.size() <= 1 ? 1 : 0) != 0);
        Map.Entry<String, String> entry = this.subClusters.entrySet().iterator().next();
        builder.withCluster(entry.getKey(), entry.getValue());
        Scope scope = builder.build();
        return new MdsScope(scope);
    }

    public static boolean hasSubCluster(MdsScope mdsScope) {
        return mdsScope.scope().clusters().size() > 1;
    }

    public static String getKafkaClusterId(MdsScope mdsScope) {
        return (String)mdsScope.scope().clusters().get("kafka-cluster");
    }

    public static String getConnectClusterId(MdsScope mdsScope) {
        return (String)mdsScope.scope().clusters().get("connect-cluster");
    }
}

